/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.impl.MSSQLSocketConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactory;
import java.util.HashMap;
import java.util.Map;

class MSSQLConnectionFactory
implements ConnectionFactory {
    private final NetClient netClient;
    private final ContextInternal context;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String database;
    private final Map<String, String> properties;
    private final CloseFuture clientCloseFuture = new CloseFuture();

    MSSQLConnectionFactory(ContextInternal context, MSSQLConnectOptions options) {
        NetClientOptions netClientOptions = new NetClientOptions((NetClientOptions)options);
        this.context = context;
        this.host = options.getHost();
        this.port = options.getPort();
        this.username = options.getUser();
        this.password = options.getPassword();
        this.database = options.getDatabase();
        this.properties = new HashMap<String, String>(options.getProperties());
        this.netClient = context.owner().createNetClient(netClientOptions, this.clientCloseFuture);
    }

    public Future<Connection> connect() {
        PromiseInternal promise = this.context.promise();
        this.context.emit((Object)promise, this::doConnect);
        return promise.future();
    }

    public void doConnect(Promise<Connection> promise) {
        Future fut = this.netClient.connect(this.port, this.host);
        fut.onComplete(ar -> {
            if (ar.succeeded()) {
                NetSocket so = (NetSocket)ar.result();
                MSSQLSocketConnection conn = new MSSQLSocketConnection((NetSocketInternal)so, false, 0, sql -> true, 1, this.context);
                conn.init();
                conn.sendPreLoginMessage(false, (Handler<AsyncResult<Void>>)((Handler)preLogin -> {
                    if (preLogin.succeeded()) {
                        conn.sendLoginMessage(this.username, this.password, this.database, this.properties, (Handler<AsyncResult<Connection>>)promise);
                    } else {
                        promise.fail(preLogin.cause());
                    }
                }));
            } else {
                promise.fail(ar.cause());
            }
        });
    }

    private void close(Handler<AsyncResult<Void>> completionHandler) {
        this.netClient.close();
        completionHandler.handle((Object)Future.succeededFuture());
    }

    public void close(Promise<Void> promise) {
        this.clientCloseFuture.close(promise);
    }
}

