/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.junit;

import io.vertx.mssqlclient.MSSQLConnectOptions;
import org.junit.rules.ExternalResource;
import org.testcontainers.containers.MSSQLServerContainer;

public class MSSQLRule
extends ExternalResource {
    private MSSQLServer server;
    private MSSQLConnectOptions options;
    public static final MSSQLRule SHARED_INSTANCE = new MSSQLRule();

    protected void before() {
        if (this.server == null) {
            this.options = this.startMSSQL();
        }
    }

    protected void after() {
        if (this != SHARED_INSTANCE) {
            this.stopMSSQL();
        }
    }

    private MSSQLConnectOptions startMSSQL() {
        this.server = new MSSQLServer();
        this.server.withInitScript("init.sql");
        this.server.start();
        MSSQLConnectOptions options = new MSSQLConnectOptions().setHost(this.server.getContainerIpAddress()).setPort(this.server.getMappedPort(MSSQLServerContainer.MS_SQL_SERVER_PORT).intValue()).setUser(this.server.getUsername()).setPassword(this.server.getPassword());
        return options;
    }

    private void stopMSSQL() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            finally {
                this.server = null;
            }
        }
    }

    public MSSQLConnectOptions options() {
        return new MSSQLConnectOptions(this.options);
    }

    private static class MSSQLServer
    extends MSSQLServerContainer {
        private MSSQLServer() {
        }

        protected void configure() {
            this.addExposedPort(MSSQLServerContainer.MS_SQL_SERVER_PORT);
            this.addEnv("ACCEPT_EULA", "Y");
            this.addEnv("SA_PASSWORD", this.getPassword());
        }
    }
}

