/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.MSSQLConnection;
import io.vertx.mssqlclient.MSSQLTestBase;
import io.vertx.sqlclient.ColumnChecker;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.Numeric;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.junit.After;
import org.junit.Before;

public abstract class MSSQLDataTypeTestBase
extends MSSQLTestBase {
    Vertx vertx;
    MSSQLConnectOptions options;

    @Before
    public void setup() {
        this.vertx = Vertx.vertx();
        this.options = new MSSQLConnectOptions(MSSQLTestBase.options);
    }

    @After
    public void tearDown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    protected <T> void testQueryDecodeGenericWithoutTable(TestContext ctx, String columnName, String type, String value, Consumer<Row> checker) {
        MSSQLConnection.connect((Vertx)this.vertx, (MSSQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT CAST(" + value + " AS " + type + ") AS " + columnName).execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            checker.accept(row);
            conn.close();
        }))));
    }

    protected <T> void testQueryDecodeGenericWithoutTable(TestContext ctx, String columnName, String type, String value, T expected) {
        this.testQueryDecodeGenericWithoutTable(ctx, columnName, type, value, (T)((Consumer<Row>)row -> {
            ctx.assertEquals(expected, row.getValue(0));
            ctx.assertEquals(expected, row.getValue(columnName));
        }));
    }

    protected <T> void testPreparedQueryDecodeGenericWithoutTable(TestContext ctx, String columnName, String type, String value, Consumer<Row> checker) {
        MSSQLConnection.connect((Vertx)this.vertx, (MSSQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT CAST(" + value + " AS " + type + ") AS " + columnName).execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            checker.accept(row);
            conn.close();
        }))));
    }

    protected <T> void testPreparedQueryDecodeGenericWithoutTable(TestContext ctx, String columnName, String type, String value, T expected) {
        this.testPreparedQueryDecodeGenericWithoutTable(ctx, columnName, type, value, (T)((Consumer<Row>)row -> {
            ctx.assertEquals(expected, row.getValue(0));
            ctx.assertEquals(expected, row.getValue(columnName));
        }));
    }

    protected <T> void testQueryDecodeGeneric(TestContext ctx, String tableName, String columnName, String rowIdentifier, Consumer<Row> checker) {
        MSSQLConnection.connect((Vertx)this.vertx, (MSSQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query(String.format("SELECT %s FROM %s WHERE id = %s", columnName, tableName, rowIdentifier)).execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            checker.accept(row);
            conn.close();
        }))));
    }

    protected <T> void testPreparedQueryDecodeGeneric(TestContext ctx, String tableName, String columnName, String rowIdentifier, Consumer<Row> checker) {
        MSSQLConnection.connect((Vertx)this.vertx, (MSSQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery(String.format("SELECT %s FROM %s WHERE id = %s", columnName, tableName, rowIdentifier)).execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            checker.accept(row);
            conn.close();
        }))));
    }

    protected <T> void testPreparedQueryEncodeGeneric(TestContext ctx, String tableName, String columnName, T param, Consumer<Row> checker) {
        MSSQLConnection.connect((Vertx)this.vertx, (MSSQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery(String.format("UPDATE %s SET %s = @p1 WHERE id = 2", tableName, columnName)).execute(Tuple.of((Object)param), ctx.asyncAssertSuccess(updateRes -> conn.preparedQuery(String.format("SELECT %s FROM %s WHERE id = 2", columnName, tableName)).execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            checker.accept(row);
            conn.close();
        }))))));
    }

    static {
        ColumnChecker.load(() -> {
            ArrayList<Object> tupleMethods = new ArrayList<Object>();
            tupleMethods.add(Tuple::getValue);
            tupleMethods.add(Tuple::getShort);
            tupleMethods.add(Tuple::getInteger);
            tupleMethods.add(Tuple::getLong);
            tupleMethods.add(Tuple::getFloat);
            tupleMethods.add(Tuple::getDouble);
            tupleMethods.add(Tuple::getBigDecimal);
            tupleMethods.add(Tuple::getString);
            tupleMethods.add(Tuple::getBoolean);
            tupleMethods.add(Tuple::getLocalDate);
            tupleMethods.add(Tuple::getLocalTime);
            tupleMethods.add(ColumnChecker.getByIndex(Numeric.class));
            return tupleMethods;
        }, () -> {
            ArrayList<Object> rowMethods = new ArrayList<Object>();
            rowMethods.add(Row::getValue);
            rowMethods.add(Row::getShort);
            rowMethods.add(Row::getInteger);
            rowMethods.add(Row::getLong);
            rowMethods.add(Row::getFloat);
            rowMethods.add(Row::getDouble);
            rowMethods.add(Row::getBigDecimal);
            rowMethods.add(Row::getString);
            rowMethods.add(Row::getBoolean);
            rowMethods.add(Row::getLocalDate);
            rowMethods.add(Row::getLocalTime);
            rowMethods.add(ColumnChecker.getByName(Numeric.class));
            return rowMethods;
        });
    }
}

