/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.lang.js;

import io.vertx.test.lang.js.JSTestBase;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.junit.Assert;
import org.junit.Test;

public class RequireTest
extends JSTestBase {
    @Override
    protected String getTestFile() {
        return "require_test.js";
    }

    @Test
    public void testRequireNoExtension() throws Exception {
        this.runTest();
    }

    @Test
    public void testRequireWithExtension() throws Exception {
        this.runTest();
    }

    @Test
    public void testRequireInDirectoryNoExtension() throws Exception {
        this.runTest();
    }

    @Test
    public void testRequireInDirectoryWithExtension() throws Exception {
        this.runTest();
    }

    @Test
    public void testRequireRelative() throws Exception {
        this.runTest();
    }

    @Test
    public void testRequireNotFound() throws Exception {
        this.runTest();
    }

    @Test
    public void testBrokenModuleSyntaxError() throws Exception {
        this.runTest();
    }

    @Test
    public void testBrokenModuleTypeErrorInMainBody() throws Exception {
        this.runTest();
    }

    @Test
    public void testBrokenModuleTypeErrorInFunction() throws Exception {
        this.runTest();
    }

    @Test
    public void testTopLevelIsolated() throws Exception {
        this.runTest();
    }

    @Test
    public void testCachedRequires() throws Exception {
        this.runTest();
    }

    @Test
    public void testRequireNPMModule() throws Exception {
        this.runTest();
    }

    @Test
    public void testRequireNPMModuleUsingNodePath() throws Exception {
        this.runTest();
    }

    @Test
    public void testRequireNPMModuleUsingClassPath() throws Exception {
        class TestThread
        extends Thread {
            public String result;

            TestThread() {
            }

            @Override
            public void run() {
                try {
                    RequireTest.this.runTest("testRequireNPMModuleUsingClassPath");
                    this.result = "PASS";
                }
                catch (Throwable t) {
                    this.result = t.getMessage();
                }
            }
        }
        TestThread test = new TestThread();
        test.setContextClassLoader(new URLClassLoader(new URL[]{new File("src/test/npm/zip/my_npm_module.zip").toURI().toURL()}));
        test.start();
        test.join();
        Assert.assertEquals((Object)"PASS", (Object)test.result);
    }

    @Test
    public void testMultipleConcurrentRequires() throws Exception {
        this.runTest();
    }
}

