/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.junit5.rxjava2;

import io.vertx.core.Verticle;
import io.vertx.junit5.VertxExtension;
import io.vertx.junit5.VertxTestContext;
import io.vertx.reactivex.core.AbstractVerticle;
import io.vertx.reactivex.core.RxHelper;
import io.vertx.reactivex.core.Vertx;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={VertxExtension.class})
@DisplayName(value="Test the RxJava 2 support")
class RxJava2Test {
    RxJava2Test() {
    }

    @Test
    @DisplayName(value="Check the injection of a /io.vertx.reactivex.core.Vertx/ instance")
    void check_injection(Vertx vertx, VertxTestContext testContext) {
        testContext.verify(() -> {
            Assertions.assertThat((Object)vertx).isNotNull();
            testContext.completeNow();
        });
    }

    @Test
    @DisplayName(value="Check the deployment and interaction of a Rx1 verticle")
    void check_deployment_and_message_send(Vertx vertx, VertxTestContext testContext) {
        RxHelper.deployVerticle((Vertx)vertx, (Verticle)new RxVerticle()).flatMap(id -> vertx.eventBus().rxRequest("check", (Object)"Ok?")).subscribe(message -> testContext.verify(() -> {
            Assertions.assertThat((Object)message.body()).isEqualTo((Object)"Check!");
            testContext.completeNow();
        }), arg_0 -> ((VertxTestContext)testContext).failNow(arg_0));
    }

    static class RxVerticle
    extends AbstractVerticle {
        RxVerticle() {
        }

        public void start() throws Exception {
            this.vertx.eventBus().consumer("check", message -> message.reply((Object)"Check!"));
        }
    }
}

