/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.transcoding;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.TestContext;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpc.server.GrpcServer;
import io.vertx.grpc.server.GrpcServerResponse;
import io.vertx.grpc.transcoding.MethodTranscodingOptions;
import io.vertx.grpc.transcoding.TranscodingServiceMethod;
import io.vertx.tests.common.GrpcTestBase;
import io.vertx.tests.server.grpc.web.EchoRequest;
import io.vertx.tests.server.grpc.web.EchoRequestBody;
import io.vertx.tests.server.grpc.web.EchoResponse;
import io.vertx.tests.server.grpc.web.EchoResponseBody;
import io.vertx.tests.server.grpc.web.Empty;
import io.vertx.tests.server.grpc.web.TestServiceGrpc;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class ServerTranscodingTest
extends GrpcTestBase {
    public static GrpcMessageDecoder<Empty> EMPTY_DECODER = GrpcMessageDecoder.decoder((MessageOrBuilder)Empty.newBuilder());
    public static GrpcMessageEncoder<Empty> EMPTY_ENCODER = GrpcMessageEncoder.encoder();
    public static GrpcMessageDecoder<EchoRequest> ECHO_REQUEST_DECODER = GrpcMessageDecoder.decoder((MessageOrBuilder)EchoRequest.newBuilder());
    public static GrpcMessageDecoder<EchoRequestBody> ECHO_REQUEST_BODY_DECODER = GrpcMessageDecoder.decoder((MessageOrBuilder)EchoRequestBody.newBuilder());
    public static GrpcMessageEncoder<EchoResponse> ECHO_RESPONSE_ENCODER = GrpcMessageEncoder.encoder();
    public static GrpcMessageEncoder<EchoResponseBody> ECHO_RESPONSE_BODY_ENCODER = GrpcMessageEncoder.encoder();
    public static final ServiceName TEST_SERVICE_NAME = ServiceName.create((String)"io.vertx.tests.server.grpc.web.TestService");
    public static final MethodTranscodingOptions EMPTY_TRANSCODING = new MethodTranscodingOptions().setHttpMethod(HttpMethod.POST).setPath("/hello");
    public static final MethodTranscodingOptions UNARY_TRANSCODING = new MethodTranscodingOptions().setPath("/hello");
    public static final MethodTranscodingOptions UNARY_TRANSCODING_WITH_PARAM = new MethodTranscodingOptions().setPath("/hello/{payload}");
    public static final MethodTranscodingOptions UNARY_TRANSCODING_WITH_CUSTOM_METHOD = new MethodTranscodingOptions().setHttpMethod(HttpMethod.valueOf((String)"ACL")).setPath("/hello");
    public static final MethodTranscodingOptions UNARY_TRANSCODING_WITH_BODY = new MethodTranscodingOptions().setPath("/body").setBody("request");
    public static final MethodTranscodingOptions UNARY_TRANSCODING_WITH_RESPONSE_BODY = new MethodTranscodingOptions().setPath("/response").setResponseBody("response");
    public static final TranscodingServiceMethod<Empty, Empty> EMPTY_CALL = TranscodingServiceMethod.server((ServiceName)TEST_SERVICE_NAME, (String)"EmptyCall", EMPTY_ENCODER, EMPTY_DECODER, (MethodTranscodingOptions)EMPTY_TRANSCODING);
    public static final TranscodingServiceMethod<EchoRequest, EchoResponse> UNARY_CALL = TranscodingServiceMethod.server((ServiceName)TEST_SERVICE_NAME, (String)"UnaryCall", ECHO_RESPONSE_ENCODER, ECHO_REQUEST_DECODER, (MethodTranscodingOptions)UNARY_TRANSCODING);
    public static final TranscodingServiceMethod<EchoRequest, EchoResponse> UNARY_CALL_WITH_PARAM = TranscodingServiceMethod.server((ServiceName)TEST_SERVICE_NAME, (String)"UnaryCallWithParam", ECHO_RESPONSE_ENCODER, ECHO_REQUEST_DECODER, (MethodTranscodingOptions)UNARY_TRANSCODING_WITH_PARAM);
    public static final TranscodingServiceMethod<EchoRequest, EchoResponse> UNARY_CALL_WITH_CUSTOM_METHOD = TranscodingServiceMethod.server((ServiceName)TEST_SERVICE_NAME, (String)"UnaryCallWithCustomMethod", ECHO_RESPONSE_ENCODER, ECHO_REQUEST_DECODER, (MethodTranscodingOptions)UNARY_TRANSCODING_WITH_CUSTOM_METHOD);
    public static final TranscodingServiceMethod<EchoRequestBody, EchoResponse> UNARY_CALL_WITH_BODY = TranscodingServiceMethod.server((ServiceName)TEST_SERVICE_NAME, (String)"UnaryCallWithBody", ECHO_RESPONSE_ENCODER, ECHO_REQUEST_BODY_DECODER, (MethodTranscodingOptions)UNARY_TRANSCODING_WITH_BODY);
    public static final TranscodingServiceMethod<EchoRequest, EchoResponseBody> UNARY_CALL_WITH_RESPONSE_BODY = TranscodingServiceMethod.server((ServiceName)TEST_SERVICE_NAME, (String)"UnaryCallWithResponseBody", ECHO_RESPONSE_BODY_ENCODER, ECHO_REQUEST_DECODER, (MethodTranscodingOptions)UNARY_TRANSCODING_WITH_RESPONSE_BODY);
    private static final CharSequence USER_AGENT = HttpHeaders.createOptimized((String)"X-User-Agent");
    private static final String CONTENT_TYPE = "application/json";
    private static final MultiMap HEADERS = HttpHeaders.headers().add(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").add(HttpHeaders.USER_AGENT, USER_AGENT).add(HttpHeaders.ACCEPT, (CharSequence)"application/json").copy(false);
    private static final Empty EMPTY_DEFAULT_INSTANCE = Empty.getDefaultInstance();
    private HttpClient httpClient;
    private HttpServer httpServer;

    public static MethodTranscodingOptions create(String selector, HttpMethod httpMethod, String path, String body, String responseBody, MethodTranscodingOptions ... additionalBindings) {
        MethodTranscodingOptions ret = new MethodTranscodingOptions().setSelector(selector).setHttpMethod(httpMethod).setPath(path).setBody(body).setResponseBody(responseBody);
        if (additionalBindings != null) {
            ret.getAdditionalBindings().addAll(Arrays.asList(additionalBindings));
        }
        return ret;
    }

    public void setUp(TestContext should) {
        super.setUp(should);
        this.httpClient = this.vertx.createHttpClient(new HttpClientOptions().setDefaultPort(this.port).setProtocolVersion(HttpVersion.HTTP_2));
        GrpcServer grpcServer = GrpcServer.server((Vertx)this.vertx);
        grpcServer.callHandler(EMPTY_CALL, request -> {
            ServerTranscodingTest.copyHeaders(request.headers(), request.response().headers());
            ServerTranscodingTest.copyTrailers(request.headers(), request.response().trailers());
            request.response().end((Object)Empty.newBuilder().build());
        });
        grpcServer.callHandler(UNARY_CALL, request -> request.handler(requestMsg -> {
            GrpcServerResponse response = request.response();
            ServerTranscodingTest.copyHeaders(request.headers(), response.headers());
            ServerTranscodingTest.copyTrailers(request.headers(), response.trailers());
            String payload = requestMsg.getPayload();
            if ("boom".equals(payload)) {
                response.trailers().set("x-error-trailer", "boom");
                response.status(GrpcStatus.INTERNAL).end();
            } else {
                EchoResponse responseMsg = EchoResponse.newBuilder().setPayload(payload).build();
                response.end((Object)responseMsg);
            }
        }));
        grpcServer.callHandler(UNARY_CALL_WITH_PARAM, request -> request.handler(requestMsg -> {
            GrpcServerResponse response = request.response();
            ServerTranscodingTest.copyHeaders(request.headers(), response.headers());
            ServerTranscodingTest.copyTrailers(request.headers(), response.trailers());
            String payload = requestMsg.getPayload();
            if ("boom".equals(payload)) {
                response.trailers().set("x-error-trailer", "boom");
                response.status(GrpcStatus.INTERNAL).end();
            } else {
                EchoResponse responseMsg = EchoResponse.newBuilder().setPayload(payload).build();
                response.end((Object)responseMsg);
            }
        }));
        grpcServer.callHandler(UNARY_CALL_WITH_CUSTOM_METHOD, request -> request.handler(requestMsg -> {
            GrpcServerResponse response = request.response();
            ServerTranscodingTest.copyHeaders(request.headers(), response.headers());
            ServerTranscodingTest.copyTrailers(request.headers(), response.trailers());
            String payload = requestMsg.getPayload();
            if ("boom".equals(payload)) {
                response.trailers().set("x-error-trailer", "boom");
                response.status(GrpcStatus.INTERNAL).end();
            } else {
                EchoResponse responseMsg = EchoResponse.newBuilder().setPayload(payload).build();
                response.end((Object)responseMsg);
            }
        }));
        grpcServer.callHandler(UNARY_CALL_WITH_BODY, request -> request.handler(requestMsg -> {
            GrpcServerResponse response = request.response();
            ServerTranscodingTest.copyHeaders(request.headers(), response.headers());
            ServerTranscodingTest.copyTrailers(request.headers(), response.trailers());
            String payload = requestMsg.getRequest().getPayload();
            if ("boom".equals(payload)) {
                response.trailers().set("x-error-trailer", "boom");
                response.status(GrpcStatus.INTERNAL).end();
            } else {
                EchoResponse responseMsg = EchoResponse.newBuilder().setPayload(payload).build();
                response.end((Object)responseMsg);
            }
        }));
        grpcServer.callHandler(UNARY_CALL_WITH_RESPONSE_BODY, request -> request.handler(requestMsg -> {
            GrpcServerResponse response = request.response();
            ServerTranscodingTest.copyHeaders(request.headers(), response.headers());
            ServerTranscodingTest.copyTrailers(request.headers(), response.trailers());
            String payload = requestMsg.getPayload();
            if ("boom".equals(payload)) {
                response.trailers().set("x-error-trailer", "boom");
                response.status(GrpcStatus.INTERNAL).end();
            } else {
                EchoResponse responseMsg = EchoResponse.newBuilder().setPayload(payload).build();
                EchoResponseBody responseBody = EchoResponseBody.newBuilder().setResponse(responseMsg).build();
                response.end((Object)responseBody);
            }
        }));
        this.httpServer = this.vertx.createHttpServer(new HttpServerOptions().setPort(this.port)).requestHandler((Handler)grpcServer);
        this.httpServer.listen().onComplete(should.asyncAssertSuccess());
    }

    public void tearDown(TestContext should) {
        this.httpServer.close().onComplete(should.asyncAssertSuccess());
        this.httpClient.close().onComplete(should.asyncAssertSuccess());
        super.tearDown(should);
    }

    static void copyHeaders(MultiMap src, MultiMap headers) {
        ServerTranscodingTest.copyMetadata(src, headers, "x-header-text-key", "x-header-bin-key-bin");
    }

    static void copyTrailers(MultiMap src, MultiMap headers) {
        ServerTranscodingTest.copyMetadata(src, headers, "x-trailer-text-key", "x-trailer-bin-key-bin");
    }

    public static void copyMetadata(MultiMap src, MultiMap dst, String ... keys) {
        for (String key : keys) {
            if (!src.contains(key)) continue;
            dst.set(key, src.get(key));
        }
    }

    @Test
    public void testEmpty(TestContext should) {
        this.httpClient.request(HttpMethod.POST, "/hello").compose(req -> {
            req.headers().addAll(HEADERS);
            return req.send().compose(response -> response.body().map(response));
        }).onComplete(should.asyncAssertSuccess(response -> should.verify(v -> {
            Assert.assertEquals((long)200L, (long)response.statusCode());
            MultiMap headers = response.headers();
            Assert.assertTrue((boolean)headers.contains(HttpHeaders.CONTENT_TYPE, (CharSequence)CONTENT_TYPE, true));
            Assert.assertEquals((long)Integer.parseInt(headers.get(HttpHeaders.CONTENT_LENGTH)), (long)((Buffer)response.body().result()).length());
            JsonObject body = this.decodeBody((Buffer)response.body().result());
            Assert.assertEquals((long)0L, (long)body.size());
        })));
    }

    @Test
    public void testPayload(TestContext should) {
        String payload = "foobar";
        this.httpClient.request(HttpMethod.GET, "/hello/" + payload).compose(req -> {
            req.headers().addAll(HEADERS);
            return req.send().compose(response -> response.body().map(response));
        }).onComplete(should.asyncAssertSuccess(response -> should.verify(v -> {
            Assert.assertEquals((long)200L, (long)response.statusCode());
            MultiMap headers = response.headers();
            Assert.assertTrue((boolean)headers.contains(HttpHeaders.CONTENT_TYPE, (CharSequence)CONTENT_TYPE, true));
            JsonObject body = this.decodeBody((Buffer)response.body().result());
            Assert.assertEquals((Object)payload, (Object)body.getString("payload"));
        })));
    }

    @Test
    public void testPayloadWithQuery(TestContext should) {
        String payload = "foobar";
        this.httpClient.request(HttpMethod.GET, "/hello?payload=" + payload).compose(req -> {
            req.headers().addAll(HEADERS);
            return req.send().compose(response -> response.body().map(response));
        }).onComplete(should.asyncAssertSuccess(response -> should.verify(v -> {
            Assert.assertEquals((long)200L, (long)response.statusCode());
            MultiMap headers = response.headers();
            Assert.assertTrue((boolean)headers.contains(HttpHeaders.CONTENT_TYPE, (CharSequence)CONTENT_TYPE, true));
            JsonObject body = this.decodeBody((Buffer)response.body().result());
            Assert.assertEquals((Object)payload, (Object)body.getString("payload"));
        })));
    }

    @Test
    public void testPayloadWithBody(TestContext should) {
        String payload = "foobar";
        this.httpClient.request(HttpMethod.GET, "/hello").compose(req -> {
            String body = this.encode((Message)EchoRequest.newBuilder().setPayload("foobar").build()).toString();
            req.headers().addAll(HEADERS);
            req.headers().set(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(body.length()));
            return req.send(body).compose(response -> response.body().map(response));
        }).onComplete(should.asyncAssertSuccess(response -> should.verify(v -> {
            Assert.assertEquals((long)200L, (long)response.statusCode());
            MultiMap headers = response.headers();
            Assert.assertTrue((boolean)headers.contains(HttpHeaders.CONTENT_TYPE, (CharSequence)CONTENT_TYPE, true));
            JsonObject body = this.decodeBody((Buffer)response.body().result());
            Assert.assertEquals((Object)payload, (Object)body.getString("payload"));
        })));
    }

    @Test
    public void testPayloadWithBodyOverflow(TestContext should) {
        String body = "{\"payload\":\"" + "a".repeat(262131) + "\"}";
        Assert.assertTrue(((long)body.length() > 262144L ? 1 : 0) != 0);
        this.httpClient.request(HttpMethod.GET, "/hello").compose(req -> {
            req.headers().addAll(HEADERS);
            req.headers().set(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(body.length()));
            return req.send(body).compose(response -> response.body().map(response));
        }).onComplete(should.asyncAssertSuccess(response -> should.verify(v -> Assert.assertEquals((long)429L, (long)response.statusCode()))));
    }

    @Test
    public void testNestedQueryBody(TestContext should) {
        String payload = "foobar";
        this.httpClient.request(HttpMethod.GET, "/body?request.payload=" + payload).compose(req -> {
            req.headers().addAll(HEADERS);
            return req.send().compose(response -> response.body().map(response));
        }).onComplete(should.asyncAssertSuccess(response -> should.verify(v -> {
            Assert.assertEquals((long)200L, (long)response.statusCode());
            MultiMap headers = response.headers();
            Assert.assertTrue((boolean)headers.contains(HttpHeaders.CONTENT_TYPE, (CharSequence)CONTENT_TYPE, true));
            JsonObject body = this.decodeBody((Buffer)response.body().result());
            Assert.assertEquals((Object)payload, (Object)body.getString("payload"));
        })));
    }

    @Test
    public void testInvalidPayload(TestContext should) {
        String payload = "boom";
        this.httpClient.request(HttpMethod.GET, "/hello").compose(req -> {
            req.headers().addAll(HEADERS);
            return req.send(payload).compose(response -> response.body().map(response));
        }).onComplete(should.asyncAssertSuccess(response -> should.verify(v -> {
            Assert.assertEquals((long)400L, (long)response.statusCode());
            MultiMap headers = response.headers();
        })));
    }

    @Test
    public void testCustomMethod(TestContext should) {
        String payload = "foobar";
        this.httpClient.request(HttpMethod.ACL, "/hello").compose(req -> {
            String body = this.encode((Message)EchoRequest.newBuilder().setPayload(payload).build()).toString();
            req.headers().addAll(HEADERS);
            return req.send(body).compose(response -> response.body().map(response));
        }).onComplete(should.asyncAssertSuccess(response -> should.verify(v -> {
            Assert.assertEquals((long)200L, (long)response.statusCode());
            MultiMap headers = response.headers();
            Assert.assertTrue((boolean)headers.contains(HttpHeaders.CONTENT_TYPE, (CharSequence)CONTENT_TYPE, true));
            JsonObject body = this.decodeBody((Buffer)response.body().result());
            Assert.assertEquals((Object)payload, (Object)body.getString("payload"));
        })));
    }

    @Test
    public void testMethodWithRequestBody(TestContext should) {
        String payload = "foobar";
        this.httpClient.request(HttpMethod.GET, "/body").compose(req -> {
            String body = this.encode((Message)EchoRequest.newBuilder().setPayload(payload).build()).toString();
            req.headers().addAll(HEADERS);
            return req.send(body).compose(response -> response.body().map(response));
        }).onComplete(should.asyncAssertSuccess(response -> should.verify(v -> {
            Assert.assertEquals((long)200L, (long)response.statusCode());
            MultiMap headers = response.headers();
            Assert.assertTrue((boolean)headers.contains(HttpHeaders.CONTENT_TYPE, (CharSequence)CONTENT_TYPE, true));
            JsonObject body = this.decodeBody((Buffer)response.body().result());
            Assert.assertEquals((Object)payload, (Object)body.getString("payload"));
        })));
    }

    @Test
    public void testMethodWithErrorRequestBody(TestContext should) {
        String payload = "boom";
        this.httpClient.request(HttpMethod.GET, "/body").compose(req -> {
            String body = this.encode((Message)EchoRequest.newBuilder().setPayload(payload).build()).toString();
            req.headers().addAll(HEADERS);
            return req.send(body).compose(response -> response.body().map(response));
        }).onComplete(should.asyncAssertSuccess(response -> should.verify(v -> {
            Assert.assertEquals((long)500L, (long)response.statusCode());
            MultiMap headers = response.headers();
            Assert.assertTrue((boolean)headers.contains(HttpHeaders.CONTENT_TYPE, (CharSequence)CONTENT_TYPE, true));
        })));
    }

    @Test
    public void testMethodWithMalformedRequestBody(TestContext should) {
        String payload = "malformatedbody";
        this.httpClient.request(HttpMethod.GET, "/body").compose(req -> {
            req.headers().addAll(HEADERS);
            return req.send(payload).compose(response -> response.body().map(response));
        }).onComplete(should.asyncAssertSuccess(response -> should.verify(v -> {
            Assert.assertEquals((long)400L, (long)response.statusCode());
            MultiMap headers = response.headers();
        })));
    }

    @Test
    public void testMethodWithResponseBody(TestContext should) {
        String payload = "foobar";
        this.httpClient.request(HttpMethod.GET, "/response").compose(req -> {
            String body = this.encode((Message)EchoRequest.newBuilder().setPayload(payload).build()).toString();
            req.headers().addAll(HEADERS);
            return req.send(body).compose(response -> response.body().map(response));
        }).onComplete(should.asyncAssertSuccess(response -> should.verify(v -> {
            Assert.assertEquals((long)200L, (long)response.statusCode());
            MultiMap headers = response.headers();
            Assert.assertTrue((boolean)headers.contains(HttpHeaders.CONTENT_TYPE, (CharSequence)CONTENT_TYPE, true));
            JsonObject body = this.decodeBody((Buffer)response.body().result());
            Assert.assertEquals((Object)payload, (Object)body.getString("payload"));
        })));
    }

    private Buffer encode(Message message) {
        BufferInternal buffer = BufferInternal.buffer();
        try {
            String json = JsonFormat.printer().print((MessageOrBuilder)message);
            buffer.appendString(json);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    private JsonObject decodeBody(Buffer body) {
        String json = body.toString();
        return new JsonObject(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttp2Proto() {
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)"localhost", (int)this.port).usePlaintext().build();
        try {
            TestServiceGrpc.TestServiceBlockingStub client = TestServiceGrpc.newBlockingStub((Channel)channel);
            EchoResponse response = client.unaryCall(EchoRequest.newBuilder().setPayload("hello").build());
            Assert.assertEquals((Object)"hello", (Object)response.getPayload());
        }
        finally {
            channel.shutdown();
        }
    }
}

