/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.transcoding;

import io.vertx.core.http.HttpMethod;
import io.vertx.grpc.transcoding.MethodTranscodingOptions;
import io.vertx.grpc.transcoding.impl.PathMatcher;
import io.vertx.grpc.transcoding.impl.PathMatcherBuilder;
import io.vertx.grpc.transcoding.impl.PathMatcherUtility;
import io.vertx.tests.transcoding.ServerTranscodingTest;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class PathMatcherUtilityTest {
    private final String method1 = "method1";
    private final String method2 = "method2";

    @Test
    public void testNeverRegister() {
        MethodTranscodingOptions options = ServerTranscodingTest.create("selector", HttpMethod.GET, "/path", "body", "response", new MethodTranscodingOptions[0]);
        PathMatcherBuilder pmb = new PathMatcherBuilder();
        Assert.assertTrue((boolean)PathMatcherUtility.registerByHttpRule((PathMatcherBuilder)pmb, (MethodTranscodingOptions)options, (String)"method1"));
        PathMatcher pm = pmb.build();
        Assert.assertNull((Object)pm.lookup("GET", "/any/path"));
    }

    @Test
    public void testRegisterGet() {
        MethodTranscodingOptions options = ServerTranscodingTest.create("selector", HttpMethod.GET, "/path", "body", "response", new MethodTranscodingOptions[0]);
        PathMatcherBuilder pmb = new PathMatcherBuilder();
        Assert.assertTrue((boolean)PathMatcherUtility.registerByHttpRule((PathMatcherBuilder)pmb, (MethodTranscodingOptions)options, (String)"method1"));
        HashSet<String> queryParams = new HashSet<String>(List.of("key"));
        Assert.assertFalse((boolean)PathMatcherUtility.registerByHttpRule((PathMatcherBuilder)pmb, (MethodTranscodingOptions)options, queryParams, (String)"method2"));
    }

    @Test
    public void testRegisterPut() {
        MethodTranscodingOptions options = ServerTranscodingTest.create("selector", HttpMethod.PUT, "/path", "body", "response", new MethodTranscodingOptions[0]);
        PathMatcherBuilder pmb = new PathMatcherBuilder();
        Assert.assertTrue((boolean)PathMatcherUtility.registerByHttpRule((PathMatcherBuilder)pmb, (MethodTranscodingOptions)options, (String)"method1"));
        HashSet<String> queryParams = new HashSet<String>(List.of("key"));
        Assert.assertFalse((boolean)PathMatcherUtility.registerByHttpRule((PathMatcherBuilder)pmb, (MethodTranscodingOptions)options, queryParams, (String)"method2"));
    }

    @Test
    public void testRegisterPost() {
        MethodTranscodingOptions options = ServerTranscodingTest.create("selector", HttpMethod.POST, "/path", "body", "response", new MethodTranscodingOptions[0]);
        PathMatcherBuilder pmb = new PathMatcherBuilder();
        Assert.assertTrue((boolean)PathMatcherUtility.registerByHttpRule((PathMatcherBuilder)pmb, (MethodTranscodingOptions)options, (String)"method1"));
        HashSet<String> queryParams = new HashSet<String>(List.of("key"));
        Assert.assertFalse((boolean)PathMatcherUtility.registerByHttpRule((PathMatcherBuilder)pmb, (MethodTranscodingOptions)options, queryParams, (String)"method2"));
    }

    @Test
    public void testRegisterDelete() {
        MethodTranscodingOptions options = ServerTranscodingTest.create("selector", HttpMethod.DELETE, "/path", "body", "response", new MethodTranscodingOptions[0]);
        PathMatcherBuilder pmb = new PathMatcherBuilder();
        Assert.assertTrue((boolean)PathMatcherUtility.registerByHttpRule((PathMatcherBuilder)pmb, (MethodTranscodingOptions)options, (String)"method1"));
        HashSet<String> queryParams = new HashSet<String>(List.of("key"));
        Assert.assertFalse((boolean)PathMatcherUtility.registerByHttpRule((PathMatcherBuilder)pmb, (MethodTranscodingOptions)options, queryParams, (String)"method2"));
    }

    @Test
    public void testRegisterPatch() {
        MethodTranscodingOptions options = ServerTranscodingTest.create("selector", HttpMethod.PATCH, "/path", "body", "response", new MethodTranscodingOptions[0]);
        PathMatcherBuilder pmb = new PathMatcherBuilder();
        Assert.assertTrue((boolean)PathMatcherUtility.registerByHttpRule((PathMatcherBuilder)pmb, (MethodTranscodingOptions)options, (String)"method1"));
        HashSet<String> queryParams = new HashSet<String>(List.of("key"));
        Assert.assertFalse((boolean)PathMatcherUtility.registerByHttpRule((PathMatcherBuilder)pmb, (MethodTranscodingOptions)options, queryParams, (String)"method2"));
    }

    @Test
    public void testRegisterCustom() {
        MethodTranscodingOptions options = ServerTranscodingTest.create("selector", HttpMethod.OPTIONS, "/custom_path", "body", "response", new MethodTranscodingOptions[0]);
        PathMatcherBuilder pmb = new PathMatcherBuilder();
        Assert.assertTrue((boolean)PathMatcherUtility.registerByHttpRule((PathMatcherBuilder)pmb, (MethodTranscodingOptions)options, (String)"method1"));
        HashSet<String> queryParams = new HashSet<String>(List.of("key"));
        Assert.assertFalse((boolean)PathMatcherUtility.registerByHttpRule((PathMatcherBuilder)pmb, (MethodTranscodingOptions)options, queryParams, (String)"method2"));
    }

    @Test
    public void testRegisterAdditionalBindings() {
        MethodTranscodingOptions options = ServerTranscodingTest.create("selector", HttpMethod.GET, "/path", "body", "response", ServerTranscodingTest.create("selector", HttpMethod.OPTIONS, "/custom_path", "body1", "response", new MethodTranscodingOptions[0]), ServerTranscodingTest.create("selector", HttpMethod.HEAD, "/path", null, "response", new MethodTranscodingOptions[0]), ServerTranscodingTest.create("selector", HttpMethod.PUT, "/put_path", null, "response", new MethodTranscodingOptions[0]));
        PathMatcherBuilder pmb = new PathMatcherBuilder();
        Assert.assertTrue((boolean)PathMatcherUtility.registerByHttpRule((PathMatcherBuilder)pmb, (MethodTranscodingOptions)options, (String)"method1"));
        HashSet<String> queryParams = new HashSet<String>(List.of("key"));
        Assert.assertFalse((boolean)PathMatcherUtility.registerByHttpRule((PathMatcherBuilder)pmb, (MethodTranscodingOptions)options, queryParams, (String)"method2"));
    }

    @Test
    public void testRegisterRootPath() {
        MethodTranscodingOptions options = ServerTranscodingTest.create("selector", HttpMethod.GET, "/", "body", "response", new MethodTranscodingOptions[0]);
        PathMatcherBuilder pmb = new PathMatcherBuilder();
        Assert.assertTrue((boolean)PathMatcherUtility.registerByHttpRule((PathMatcherBuilder)pmb, (MethodTranscodingOptions)options, (String)"method1"));
        HashSet<String> queryParams = new HashSet<String>(List.of("key"));
        Assert.assertFalse((boolean)PathMatcherUtility.registerByHttpRule((PathMatcherBuilder)pmb, (MethodTranscodingOptions)options, queryParams, (String)"method2"));
    }
}

