/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.transcoding;

import io.vertx.core.http.HttpMethod;
import io.vertx.grpc.transcoding.MethodTranscodingOptions;
import io.vertx.grpc.transcoding.impl.PathMatcher;
import io.vertx.grpc.transcoding.impl.PathMatcherBuilder;
import io.vertx.grpc.transcoding.impl.PathMatcherLookupResult;
import io.vertx.grpc.transcoding.impl.PercentEncoding;
import io.vertx.grpc.transcoding.impl.config.HttpVariableBinding;
import io.vertx.tests.transcoding.ServerTranscodingTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class PathMatcherTest {
    private final PathMatcherBuilder builder = new PathMatcherBuilder();
    private PathMatcher matcher;
    private final List<String> storedMethods = new ArrayList<String>();

    private String addPathWithBodyFieldPath(String httpMethod, String httpTemplate, String bodyFieldPath) {
        String method = "method_" + this.storedMethods.size();
        MethodTranscodingOptions transcodingOptions = ServerTranscodingTest.create("selector", HttpMethod.valueOf((String)httpMethod), httpTemplate, bodyFieldPath, "response", new MethodTranscodingOptions[0]);
        Assert.assertTrue((boolean)this.builder.register(transcodingOptions, method));
        this.storedMethods.add(method);
        return method;
    }

    private String addPathWithSystemParams(String httpMethod, String httpTemplate, Set<String> systemParams) {
        String method = "method_" + this.storedMethods.size();
        MethodTranscodingOptions transcodingOptions = ServerTranscodingTest.create("selector", HttpMethod.valueOf((String)httpMethod), httpTemplate, "", "response", new MethodTranscodingOptions[0]);
        Assert.assertTrue((boolean)this.builder.register(transcodingOptions, systemParams, method));
        this.storedMethods.add(method);
        return method;
    }

    private String addPath(String httpMethod, String httpTemplate) {
        return this.addPathWithBodyFieldPath(httpMethod, httpTemplate, "");
    }

    private String addGetPath(String path) {
        return this.addPath("GET", path);
    }

    private void build() {
        this.matcher = this.builder.build();
    }

    private PathMatcherLookupResult lookup(String method, String path) {
        return this.matcher.lookup(method, path, "");
    }

    private String lookupNoBindings(String method, String path) {
        return this.matcher.lookup(method, path);
    }

    private void assertVariableList(List<HttpVariableBinding> expected, List<HttpVariableBinding> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            this.assertVariable(expected.get(i), actual.get(i));
        }
    }

    private void assertVariable(HttpVariableBinding expected, HttpVariableBinding actual) {
        Assert.assertEquals((Object)expected.getFieldPath(), (Object)actual.getFieldPath());
        Assert.assertEquals((Object)expected.getValue(), (Object)actual.getValue());
    }

    private void multiSegmentMatchWithReservedCharactersBase(String expectedComponent) {
        String path = this.addGetPath("/a/{x=*}/{y=**}/c");
        this.build();
        PathMatcherLookupResult result = this.lookup("GET", "/a/%21%23%24%26%27%28%29%2A%2B%2C%2F%3A%3B%3D%3F%40%5B%5D/%21%23%24%26%27%28%29%2A%2B%2C%2F%3A%3B%3D%3F%40%5B%5D/c");
        Assert.assertEquals((Object)path, (Object)result.getMethod());
        this.assertVariableList(Arrays.asList(new HttpVariableBinding(Collections.singletonList("x"), "!#$&'()*+,/:;=?@[]"), new HttpVariableBinding(Collections.singletonList("y"), expectedComponent)), result.getVariableBindings());
    }

    @Test
    public void testWildCardMatchesRoot() {
        String data = this.addGetPath("/**");
        this.build();
        Assert.assertEquals((Object)data, (Object)this.lookupNoBindings("GET", "/"));
        Assert.assertEquals((Object)data, (Object)this.lookupNoBindings("GET", "/a"));
        Assert.assertEquals((Object)data, (Object)this.lookupNoBindings("GET", "/a/"));
    }

    @Test
    public void testWildCardMatches() {
        String pathA = this.addGetPath("/a/**");
        String pathB = this.addGetPath("/b/*");
        String pathCD = this.addGetPath("/c/*/d/**");
        String pathCDE = this.addGetPath("/c/*/d/e");
        String pathCFDE = this.addGetPath("/c/f/d/e");
        String root = this.addGetPath("/");
        this.build();
        Assert.assertEquals((Object)pathA, (Object)this.lookupNoBindings("GET", "/a/b"));
        Assert.assertEquals((Object)pathA, (Object)this.lookupNoBindings("GET", "/a/b/c"));
        Assert.assertEquals((Object)pathB, (Object)this.lookupNoBindings("GET", "/b/c"));
        Assert.assertNull((Object)this.lookupNoBindings("GET", "b/c/d"));
        Assert.assertEquals((Object)pathCD, (Object)this.lookupNoBindings("GET", "/c/u/d/v"));
        Assert.assertEquals((Object)pathCD, (Object)this.lookupNoBindings("GET", "/c/v/d/w/x"));
        Assert.assertNull((Object)this.lookupNoBindings("GET", "/c/x/y/d/z"));
        Assert.assertNull((Object)this.lookupNoBindings("GET", "/c//v/d/w/x"));
        Assert.assertEquals((Object)pathCDE, (Object)this.lookupNoBindings("GET", "/c/x/d/e"));
        Assert.assertEquals((Object)pathCFDE, (Object)this.lookupNoBindings("GET", "/c/f/d/e"));
        Assert.assertEquals((Object)root, (Object)this.lookupNoBindings("GET", "/"));
    }

    @Test
    public void testVariableBindings() {
        String pathACDE = this.addGetPath("/a/{x}/c/d/e");
        String pathABC = this.addGetPath("/{x=a/*}/b/{y=*}/c");
        String pathABD = this.addGetPath("/a/{x=b/*}/{y=d/**}");
        String pathAlphaBetaGamma = this.addGetPath("/alpha/{x=*}/beta/{y=**}/gamma");
        String pathA = this.addGetPath("/{x=*}/a");
        String pathAB = this.addGetPath("/{x=**}/a/b");
        String pathAB0 = this.addGetPath("/a/b/{x=*}");
        String pathABC0 = this.addGetPath("/a/b/c/{x=**}");
        String pathDEF = this.addGetPath("/{x=*}/d/e/f/{y=**}");
        this.build();
        PathMatcherLookupResult result = this.lookup("GET", "/a/book/c/d/e");
        Assert.assertEquals((Object)pathACDE, (Object)result.getMethod());
        this.assertVariableList(Collections.singletonList(new HttpVariableBinding(Collections.singletonList("x"), "book")), result.getVariableBindings());
        result = this.lookup("GET", "/a/hello/b/world/c");
        Assert.assertEquals((Object)pathABC, (Object)result.getMethod());
        this.assertVariableList(Arrays.asList(new HttpVariableBinding(Collections.singletonList("x"), "a/hello"), new HttpVariableBinding(Collections.singletonList("y"), "world")), result.getVariableBindings());
        result = this.lookup("GET", "/a/b/zoo/d/animal/tiger");
        Assert.assertEquals((Object)pathABD, (Object)result.getMethod());
        this.assertVariableList(Arrays.asList(new HttpVariableBinding(Collections.singletonList("x"), "b/zoo"), new HttpVariableBinding(Collections.singletonList("y"), "d/animal/tiger")), result.getVariableBindings());
        result = this.lookup("GET", "/alpha/dog/beta/eat/bones/gamma");
        Assert.assertEquals((Object)pathAlphaBetaGamma, (Object)result.getMethod());
        this.assertVariableList(Arrays.asList(new HttpVariableBinding(Collections.singletonList("x"), "dog"), new HttpVariableBinding(Collections.singletonList("y"), "eat/bones")), result.getVariableBindings());
        result = this.lookup("GET", "/foo/a");
        Assert.assertEquals((Object)pathA, (Object)result.getMethod());
        this.assertVariableList(Collections.singletonList(new HttpVariableBinding(Collections.singletonList("x"), "foo")), result.getVariableBindings());
        result = this.lookup("GET", "/foo/bar/a/b");
        Assert.assertEquals((Object)pathAB, (Object)result.getMethod());
        this.assertVariableList(Collections.singletonList(new HttpVariableBinding(Collections.singletonList("x"), "foo/bar")), result.getVariableBindings());
        result = this.lookup("GET", "/a/b/foo");
        Assert.assertEquals((Object)pathAB0, (Object)result.getMethod());
        this.assertVariableList(Collections.singletonList(new HttpVariableBinding(Collections.singletonList("x"), "foo")), result.getVariableBindings());
        result = this.lookup("GET", "/a/b/c/foo/bar/baz");
        Assert.assertEquals((Object)pathABC0, (Object)result.getMethod());
        this.assertVariableList(Collections.singletonList(new HttpVariableBinding(Collections.singletonList("x"), "foo/bar/baz")), result.getVariableBindings());
        result = this.lookup("GET", "/foo/d/e/f/bar/baz");
        Assert.assertEquals((Object)pathDEF, (Object)result.getMethod());
        this.assertVariableList(Arrays.asList(new HttpVariableBinding(Collections.singletonList("x"), "foo"), new HttpVariableBinding(Collections.singletonList("y"), "bar/baz")), result.getVariableBindings());
    }

    @Test
    public void testPercentEscapesUnescapedForSingleSegment() {
        String path = this.addGetPath("/a/{x}/c");
        this.build();
        PathMatcherLookupResult result = this.lookup("GET", "/a/p%20q%2Fr+/c");
        Assert.assertEquals((Object)path, (Object)result.getMethod());
        this.assertVariableList(Collections.singletonList(new HttpVariableBinding(Collections.singletonList("x"), "p q/r+")), result.getVariableBindings());
    }

    @Test
    public void testPercentEscapesUnescapedForSingleSegmentAllAsciiChars() {
        String getPath = this.addGetPath("/{x}");
        this.build();
        for (int u = 0; u < 2; ++u) {
            for (char c = '\u0000'; c < '\u007f'; c = (char)(c + '\u0001')) {
                String path = "/%" + String.format("%02x", c);
                PathMatcherLookupResult result = this.lookup("GET", path);
                Assert.assertEquals((Object)getPath, (Object)result.getMethod());
                this.assertVariableList(Collections.singletonList(new HttpVariableBinding(Collections.singletonList("x"), String.valueOf(c))), result.getVariableBindings());
            }
        }
    }

    @Test
    public void testPercentEscapesNotUnescapedForMultiSegment1() {
        String path = this.addGetPath("/a/{x=p/*/q/*}/c");
        this.build();
        PathMatcherLookupResult result = this.lookup("GET", "/a/p/foo%20foo/q/bar%2Fbar/c");
        Assert.assertEquals((Object)path, (Object)result.getMethod());
        this.assertVariableList(Collections.singletonList(new HttpVariableBinding(Collections.singletonList("x"), "p/foo foo/q/bar%2Fbar")), result.getVariableBindings());
    }

    @Test
    public void testPercentEscapesNotUnescapedForMultiSegment2() {
        String path = this.addGetPath("/a/{x=**}/c");
        this.build();
        PathMatcherLookupResult result = this.lookup("GET", "/a/p/foo%20foo/q/bar%2Fbar+/c");
        Assert.assertEquals((Object)path, (Object)result.getMethod());
        this.assertVariableList(Collections.singletonList(new HttpVariableBinding(Collections.singletonList("x"), "p/foo foo/q/bar%2Fbar+")), result.getVariableBindings());
    }

    @Test
    public void testOnlyUnreservedCharsAreUnescapedForMultiSegmentMatchUnescapeAllExceptReservedImplicit() {
        this.multiSegmentMatchWithReservedCharactersBase("%21%23%24%26%27%28%29%2A%2B%2C%2F%3A%3B%3D%3F%40%5B%5D");
    }

    @Test
    public void testOnlyUnreservedCharsAreUnescapedForMultiSegmentMatchUnescapeAllExceptReservedExplicit() {
        this.builder.setUrlUnescapeSpec(PercentEncoding.UrlUnescapeSpec.ALL_CHARACTERS_EXCEPT_RESERVED);
        this.multiSegmentMatchWithReservedCharactersBase("%21%23%24%26%27%28%29%2A%2B%2C%2F%3A%3B%3D%3F%40%5B%5D");
    }

    @Test
    public void testOnlyUnreservedCharsAreUnescapedForMultiSegmentMatchUnescapeAllExceptSlash() {
        this.builder.setUrlUnescapeSpec(PercentEncoding.UrlUnescapeSpec.ALL_CHARACTERS_EXCEPT_SLASH);
        this.multiSegmentMatchWithReservedCharactersBase("!#$&'()*+,%2F:;=?@[]");
    }

    @Test
    public void testOnlyUnreservedCharsAreUnescapedForMultiSegmentMatchUnescapeAll() {
        this.builder.setUrlUnescapeSpec(PercentEncoding.UrlUnescapeSpec.ALL_CHARACTERS);
        this.multiSegmentMatchWithReservedCharactersBase("!#$&'()*+,/:;=?@[]");
    }

    @Test
    public void testCustomVerbIssue() {
        String listPerson = this.addGetPath("/person");
        String getPerson = this.addGetPath("/person/{id=*}");
        String verb = this.addGetPath("/{x=**}:verb");
        this.build();
        PathMatcherLookupResult result = this.lookup("GET", "/person:verb");
        Assert.assertEquals((Object)verb, (Object)result.getMethod());
        this.assertVariableList(Collections.singletonList(new HttpVariableBinding(Collections.singletonList("x"), "person")), result.getVariableBindings());
        result = this.lookup("GET", "/person/jason:verb");
        Assert.assertEquals((Object)verb, (Object)result.getMethod());
        this.assertVariableList(Collections.singletonList(new HttpVariableBinding(Collections.singletonList("x"), "person/jason")), result.getVariableBindings());
        result = this.lookup("GET", "/animal:verb");
        Assert.assertEquals((Object)verb, (Object)result.getMethod());
        this.assertVariableList(Collections.singletonList(new HttpVariableBinding(Collections.singletonList("x"), "animal")), result.getVariableBindings());
        result = this.lookup("GET", "/animal/cat:verb");
        Assert.assertEquals((Object)verb, (Object)result.getMethod());
        this.assertVariableList(Collections.singletonList(new HttpVariableBinding(Collections.singletonList("x"), "animal/cat")), result.getVariableBindings());
        Assert.assertEquals((Object)listPerson, (Object)this.lookup("GET", "/person").getMethod());
        Assert.assertEquals((Object)getPerson, (Object)this.lookup("GET", "/person/jason").getMethod());
        Assert.assertNull((Object)this.lookup("GET", "/animal"));
        Assert.assertNull((Object)this.lookup("GET", "/animal/cat"));
        Assert.assertNull((Object)this.lookup("GET", "/person:other"));
        result = this.lookup("GET", "/person/jason:other");
        Assert.assertEquals((Object)getPerson, (Object)result.getMethod());
        this.assertVariableList(Collections.singletonList(new HttpVariableBinding(Collections.singletonList("id"), "jason:other")), result.getVariableBindings());
        Assert.assertNull((Object)this.lookup("GET", "/animal:other"));
        Assert.assertNull((Object)this.lookup("GET", "/animal/cat:other"));
    }
}

