/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.transcoding;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.grpc.transcoding.impl.MessageWeaver;
import io.vertx.grpc.transcoding.impl.config.HttpVariableBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessageWeaverTest {
    private List<HttpVariableBinding> bindings;

    @Before
    public void setUp() {
        this.bindings = new ArrayList<HttpVariableBinding>();
    }

    private void addBinding(String path, String value) {
        List<String> fieldPath = Arrays.asList(path.split("\\."));
        HttpVariableBinding binding = new HttpVariableBinding(fieldPath, value);
        this.bindings.add(binding);
    }

    @Test
    public void testPassThroughRequest() {
        JsonObject message = new JsonObject().put("A", (Object)new JsonObject().put("x", (Object)"a").put("by", (Object)"b").put("i", (Object)1).put("ui", (Object)2).put("i64", (Object)3).put("ui64", (Object)4).put("b", (Object)true).putNull("null").put("B", (Object)new JsonObject().put("y", (Object)"b")));
        Buffer result = MessageWeaver.weaveRequestMessage((Buffer)Buffer.buffer((String)message.encode()), new ArrayList(), null);
        Assert.assertEquals((Object)message, (Object)new JsonObject(result.toString()));
    }

    @Test
    public void testLevel0Bindings() {
        this.addBinding("_x", "a");
        this.addBinding("_y", "b");
        this.addBinding("_z", "c");
        JsonObject original = new JsonObject().put("i", (Object)10).put("x", (Object)"d");
        JsonObject expected = new JsonObject().put("i", (Object)10).put("x", (Object)"d").put("_x", (Object)"a").put("_y", (Object)"b").put("_z", (Object)"c");
        Buffer result = MessageWeaver.weaveRequestMessage((Buffer)Buffer.buffer((String)original.encode()), this.bindings, null);
        Assert.assertEquals((Object)expected, (Object)new JsonObject(result.toString()));
    }

    @Test
    public void testLevel1Bindings() {
        this.addBinding("A._x", "a");
        this.addBinding("A._y", "b");
        this.addBinding("B._x", "c");
        JsonObject original = new JsonObject().put("x", (Object)"d").put("A", (Object)new JsonObject().put("y", (Object)"e")).put("B", (Object)new JsonObject().put("z", (Object)"f"));
        JsonObject expected = new JsonObject().put("x", (Object)"d").put("A", (Object)new JsonObject().put("y", (Object)"e").put("_x", (Object)"a").put("_y", (Object)"b")).put("B", (Object)new JsonObject().put("z", (Object)"f").put("_x", (Object)"c"));
        Buffer result = MessageWeaver.weaveRequestMessage((Buffer)Buffer.buffer((String)original.encode()), this.bindings, null);
        Assert.assertEquals((Object)expected, (Object)new JsonObject(result.toString()));
    }

    @Test
    public void testLevel2Bindings() {
        this.addBinding("A.B._x", "a");
        this.addBinding("A.C._y", "b");
        this.addBinding("D.E._x", "c");
        JsonObject original = new JsonObject().put("A", (Object)new JsonObject().put("B", (Object)new JsonObject().put("x", (Object)"d")).put("y", (Object)"e").put("C", (Object)new JsonObject())).put("D", (Object)new JsonObject().put("z", (Object)"f").put("E", (Object)new JsonObject().put("u", (Object)"g")));
        JsonObject expected = new JsonObject().put("A", (Object)new JsonObject().put("B", (Object)new JsonObject().put("x", (Object)"d").put("_x", (Object)"a")).put("y", (Object)"e").put("C", (Object)new JsonObject().put("_y", (Object)"b"))).put("D", (Object)new JsonObject().put("z", (Object)"f").put("E", (Object)new JsonObject().put("u", (Object)"g").put("_x", (Object)"c")));
        Buffer result = MessageWeaver.weaveRequestMessage((Buffer)Buffer.buffer((String)original.encode()), this.bindings, null);
        Assert.assertEquals((Object)expected, (Object)new JsonObject(result.toString()));
    }

    @Test
    public void testTranscodingRequestBodyWildcard() {
        JsonObject message = new JsonObject().put("field1", (Object)"value1").put("field2", (Object)"value2");
        Buffer result = MessageWeaver.weaveRequestMessage((Buffer)Buffer.buffer((String)message.encode()), new ArrayList(), (String)"*");
        Assert.assertEquals((Object)message, (Object)new JsonObject(result.toString()));
    }

    @Test
    public void testTranscodingRequestBodyPath() {
        JsonObject message = new JsonObject().put("field1", (Object)"value1").put("field2", (Object)"value2");
        JsonObject expected = new JsonObject().put("nested", (Object)new JsonObject().put("data", (Object)message));
        Buffer result = MessageWeaver.weaveRequestMessage((Buffer)Buffer.buffer((String)message.encode()), new ArrayList(), (String)"nested.data");
        Assert.assertEquals((Object)expected, (Object)new JsonObject(result.toString()));
    }

    @Test
    public void testResponsePassThrough() {
        JsonObject message = new JsonObject().put("field1", (Object)"value1").put("field2", (Object)"value2");
        Buffer result = MessageWeaver.weaveResponseMessage((Buffer)Buffer.buffer((String)message.encode()), null);
        Assert.assertEquals((Object)message, (Object)new JsonObject(result.toString()));
    }

    @Test
    public void testResponseBodyWildcard() {
        JsonObject message = new JsonObject().put("field1", (Object)"value1").put("field2", (Object)"value2");
        Buffer result = MessageWeaver.weaveResponseMessage((Buffer)Buffer.buffer((String)message.encode()), (String)"*");
        Assert.assertEquals((Object)message, (Object)new JsonObject(result.toString()));
    }

    @Test
    public void testResponseBodyPath() {
        JsonObject nested = new JsonObject().put("field1", (Object)"value1").put("field2", (Object)"value2");
        JsonObject message = new JsonObject().put("response", (Object)new JsonObject().put("data", (Object)nested));
        Buffer result = MessageWeaver.weaveResponseMessage((Buffer)Buffer.buffer((String)message.encode()), (String)"response.data");
        Assert.assertEquals((Object)nested, (Object)new JsonObject(result.toString()));
    }

    @Test
    public void testResponseBodyInvalidPath() {
        JsonObject message = new JsonObject().put("field1", (Object)"value1");
        Assert.assertThrows(IllegalStateException.class, () -> MessageWeaver.weaveResponseMessage((Buffer)Buffer.buffer((String)message.encode()), (String)"invalid.path"));
    }

    @Test
    public void testInvalidJson() {
        Assert.assertThrows(DecodeException.class, () -> MessageWeaver.weaveRequestMessage((Buffer)Buffer.buffer((String)"invalid json"), new ArrayList(), (String)"*"));
        Assert.assertThrows(DecodeException.class, () -> MessageWeaver.weaveResponseMessage((Buffer)Buffer.buffer((String)"invalid json"), (String)"*"));
    }
}

