/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.transcoding;

import io.vertx.grpc.transcoding.impl.config.HttpTemplate;
import io.vertx.grpc.transcoding.impl.config.HttpTemplateVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class HttpTemplateTest {
    @Test
    public void testParseTest1() {
        HttpTemplate template = HttpTemplate.parse((String)"/shelves/{shelf}/books/{book}");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("shelves", "*", "books", "*"), (Object)template.getSegments());
        List<HttpTemplateVariable> expectedVariables = Arrays.asList(new HttpTemplateVariable(List.of("shelf"), 1, 2, false), new HttpTemplateVariable(List.of("book"), 3, 4, false));
        this.assertVariableList(expectedVariables, template.getVariables());
    }

    @Test
    public void testParseTest2() {
        HttpTemplate template = HttpTemplate.parse((String)"/shelves/**");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("shelves", "**"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        Assert.assertEquals(Collections.emptyList(), (Object)template.getVariables());
    }

    @Test
    public void testParseTest3a() {
        HttpTemplate template = HttpTemplate.parse((String)"/**");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(List.of("**"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        Assert.assertEquals(Collections.emptyList(), (Object)template.getVariables());
    }

    @Test
    public void testParseTest3b() {
        HttpTemplate template = HttpTemplate.parse((String)"/*");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(List.of("*"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        Assert.assertEquals(Collections.emptyList(), (Object)template.getVariables());
    }

    @Test
    public void testParseTest4a() {
        HttpTemplate template = HttpTemplate.parse((String)"/a:foo");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(List.of("a"), (Object)template.getSegments());
        Assert.assertEquals((Object)"foo", (Object)template.getVerb());
        Assert.assertEquals(Collections.emptyList(), (Object)template.getVariables());
    }

    @Test
    public void testParseTest4b() {
        HttpTemplate template = HttpTemplate.parse((String)"/a/b/c:foo");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("a", "b", "c"), (Object)template.getSegments());
        Assert.assertEquals((Object)"foo", (Object)template.getVerb());
        Assert.assertEquals(Collections.emptyList(), (Object)template.getVariables());
    }

    @Test
    public void testParseTest5() {
        HttpTemplate template = HttpTemplate.parse((String)"/*/**");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("*", "**"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        Assert.assertEquals(Collections.emptyList(), (Object)template.getVariables());
    }

    @Test
    public void testParseTest6() {
        HttpTemplate template = HttpTemplate.parse((String)"/*/a/**");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("*", "a", "**"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        Assert.assertEquals(Collections.emptyList(), (Object)template.getVariables());
    }

    @Test
    public void testParseTest7() {
        HttpTemplate template = HttpTemplate.parse((String)"/a/{a.b.c}");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("a", "*"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        List<HttpTemplateVariable> expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("a", "b", "c"), 1, 2, false));
        this.assertVariableList(expectedVariables, template.getVariables());
    }

    @Test
    public void testParseTest8() {
        HttpTemplate template = HttpTemplate.parse((String)"/a/{a.b.c=*}");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("a", "*"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        List<HttpTemplateVariable> expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("a", "b", "c"), 1, 2, false));
        this.assertVariableList(expectedVariables, template.getVariables());
    }

    @Test
    public void testParseTest9() {
        HttpTemplate template = HttpTemplate.parse((String)"/a/{b=*}");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("a", "*"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        List<HttpTemplateVariable> expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("b"), 1, 2, false));
        this.assertVariableList(expectedVariables, template.getVariables());
    }

    @Test
    public void testParseTest10() {
        HttpTemplate template = HttpTemplate.parse((String)"/a/{b=**}");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("a", "**"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        List<HttpTemplateVariable> expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("b"), 1, -1, true));
        this.assertVariableList(expectedVariables, template.getVariables());
    }

    @Test
    public void testParseTest11() {
        HttpTemplate template = HttpTemplate.parse((String)"/a/{b=c/*}");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("a", "c", "*"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        List<HttpTemplateVariable> expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("b"), 1, 3, false));
        this.assertVariableList(expectedVariables, template.getVariables());
    }

    @Test
    public void testParseTest12() {
        HttpTemplate template = HttpTemplate.parse((String)"/a/{b=c/*/d}");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("a", "c", "*", "d"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        List<HttpTemplateVariable> expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("b"), 1, 4, false));
        this.assertVariableList(expectedVariables, template.getVariables());
    }

    @Test
    public void testParseTest13() {
        HttpTemplate template = HttpTemplate.parse((String)"/a/{b=c/**}");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("a", "c", "**"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        List<HttpTemplateVariable> expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("b"), 1, -1, true));
        this.assertVariableList(expectedVariables, template.getVariables());
    }

    @Test
    public void testParseTest14() {
        HttpTemplate template = HttpTemplate.parse((String)"/a/{b=c/**}/d/e");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("a", "c", "**", "d", "e"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        List<HttpTemplateVariable> expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("b"), 1, -3, true));
        this.assertVariableList(expectedVariables, template.getVariables());
    }

    @Test
    public void testParseTest15() {
        HttpTemplate template = HttpTemplate.parse((String)"/a/{b=c/**/d}/e");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("a", "c", "**", "d", "e"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        List<HttpTemplateVariable> expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("b"), 1, -2, true));
        this.assertVariableList(expectedVariables, template.getVariables());
    }

    @Test
    public void testParseTest16() {
        HttpTemplate template = HttpTemplate.parse((String)"/a/{b=c/**/d}/e:verb");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("a", "c", "**", "d", "e"), (Object)template.getSegments());
        Assert.assertEquals((Object)"verb", (Object)template.getVerb());
        List<HttpTemplateVariable> expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("b"), 1, -2, true));
        this.assertVariableList(expectedVariables, template.getVariables());
    }

    @Test
    public void testCustomVerbTests() {
        HttpTemplate template = HttpTemplate.parse((String)"/*:verb");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(List.of("*"), (Object)template.getSegments());
        Assert.assertEquals(Collections.emptyList(), (Object)template.getVariables());
        template = HttpTemplate.parse((String)"/**:verb");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(List.of("**"), (Object)template.getSegments());
        Assert.assertEquals(Collections.emptyList(), (Object)template.getVariables());
        template = HttpTemplate.parse((String)"/{a}:verb");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(List.of("*"), (Object)template.getSegments());
        List<HttpTemplateVariable> expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("a"), 0, 1, false));
        this.assertVariableList(expectedVariables, template.getVariables());
        template = HttpTemplate.parse((String)"/a/b/*:verb");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("a", "b", "*"), (Object)template.getSegments());
        Assert.assertEquals(Collections.emptyList(), (Object)template.getVariables());
        template = HttpTemplate.parse((String)"/a/b/**:verb");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("a", "b", "**"), (Object)template.getSegments());
        Assert.assertEquals(Collections.emptyList(), (Object)template.getVariables());
        template = HttpTemplate.parse((String)"/a/b/{a}:verb");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("a", "b", "*"), (Object)template.getSegments());
        expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("a"), 2, 3, false));
        this.assertVariableList(expectedVariables, template.getVariables());
    }

    @Test
    public void testMoreVariableTests() {
        HttpTemplate template = HttpTemplate.parse((String)"/{x}");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(List.of("*"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        List<HttpTemplateVariable> expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("x"), 0, 1, false));
        this.assertVariableList(expectedVariables, template.getVariables());
        template = HttpTemplate.parse((String)"/{x.y.z}");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(List.of("*"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("x", "y", "z"), 0, 1, false));
        this.assertVariableList(expectedVariables, template.getVariables());
        template = HttpTemplate.parse((String)"/{x=*}");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(List.of("*"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("x"), 0, 1, false));
        this.assertVariableList(expectedVariables, template.getVariables());
        template = HttpTemplate.parse((String)"/{x=a/*}");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("a", "*"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("x"), 0, 2, false));
        this.assertVariableList(expectedVariables, template.getVariables());
        template = HttpTemplate.parse((String)"/{x.y.z=*/a/b}/c");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("*", "a", "b", "c"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("x", "y", "z"), 0, 3, false));
        this.assertVariableList(expectedVariables, template.getVariables());
        template = HttpTemplate.parse((String)"/{x=**}");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(List.of("**"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("x"), 0, -1, true));
        this.assertVariableList(expectedVariables, template.getVariables());
        template = HttpTemplate.parse((String)"/{x.y.z=**}");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(List.of("**"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("x", "y", "z"), 0, -1, true));
        this.assertVariableList(expectedVariables, template.getVariables());
        template = HttpTemplate.parse((String)"/{x.y.z=a/**/b}");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("a", "**", "b"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("x", "y", "z"), 0, -1, true));
        this.assertVariableList(expectedVariables, template.getVariables());
        template = HttpTemplate.parse((String)"/{x.y.z=a/**/b}/c/d");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("a", "**", "b", "c", "d"), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("x", "y", "z"), 0, -3, true));
        this.assertVariableList(expectedVariables, template.getVariables());
    }

    @Test
    public void testVariableAndCustomVerbTests() {
        HttpTemplate template = HttpTemplate.parse((String)"/{x}:verb");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(List.of("*"), (Object)template.getSegments());
        Assert.assertEquals((Object)"verb", (Object)template.getVerb());
        List<HttpTemplateVariable> expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("x"), 0, 1, false));
        this.assertVariableList(expectedVariables, template.getVariables());
        template = HttpTemplate.parse((String)"/{x.y.z}:verb");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(List.of("*"), (Object)template.getSegments());
        Assert.assertEquals((Object)"verb", (Object)template.getVerb());
        expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("x", "y", "z"), 0, 1, false));
        this.assertVariableList(expectedVariables, template.getVariables());
        template = HttpTemplate.parse((String)"/{x.y.z=*/*}:verb");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("*", "*"), (Object)template.getSegments());
        Assert.assertEquals((Object)"verb", (Object)template.getVerb());
        expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("x", "y", "z"), 0, 2, false));
        this.assertVariableList(expectedVariables, template.getVariables());
        template = HttpTemplate.parse((String)"/{x=**}:myverb");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(List.of("**"), (Object)template.getSegments());
        Assert.assertEquals((Object)"myverb", (Object)template.getVerb());
        expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("x"), 0, -1, true));
        this.assertVariableList(expectedVariables, template.getVariables());
        template = HttpTemplate.parse((String)"/{x.y.z=**}:myverb");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(List.of("**"), (Object)template.getSegments());
        Assert.assertEquals((Object)"myverb", (Object)template.getVerb());
        expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("x", "y", "z"), 0, -1, true));
        this.assertVariableList(expectedVariables, template.getVariables());
        template = HttpTemplate.parse((String)"/{x.y.z=a/**/b}:custom");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("a", "**", "b"), (Object)template.getSegments());
        Assert.assertEquals((Object)"custom", (Object)template.getVerb());
        expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("x", "y", "z"), 0, -1, true));
        this.assertVariableList(expectedVariables, template.getVariables());
        template = HttpTemplate.parse((String)"/{x.y.z=a/**/b}/c/d:custom");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Arrays.asList("a", "**", "b", "c", "d"), (Object)template.getSegments());
        Assert.assertEquals((Object)"custom", (Object)template.getVerb());
        expectedVariables = Collections.singletonList(new HttpTemplateVariable(List.of("x", "y", "z"), 0, -3, true));
        this.assertVariableList(expectedVariables, template.getVariables());
    }

    @Test
    public void testRootPath() {
        HttpTemplate template = HttpTemplate.parse((String)"/");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals(Collections.emptyList(), (Object)template.getSegments());
        Assert.assertEquals((Object)"", (Object)template.getVerb());
        Assert.assertEquals(Collections.emptyList(), (Object)template.getVariables());
    }

    @Test
    public void testErrorTests() {
        Assert.assertNull((Object)HttpTemplate.parse((String)""));
        Assert.assertNull((Object)HttpTemplate.parse((String)"//"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/{}"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a//b"));
        Assert.assertNull((Object)HttpTemplate.parse((String)":verb"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/:verb"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/:verb"));
        Assert.assertNull((Object)HttpTemplate.parse((String)":"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/:"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/*:"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/**:"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/{var}:"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/b/:"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/b/*:"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/b/**:"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/b/{var}:"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/{"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/{var"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/{var."));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/{x=var:verb}"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"a"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"{x}"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"{x=/a}"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"{x=/a/b}"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"a/b"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"a/b/{x}"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"a/{x}/b"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"a/{x}/b:verb"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/{var=/b}"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/{var=a/{nested=b}}"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a{x}"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/{x}a"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a{x}b"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/{x}a{y}"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/b{x}"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/{x}b"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/b{x}c"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/{x}b{y}"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/b{x}/s"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/{x}b/s"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/b{x}c/s"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/{x}b{y}/s"));
    }

    @Test
    public void testParseVerbTest2() {
        HttpTemplate template = HttpTemplate.parse((String)"/a/*:verb");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals((Object)template.getSegments(), Arrays.asList("a", "*"));
        Assert.assertEquals((Object)"verb", (Object)template.getVerb());
    }

    @Test
    public void testParseVerbTest3() {
        HttpTemplate template = HttpTemplate.parse((String)"/a/**:verb");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals((Object)template.getSegments(), Arrays.asList("a", "**"));
        Assert.assertEquals((Object)"verb", (Object)template.getVerb());
    }

    @Test
    public void testParseVerbTest4() {
        HttpTemplate template = HttpTemplate.parse((String)"/a/{b=*}/**:verb");
        Assert.assertNotNull((Object)template);
        Assert.assertEquals((Object)template.getSegments(), Arrays.asList("a", "*", "**"));
        Assert.assertEquals((Object)"verb", (Object)template.getVerb());
    }

    @Test
    public void testParseNonVerbTest() {
        Assert.assertNull((Object)HttpTemplate.parse((String)":"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/:"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/:"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/*:"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/**:"));
        Assert.assertNull((Object)HttpTemplate.parse((String)"/a/{b=*}/**:"));
    }

    private void assertVariableList(List<HttpTemplateVariable> expected, List<HttpTemplateVariable> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            this.assertVariable(expected.get(i), actual.get(i));
        }
    }

    private void assertVariable(HttpTemplateVariable expected, HttpTemplateVariable actual) {
        Assert.assertEquals((Object)expected.getFieldPath(), (Object)actual.getFieldPath());
        Assert.assertEquals((long)expected.getStartSegment(), (long)actual.getStartSegment());
        Assert.assertEquals((long)expected.getEndSegment(), (long)actual.getEndSegment());
        Assert.assertEquals((Object)expected.hasWildcardPath(), (Object)actual.hasWildcardPath());
    }
}

