/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.DB2Connection;
import io.vertx.db2client.impl.DB2ConnectionFactory;
import io.vertx.db2client.impl.command.PingCommand;
import io.vertx.db2client.spi.DB2Driver;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SingletonSupplier;
import io.vertx.sqlclient.impl.SqlConnectionBase;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.Driver;

public class DB2ConnectionImpl
extends SqlConnectionBase<DB2ConnectionImpl>
implements DB2Connection {
    public static Future<DB2Connection> connect(Vertx vertx, DB2ConnectOptions options) {
        DB2ConnectionFactory client;
        ContextInternal ctx = (ContextInternal)vertx.getOrCreateContext();
        try {
            client = new DB2ConnectionFactory(ctx.owner(), SingletonSupplier.wrap((Object)((Object)options)));
        }
        catch (Exception e) {
            return ctx.failedFuture((Throwable)e);
        }
        return DB2ConnectionImpl.prepareForClose((ContextInternal)ctx, (Future)client.connect((Context)ctx)).map(DB2Connection::cast);
    }

    public DB2ConnectionImpl(ContextInternal context, ConnectionFactory factory, Connection conn) {
        super(context, factory, conn, (Driver)DB2Driver.INSTANCE);
    }

    @Override
    public DB2Connection ping(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.ping();
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> ping() {
        return this.schedule(this.context, new PingCommand());
    }

    @Override
    public DB2Connection debug(Handler<AsyncResult<Void>> handler) {
        throw new UnsupportedOperationException("Debug command not implemented");
    }

    @Override
    public Future<Void> debug() {
        throw new UnsupportedOperationException("Debug command not implemented");
    }
}

