/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.impl.Db2PoolOptions;
import io.vertx.db2client.spi.DB2Driver;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Utils;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

@Deprecated
@VertxGen
public interface DB2Pool
extends Pool {
    public static DB2Pool pool(String connectionUri) {
        return DB2Pool.pool(connectionUri, new PoolOptions());
    }

    public static DB2Pool pool(String connectionUri, PoolOptions options) {
        return DB2Pool.pool(DB2ConnectOptions.fromUri(connectionUri), options);
    }

    public static DB2Pool pool(Vertx vertx, String connectionUri) {
        return DB2Pool.pool(vertx, DB2ConnectOptions.fromUri(connectionUri), new PoolOptions());
    }

    public static DB2Pool pool(Vertx vertx, String connectionUri, PoolOptions options) {
        return DB2Pool.pool(vertx, DB2ConnectOptions.fromUri(connectionUri), options);
    }

    public static DB2Pool pool(DB2ConnectOptions database, PoolOptions options) {
        return DB2Pool.pool(null, database, options);
    }

    public static DB2Pool pool(Vertx vertx, DB2ConnectOptions database, PoolOptions options) {
        return DB2Pool.pool(vertx, Collections.singletonList(database), options);
    }

    public static DB2Pool pool(List<DB2ConnectOptions> databases, PoolOptions options) {
        return DB2Pool.pool(null, databases, options);
    }

    public static DB2Pool pool(Vertx vertx, List<DB2ConnectOptions> databases, PoolOptions options) {
        return (DB2Pool)DB2Driver.INSTANCE.createPool(vertx, Utils.roundRobinSupplier(databases), options);
    }

    @GenIgnore(value={"permitted-type"})
    public static DB2Pool pool(Supplier<Future<DB2ConnectOptions>> databases, PoolOptions poolOptions) {
        return DB2Pool.pool(null, databases, poolOptions);
    }

    @GenIgnore(value={"permitted-type"})
    public static DB2Pool pool(Vertx vertx, Supplier<Future<DB2ConnectOptions>> databases, PoolOptions poolOptions) {
        return (DB2Pool)DB2Driver.INSTANCE.createPool(vertx, databases, poolOptions);
    }

    public static SqlClient client(String connectionUri) {
        return DB2Pool.client(connectionUri, new PoolOptions());
    }

    public static SqlClient client(String connectionUri, PoolOptions options) {
        return DB2Pool.client(DB2ConnectOptions.fromUri(connectionUri), options);
    }

    public static SqlClient client(Vertx vertx, String connectionUri) {
        return DB2Pool.client(vertx, DB2ConnectOptions.fromUri(connectionUri), new PoolOptions());
    }

    public static SqlClient client(Vertx vertx, String connectionUri, PoolOptions options) {
        return DB2Pool.client(vertx, DB2ConnectOptions.fromUri(connectionUri), options);
    }

    public static SqlClient client(DB2ConnectOptions database, PoolOptions options) {
        return DB2Pool.client(null, database, options);
    }

    public static SqlClient client(Vertx vertx, DB2ConnectOptions database, PoolOptions options) {
        return DB2Pool.client(vertx, Collections.singletonList(database), options);
    }

    public static SqlClient client(List<DB2ConnectOptions> databases, PoolOptions options) {
        return DB2Pool.client(null, databases, options);
    }

    public static SqlClient client(Vertx vertx, List<DB2ConnectOptions> databases, PoolOptions options) {
        return DB2Driver.INSTANCE.createPool(vertx, Utils.roundRobinSupplier(databases), new Db2PoolOptions(options).setPipelined(true));
    }

    public DB2Pool connectHandler(Handler<SqlConnection> var1);

    @Fluent
    public DB2Pool connectionProvider(Function<Context, Future<SqlConnection>> var1);
}

