/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.tck;

import io.vertx.core.Vertx;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.DB2Pool;
import io.vertx.db2client.junit.DB2Resource;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.tck.TransactionTestBase;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class DB2TransactionTest
extends TransactionTestBase {
    @ClassRule
    public static DB2Resource rule = DB2Resource.SHARED_INSTANCE;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void printTestName(TestContext ctx) throws Exception {
        System.out.println(">>> BEGIN " + ((Object)((Object)this)).getClass().getSimpleName() + "." + this.testName.getMethodName());
    }

    protected Pool createPool() {
        return DB2Pool.pool((Vertx)this.vertx, (DB2ConnectOptions)new DB2ConnectOptions(rule.options()), (PoolOptions)new PoolOptions().setMaxSize(1));
    }

    protected Pool nonTxPool() {
        return DB2Pool.pool((Vertx)this.vertx, (DB2ConnectOptions)new DB2ConnectOptions(rule.options()), (PoolOptions)new PoolOptions().setMaxSize(1));
    }

    protected void cleanTestTable(TestContext ctx) {
        this.getPool().query("DELETE FROM mutable").execute(ctx.asyncAssertSuccess());
    }

    protected String statement(String ... parts) {
        return String.join((CharSequence)"?", parts);
    }

    @Test
    public void testDelayedCommit(TestContext ctx) {
        Assume.assumeFalse((String)"DB2 on Z holds write locks on inserted columns with isolation level = 2", (boolean)rule.isZOS());
        super.testDelayedCommit(ctx);
    }

    @Test
    public void testFailureWithPendingQueries(TestContext ctx) {
        Assume.assumeFalse((String)"DB2 on Z holds write locks on inserted columns with isolation level = 2", (boolean)rule.isZOS());
        super.testDelayedCommit(ctx);
    }
}

