/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.tck;

import io.vertx.db2client.junit.DB2Resource;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.tck.PreparedQueryTestBase;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public abstract class DB2PreparedQueryTestBase
extends PreparedQueryTestBase {
    @ClassRule
    public static DB2Resource rule = DB2Resource.SHARED_INSTANCE;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void printTestName(TestContext ctx) throws Exception {
        System.out.println(">>> BEGIN " + ((Object)((Object)this)).getClass().getSimpleName() + "." + this.testName.getMethodName());
    }

    protected void cleanTestTable(TestContext ctx) {
        this.connect(ctx.asyncAssertSuccess(conn -> conn.query("DELETE FROM mutable").execute(ctx.asyncAssertSuccess(result -> conn.close()))));
    }

    protected String statement(String ... parts) {
        return String.join((CharSequence)"?", parts);
    }

    protected boolean cursorRequiresTx() {
        return false;
    }

    @Test
    public void testPrepareError(TestContext ctx) {
        this.msgVerifier = err -> ctx.assertTrue(err.getMessage().startsWith("The object '" + rule.options().getUser().toUpperCase() + ".DOES_NOT_EXIST' provided is not defined"));
        super.testPrepareError(ctx);
    }

    @Test
    public void testPreparedQueryParamCoercionTypeError(TestContext ctx) {
        this.msgVerifier = err -> ctx.assertEquals((Object)"Parameter at position[0] with class = [java.lang.String] and value = [1] can not be coerced to the expected class = [java.lang.Integer] for encoding.", (Object)err.getMessage());
        super.testPreparedQueryParamCoercionTypeError(ctx);
    }

    @Test
    public void testPreparedUpdateWithNullParams(TestContext ctx) {
        this.msgVerifier = err -> {
            String msg = "An attempt was made to INSERT or UPDATE a column that was declared as not nullable with the NULL value";
            ctx.assertTrue(err.getMessage().contains(msg), "Expected to find '" + msg + "' in throwable but error message was: " + err.getMessage());
        };
        super.testPreparedUpdateWithNullParams(ctx);
    }
}

