/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.tck;

import io.vertx.db2client.junit.DB2Resource;
import io.vertx.db2client.tck.ClientConfig;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.tck.BinaryDataTypeEncodeTestBase;
import java.sql.JDBCType;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class DB2BinaryDataTypeEncodeTest
extends BinaryDataTypeEncodeTestBase {
    @ClassRule
    public static DB2Resource rule = DB2Resource.SHARED_INSTANCE;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void printTestName(TestContext ctx) throws Exception {
        System.out.println(">>> BEGIN " + ((Object)((Object)this)).getClass().getSimpleName() + "." + this.testName.getMethodName());
    }

    protected JDBCType getNumericJDBCType() {
        return JDBCType.NUMERIC;
    }

    protected Class<? extends Number> getNumericClass() {
        return Numeric.class;
    }

    protected Number getNumericValue(Number value) {
        return Numeric.create((Number)value);
    }

    protected Number getNumericValue(String value) {
        return Numeric.parse((String)value);
    }

    protected void initConnector() {
        this.connector = ClientConfig.CONNECT.connect(this.vertx, (SqlConnectOptions)rule.options());
    }

    protected String statement(String ... parts) {
        return String.join((CharSequence)"?", parts);
    }

    @Test
    public void testDouble(TestContext ctx) {
        this.testEncodeGeneric(ctx, "test_float_8", Double.class, Row::getDouble, Double.valueOf("5.4E-079"));
    }

    public void testBoolean(TestContext ctx) {
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.preparedQuery("UPDATE basicdatatype SET test_boolean = ? WHERE id = 2").execute(Tuple.tuple().addValue((Object)false), ctx.asyncAssertSuccess(updateResult -> conn.preparedQuery("SELECT test_boolean FROM basicdatatype WHERE id = 2").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)0, row.getValue(0));
            ctx.assertEquals((Object)0, row.getValue("test_boolean"));
            ctx.assertEquals((Object)false, (Object)row.getBoolean(0));
            conn.close();
        }))))));
    }
}

