/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.db2client.DB2TestBase;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlConnection;
import java.util.Arrays;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class TableJoinTest
extends DB2TestBase {
    @Test
    public void testColumnRename(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("SELECT immutable.id AS \"IMM ID\",immutable.message AS IMM_MSG,Fortune.id AS FORT_ID,Fortune.message AS \"fortune msg\" FROM immutable INNER JOIN Fortune ON (immutable.id + 1) = Fortune.id WHERE immutable.id=1").execute(ctx.asyncAssertSuccess(rowSet -> {
            ctx.assertEquals((Object)1, (Object)rowSet.size());
            ctx.assertEquals(Arrays.asList("IMM ID", "IMM_MSG", "FORT_ID", "fortune msg"), (Object)rowSet.columnsNames());
            Row row = (Row)rowSet.iterator().next();
            ctx.assertEquals((Object)1, (Object)row.getInteger(0));
            ctx.assertEquals((Object)1, (Object)row.getInteger("IMM ID"));
            ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString(1));
            ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString("IMM_MSG"));
            ctx.assertEquals((Object)2, (Object)row.getInteger(2));
            ctx.assertEquals((Object)2, (Object)row.getInteger("FORT_ID"));
            ctx.assertEquals((Object)"A computer scientist is someone who fixes things that aren't broken.", (Object)row.getString(3));
            ctx.assertEquals((Object)"A computer scientist is someone who fixes things that aren't broken.", (Object)row.getString("fortune msg"));
            conn.close();
        }))));
    }

    @Test
    public void testInnerJoin(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("SELECT immutable.id,immutable.message,Fortune.id,Fortune.message FROM immutable INNER JOIN Fortune ON (immutable.id + 1) = Fortune.id WHERE immutable.id=1").execute(ctx.asyncAssertSuccess(rowSet -> {
            ctx.assertEquals((Object)1, (Object)rowSet.size());
            ctx.assertEquals(Arrays.asList("ID", "MESSAGE", "ID", "MESSAGE"), (Object)rowSet.columnsNames());
            Row row = (Row)rowSet.iterator().next();
            ctx.assertEquals((Object)1, (Object)row.getInteger(0));
            ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString(1));
            ctx.assertEquals((Object)2, (Object)row.getInteger(2));
            ctx.assertEquals((Object)"A computer scientist is someone who fixes things that aren't broken.", (Object)row.getString(3));
            conn.close();
        }))));
    }

    @Test
    public void testInnerJoinPrepared(TestContext ctx) {
        this.testJoin(ctx, "INNER JOIN");
    }

    @Test
    public void testLeftOuterJoin(TestContext ctx) {
        this.testJoin(ctx, "LEFT OUTER JOIN");
    }

    @Test
    public void testRightOuterJoin(TestContext ctx) {
        this.testJoin(ctx, "RIGHT OUTER JOIN");
    }

    @Test
    public void testFullOuterJoin(TestContext ctx) {
        Assume.assumeFalse((String)"DB2 on Z does not support operations within ON clause for FULL OUTER JOIN", (boolean)rule.isZOS());
        this.testJoin(ctx, "FULL OUTER JOIN");
    }

    private void testJoin(TestContext ctx, String joinType) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT * FROM immutable " + joinType + " Fortune ON (immutable.id + 1) = Fortune.id WHERE immutable.id=1").execute(ctx.asyncAssertSuccess(rowSet -> {
            ctx.assertEquals((Object)1, (Object)rowSet.size());
            ctx.assertEquals(Arrays.asList("ID", "MESSAGE", "ID", "MESSAGE"), (Object)rowSet.columnsNames());
            Row row = (Row)rowSet.iterator().next();
            ctx.assertEquals((Object)1, (Object)row.getInteger(0));
            ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString(1));
            ctx.assertEquals((Object)2, (Object)row.getInteger(2));
            ctx.assertEquals((Object)"A computer scientist is someone who fixes things that aren't broken.", (Object)row.getString(3));
            conn.close();
        }))));
    }
}

