/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.DB2Connection;
import io.vertx.db2client.DB2Exception;
import io.vertx.db2client.DB2TestBase;
import io.vertx.db2client.junit.TestUtil;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.sqlclient.ClosedConnectionException;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class DB2ErrorMessageTest
extends DB2TestBase {
    @Test
    public void testConnectInvalidDatabase(TestContext ctx) {
        this.options.setDatabase("DB_DOES_NOT_EXIST");
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertFailure(err -> {
            if (err instanceof DB2Exception) {
                DB2Exception ex = (DB2Exception)err;
                TestUtil.assertContains(ctx, ex.getMessage(), "provided was not found", "The connection was closed by the database server");
                ctx.assertTrue(ex.getErrorCode() == -1001 || ex.getErrorCode() == -4499, "Wrong SQL code received.  Expecting -1001 or -4499, but received " + ex.getErrorCode());
                TestUtil.assertContains(ctx, ex.getSqlState(), "2E000", "08004.C.3");
            } else if (!(err instanceof ClosedConnectionException)) {
                ctx.fail("The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getName());
            }
        }));
    }

    @Test
    public void testConnectInvalidUsername(TestContext ctx) {
        this.options.setUser("INVALID_USER_FOR_TESTING");
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)err;
            TestUtil.assertContains(ctx, ex.getMessage(), "Invalid credentials");
            ctx.assertEquals((Object)-4214, (Object)ex.getErrorCode());
            ctx.assertEquals((Object)"08004.C.1", (Object)ex.getSqlState());
        }));
    }

    @Test
    public void testConnectInvalidPassword(TestContext ctx) {
        this.options.setPassword("INVALID_PASSWORD_FOR_TESTING");
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)err;
            TestUtil.assertContains(ctx, ex.getMessage(), "Invalid credentials");
            ctx.assertEquals((Object)-4214, (Object)ex.getErrorCode());
            ctx.assertEquals((Object)"08004.C.1", (Object)ex.getSqlState());
        }));
    }

    @Test
    public void testQueryBlankDatabase(TestContext ctx) {
        try {
            this.options.setDatabase("");
            ctx.fail("Expected a DB2Exception to be thrown");
        }
        catch (DB2Exception ex) {
            TestUtil.assertContains(ctx, ex.getMessage(), "The database name cannot be blank or null");
            ctx.assertEquals((Object)-1001, (Object)ex.getErrorCode());
            ctx.assertEquals((Object)"XJ004.C", (Object)ex.getSqlState());
        }
    }

    @Test
    public void testQueryBlankUsername(TestContext ctx) {
        try {
            this.options.setUser("");
            ctx.fail("Expected a DB2Exception to be thrown");
        }
        catch (DB2Exception ex) {
            TestUtil.assertContains(ctx, ex.getMessage(), "The user cannot be blank or null");
            ctx.assertEquals((Object)-4461, (Object)ex.getErrorCode());
            ctx.assertEquals((Object)"08001.C.7", (Object)ex.getSqlState());
        }
    }

    @Test
    public void testQueryBlankPassword(TestContext ctx) {
        try {
            this.options.setPassword("");
            ctx.fail("Expected a DB2Exception to be thrown");
        }
        catch (DB2Exception ex) {
            TestUtil.assertContains(ctx, ex.getMessage(), "The password cannot be blank or null");
            ctx.assertEquals((Object)-4461, (Object)ex.getErrorCode());
            ctx.assertEquals((Object)"08001.C.8", (Object)ex.getSqlState());
        }
    }

    @Test
    public void testQueryBlankTable(TestContext ctx) {
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT id, message FROM ").execute(ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)((Object)err);
            TestUtil.assertContains(ctx, ex.getMessage(), "The SQL syntax provided was invalid");
            ctx.assertEquals((Object)-104, (Object)ex.getErrorCode());
            ctx.assertEquals((Object)"42601", (Object)ex.getSqlState());
        }))));
    }

    @Test
    public void testInvalidTableQuery(TestContext ctx) {
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT id, message FROM TABLE_DOES_NOT_EXIST").execute(ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)((Object)err);
            TestUtil.assertContains(ctx, ex.getMessage(), "provided is not defined");
            ctx.assertEquals((Object)-204, (Object)ex.getErrorCode());
            ctx.assertEquals((Object)"42704", (Object)ex.getSqlState());
        }))));
    }

    @Test
    public void testInvalidColumnQuery(TestContext ctx) {
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT INVALID_COLUMN FROM immutable").execute(ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)((Object)err);
            TestUtil.assertContains(ctx, ex.getMessage(), "provided does not exist");
            ctx.assertEquals((Object)-206, (Object)ex.getErrorCode());
            ctx.assertEquals((Object)"42703", (Object)ex.getSqlState());
        }))));
    }

    @Test
    public void testInvalidQuery(TestContext ctx) {
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("KJHDKJAHDQWEUWHQDDA:SHDL:KASHDJ").execute(ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)((Object)err);
            TestUtil.assertContains(ctx, ex.getMessage(), "The SQL syntax provided was invalid");
            ctx.assertEquals((Object)-104, (Object)ex.getErrorCode());
            ctx.assertEquals((Object)"42601", (Object)ex.getSqlState());
        }))));
    }

    @Test
    public void testMismatchingInsertedColumns(TestContext ctx) {
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("INSERT INTO basicdatatype (id, test_int_2) VALUES (99,24,25)").execute(ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)((Object)err);
            TestUtil.assertContains(ctx, ex.getMessage(), "An INSERT statement contained a different number of insert columns from the number of insert values that were supplied");
            ctx.assertEquals((Object)-117, (Object)ex.getErrorCode());
        }))));
    }

    @Test
    public void testRepeatedColumnReference(TestContext ctx) {
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("INSERT INTO basicdatatype (id, test_int_2, test_int_2) VALUES (99,24,25)").execute(ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)((Object)err);
            TestUtil.assertContains(ctx, ex.getMessage(), "An INSERT or UPDATE statement listed the same column name (TEST_INT_2) more than one time in its update list");
            ctx.assertEquals((Object)-121, (Object)ex.getErrorCode());
        }))));
    }

    @Test
    public void testAmbiguousColumnName(TestContext ctx) {
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT immutable.id AS IMM_ID,Fortune.id AS FORT_ID,message FROM immutable INNER JOIN Fortune ON immutable.id = Fortune.id WHERE immutable.id=1").execute(ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)((Object)err);
            TestUtil.assertContains(ctx, ex.getMessage(), "A reference to the column name 'MESSAGE' is ambiguous");
            ctx.assertEquals((Object)-203, (Object)ex.getErrorCode());
        }))));
    }

    @Test
    public void testDuplicateKeys(TestContext ctx) {
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("INSERT INTO immutable (id, message) VALUES (1, 'a duplicate key')").execute(ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)((Object)err);
            TestUtil.assertContains(ctx, ex.getMessage(), "Duplicate keys were detected on table ");
            ctx.assertEquals((Object)-803, (Object)ex.getErrorCode());
        }))));
    }

    @Test
    public void testCreateTableNullPrimaryKey(TestContext ctx) {
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("CREATE TABLE fruits (id INTEGER PRIMARY KEY, name VARCHAR(50) NOT NULL)").execute(ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)((Object)err);
            TestUtil.assertContains(ctx, ex.getMessage(), "The column 'ID' cannot be a column of a primary key because it can contain null values");
            ctx.assertEquals((Object)-542, (Object)ex.getErrorCode());
        }))));
    }

    @Test
    public void testInsertIntoGeneratedAlwaysColumn(TestContext ctx) {
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("INSERT INTO Fortune (id,message) VALUES (25, 'hello world')").execute(ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)((Object)err);
            TestUtil.assertContains(ctx, ex.getMessage(), "A value cannot be specified for column 'ID' which is identified as GENERATED ALWAYS");
            ctx.assertEquals((Object)-798, (Object)ex.getErrorCode());
        }))));
    }

    @Test
    public void testDuplicateObject(TestContext ctx) {
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("CREATE TABLE Fortune (\n  id       integer       NOT NULL GENERATED AS IDENTITY (START WITH 1, INCREMENT BY 1),\n  message  varchar(2048),\n  PRIMARY KEY  (id)\n)").execute(ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)((Object)err);
            TestUtil.assertContains(ctx, ex.getMessage(), "The object with the name '");
            TestUtil.assertContains(ctx, ex.getMessage(), "FORTUNE'");
            TestUtil.assertContains(ctx, ex.getMessage(), "of type 'TABLE' already exists");
            ctx.assertEquals((Object)-601, (Object)ex.getErrorCode());
        }))));
    }

    public void testInflightCommandsFailWhenConnectionClosed(TestContext ctx) {
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn1 -> conn1.query("CALL dbms_alert.sleep(60)").execute(ctx.asyncAssertFailure(t -> ctx.assertEquals((Object)"Failed to read any response from the server, the underlying connection may have been lost unexpectedly.", (Object)t.getMessage())))));
    }
}

