/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.db2client.impl.drda.DB2RowId;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.ArrayTuple;
import io.vertx.sqlclient.impl.RowDesc;
import java.math.BigDecimal;
import java.sql.RowId;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.UUID;

public class DB2RowImpl
extends ArrayTuple
implements Row {
    private final RowDesc rowDesc;

    public DB2RowImpl(RowDesc rowDesc) {
        super(rowDesc.columnNames().size());
        this.rowDesc = rowDesc;
    }

    public <T> T get(Class<T> type, int position) {
        if (type == Boolean.class) {
            return type.cast(this.getBoolean(position));
        }
        if (type == Byte.class) {
            return type.cast(this.getByte(position));
        }
        if (type == Short.class) {
            return type.cast(this.getShort(position));
        }
        if (type == Integer.class) {
            return type.cast(this.getInteger(position));
        }
        if (type == Long.class) {
            return type.cast(this.getLong(position));
        }
        if (type == Float.class) {
            return type.cast(this.getFloat(position));
        }
        if (type == Double.class) {
            return type.cast(this.getDouble(position));
        }
        if (type == Numeric.class) {
            return type.cast(this.getNumeric(position));
        }
        if (type == String.class) {
            return type.cast(this.getString(position));
        }
        if (type == Buffer.class) {
            return type.cast(this.getBuffer(position));
        }
        if (type == LocalDate.class) {
            return type.cast(this.getLocalDate(position));
        }
        if (type == LocalDateTime.class) {
            return type.cast(this.getLocalDateTime(position));
        }
        if (type == LocalTime.class) {
            return type.cast(this.getLocalTime(position));
        }
        if (type == Duration.class) {
            return type.cast(this.getDuration(position));
        }
        if (type == RowId.class || type == DB2RowId.class) {
            return type.cast(this.getRowId(position));
        }
        if (type == UUID.class) {
            return type.cast(this.getUUID(position));
        }
        if (type.isEnum()) {
            return type.cast(this.getEnum(type, position));
        }
        throw new UnsupportedOperationException("Unsupported type " + type.getName());
    }

    public String getColumnName(int pos) {
        List columnNames = this.rowDesc.columnNames();
        return pos < 0 || columnNames.size() - 1 < pos ? null : (String)columnNames.get(pos);
    }

    public int getColumnIndex(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        int idx = this.rowDesc.columnIndex(name);
        if (idx >= 0) {
            return idx;
        }
        return this.rowDesc.columnIndex(name.toUpperCase());
    }

    public Object getValue(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getValue(pos);
    }

    public Boolean getBoolean(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Short) {
            return (Short)val != 0;
        }
        return null;
    }

    public Boolean getBoolean(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getBoolean(pos);
    }

    public Short getShort(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getShort(pos);
    }

    public Integer getInteger(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getInteger(pos);
    }

    public Long getLong(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getLong(pos);
    }

    public Float getFloat(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getFloat(pos);
    }

    public Double getDouble(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getDouble(pos);
    }

    public Numeric getNumeric(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getNumeric(pos);
    }

    public String getString(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getString(pos);
    }

    public Buffer getBuffer(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getBuffer(pos);
    }

    public RowId getRowId(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof RowId) {
            return (RowId)val;
        }
        return null;
    }

    public RowId getRowId(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getRowId(pos);
    }

    public Temporal getTemporal(String name) {
        throw new UnsupportedOperationException();
    }

    public LocalDate getLocalDate(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getLocalDate(pos);
    }

    public LocalTime getLocalTime(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getLocalTime(pos);
    }

    public LocalDateTime getLocalDateTime(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getLocalDateTime(pos);
    }

    public OffsetTime getOffsetTime(String name) {
        throw new UnsupportedOperationException();
    }

    public OffsetDateTime getOffsetDateTime(String name) {
        throw new UnsupportedOperationException();
    }

    public UUID getUUID(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getUUID(pos);
    }

    public BigDecimal getBigDecimal(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getBigDecimal(pos);
    }

    public Integer[] getIntegerArray(String name) {
        throw new UnsupportedOperationException();
    }

    public Boolean[] getBooleanArray(String name) {
        throw new UnsupportedOperationException();
    }

    public Short[] getShortArray(String name) {
        throw new UnsupportedOperationException();
    }

    public Long[] getLongArray(String name) {
        throw new UnsupportedOperationException();
    }

    public Float[] getFloatArray(String name) {
        throw new UnsupportedOperationException();
    }

    public Double[] getDoubleArray(String name) {
        throw new UnsupportedOperationException();
    }

    public String[] getStringArray(String name) {
        throw new UnsupportedOperationException();
    }

    public LocalDate[] getLocalDateArray(String name) {
        throw new UnsupportedOperationException();
    }

    public LocalTime[] getLocalTimeArray(String name) {
        throw new UnsupportedOperationException();
    }

    public OffsetTime[] getOffsetTimeArray(String name) {
        throw new UnsupportedOperationException();
    }

    public LocalDateTime[] getLocalDateTimeArray(String name) {
        throw new UnsupportedOperationException();
    }

    public OffsetDateTime[] getOffsetDateTimeArray(String name) {
        throw new UnsupportedOperationException();
    }

    public Buffer[] getBufferArray(String name) {
        throw new UnsupportedOperationException();
    }

    public UUID[] getUUIDArray(String name) {
        throw new UnsupportedOperationException();
    }

    private Numeric getNumeric(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Numeric) {
            return (Numeric)val;
        }
        if (val instanceof Number) {
            return Numeric.parse((String)val.toString());
        }
        return null;
    }

    private Byte getByte(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Byte) {
            return (Byte)val;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        return null;
    }

    private Duration getDuration(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Duration) {
            return (Duration)val;
        }
        return null;
    }

    private Object getEnum(Class enumType, int position) {
        T[] constants;
        int ordinal;
        Object val = this.getValue(position);
        if (val instanceof String) {
            return Enum.valueOf(enumType, (String)val);
        }
        if (val instanceof Number && (ordinal = ((Number)val).intValue()) >= 0 && ordinal < (constants = enumType.getEnumConstants()).length) {
            return constants[ordinal];
        }
        return null;
    }
}

