/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.DB2Connection;
import io.vertx.db2client.impl.DB2ConnectionFactory;
import io.vertx.db2client.impl.command.PingCommand;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.tracing.QueryTracer;

public class DB2ConnectionImpl
extends SqlConnectionImpl<DB2ConnectionImpl>
implements DB2Connection {
    public static Future<DB2Connection> connect(Vertx vertx, DB2ConnectOptions options) {
        DB2ConnectionFactory client;
        ContextInternal ctx = (ContextInternal)vertx.getOrCreateContext();
        try {
            client = new DB2ConnectionFactory(ctx, options);
        }
        catch (Exception e) {
            return ctx.failedFuture((Throwable)e);
        }
        ctx.addCloseHook((Closeable)client);
        QueryTracer tracer = ctx.tracer() == null ? null : new QueryTracer(ctx.tracer(), (SqlConnectOptions)options);
        PromiseInternal promise = ctx.promise();
        ctx.emit(null, arg_0 -> DB2ConnectionImpl.lambda$connect$0(client, ctx, tracer, (Promise)promise, arg_0));
        return promise.future();
    }

    private static void connect(DB2ConnectionFactory client, ContextInternal ctx, QueryTracer tracer, Promise<DB2Connection> promise) {
        client.connect().map(conn -> {
            DB2ConnectionImpl db2Connection = new DB2ConnectionImpl(client, ctx, (Connection)conn, tracer, null);
            conn.init((Connection.Holder)db2Connection);
            return db2Connection;
        }).onComplete(promise);
    }

    public DB2ConnectionImpl(DB2ConnectionFactory factory, ContextInternal context, Connection conn, QueryTracer tracer, ClientMetrics metrics) {
        super(context, conn, tracer, metrics);
    }

    @Override
    public DB2Connection ping(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.ping();
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> ping() {
        PromiseInternal promise = this.promise();
        this.schedule(new PingCommand(), (Promise)promise);
        return promise.future();
    }

    @Override
    public DB2Connection debug(Handler<AsyncResult<Void>> handler) {
        throw new UnsupportedOperationException("Debug command not implemented");
    }

    @Override
    public Future<Void> debug() {
        throw new UnsupportedOperationException("Debug command not implemented");
    }

    private static /* synthetic */ void lambda$connect$0(DB2ConnectionFactory client, ContextInternal ctx, QueryTracer tracer, Promise promise, Object v) {
        DB2ConnectionImpl.connect(client, ctx, tracer, (Promise<DB2Connection>)promise);
    }
}

