/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.impl.DB2SocketConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactory;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;

public class DB2ConnectionFactory
implements ConnectionFactory {
    private final NetClient netClient;
    private final ContextInternal context;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String database;
    private final Map<String, String> connectionAttributes;
    private final boolean cachePreparedStatements;
    private final int preparedStatementCacheSize;
    private final Predicate<String> preparedStatementCacheSqlFilter;
    private final int pipeliningLimit;
    private final CloseFuture clientCloseFuture = new CloseFuture();

    public DB2ConnectionFactory(ContextInternal context, DB2ConnectOptions options) {
        NetClientOptions netClientOptions = new NetClientOptions((NetClientOptions)options);
        this.context = context;
        this.host = options.getHost();
        this.port = options.getPort();
        this.username = options.getUser();
        this.password = options.getPassword();
        this.database = options.getDatabase();
        this.connectionAttributes = options.getProperties() == null ? null : Collections.unmodifiableMap(options.getProperties());
        this.cachePreparedStatements = options.getCachePreparedStatements();
        this.preparedStatementCacheSize = options.getPreparedStatementCacheMaxSize();
        this.preparedStatementCacheSqlFilter = options.getPreparedStatementCacheSqlFilter();
        this.pipeliningLimit = options.getPipeliningLimit();
        this.netClient = context.owner().createNetClient(netClientOptions, this.clientCloseFuture);
    }

    public void close(Promise<Void> promise) {
        this.clientCloseFuture.close(promise);
    }

    public Future<Connection> connect() {
        PromiseInternal promise = this.context.promise();
        this.context.emit(null, arg_0 -> this.lambda$connect$0((Promise)promise, arg_0));
        return promise.future();
    }

    public void doConnect(Promise<Connection> promise) {
        Future fut = this.netClient.connect(this.port, this.host);
        fut.onComplete(ar -> {
            if (ar.succeeded()) {
                NetSocket so = (NetSocket)ar.result();
                DB2SocketConnection conn = new DB2SocketConnection((NetSocketInternal)so, this.cachePreparedStatements, this.preparedStatementCacheSize, this.preparedStatementCacheSqlFilter, this.pipeliningLimit, this.context);
                conn.init();
                conn.sendStartupMessage(this.username, this.password, this.database, this.connectionAttributes, promise);
            } else {
                promise.fail(ar.cause());
            }
        });
    }

    private /* synthetic */ void lambda$connect$0(Promise promise, Object v) {
        this.doConnect((Promise<Connection>)promise);
    }
}

