/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.impl.DB2ConnectionImpl;
import io.vertx.sqlclient.PreparedStatement;
import io.vertx.sqlclient.SqlConnection;

@VertxGen
public interface DB2Connection
extends SqlConnection {
    public static void connect(Vertx vertx, DB2ConnectOptions connectOptions, Handler<AsyncResult<DB2Connection>> handler) {
        Future<DB2Connection> fut = DB2Connection.connect(vertx, connectOptions);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    public static Future<DB2Connection> connect(Vertx vertx, DB2ConnectOptions connectOptions) {
        return DB2ConnectionImpl.connect(vertx, connectOptions);
    }

    public static void connect(Vertx vertx, String connectionUri, Handler<AsyncResult<DB2Connection>> handler) {
        DB2Connection.connect(vertx, DB2ConnectOptions.fromUri(connectionUri), handler);
    }

    public static Future<DB2Connection> connect(Vertx vertx, String connectionUri) {
        return DB2Connection.connect(vertx, DB2ConnectOptions.fromUri(connectionUri));
    }

    public DB2Connection prepare(String var1, Handler<AsyncResult<PreparedStatement>> var2);

    public DB2Connection exceptionHandler(Handler<Throwable> var1);

    public DB2Connection closeHandler(Handler<Void> var1);

    @Fluent
    public DB2Connection ping(Handler<AsyncResult<Void>> var1);

    public Future<Void> ping();

    @Fluent
    public DB2Connection debug(Handler<AsyncResult<Void>> var1);

    public Future<Void> debug();
}

