/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.junit;

import io.vertx.core.net.JksOptions;
import io.vertx.db2client.DB2ConnectOptions;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLSyntaxErrorException;
import java.time.Duration;
import java.util.Objects;
import org.junit.rules.ExternalResource;
import org.testcontainers.containers.Db2Container;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;

public class DB2Resource
extends ExternalResource {
    private static final boolean CUSTOM_DB2 = DB2Resource.get("DB2_HOST") != null;
    public static final DB2Resource SHARED_INSTANCE = new DB2Resource();
    private boolean started = false;
    private boolean isDb2OnZ = false;
    private DB2ConnectOptions options;
    private final Db2Container instance = (Db2Container)((Db2Container)((Db2Container)((Db2Container)((Db2Container)((Db2Container)new Db2Container().acceptLicense().withLogConsumer(out -> System.out.print("[DB2] " + out.getUtf8String()))).withUsername("vertx").withPassword("vertx").withDatabaseName("vertx").withExposedPorts(new Integer[]{50000, 50001})).withFileSystemBind("src/test/resources/tls/server/", "/certs/")).withFileSystemBind("src/test/resources/tls/db2_tls_setup.sh", "/var/custom/db2_tls_setup.sh")).waitingFor(new LogMessageWaitStrategy().withRegEx(".*VERTX SSH SETUP DONE.*").withStartupTimeout(Duration.ofMinutes(10L)))).withReuse(true);

    protected void before() throws Throwable {
        if (this.started) {
            return;
        }
        if (!CUSTOM_DB2) {
            this.instance.start();
            this.options = new DB2ConnectOptions().setHost(this.instance.getContainerIpAddress()).setPort(this.instance.getMappedPort(50000).intValue()).setDatabase(this.instance.getDatabaseName()).setUser(this.instance.getUsername()).setPassword(this.instance.getPassword());
        } else {
            System.out.println("Using custom DB2 instance as requested via DB2_HOST=" + DB2Resource.get("DB2_HOST"));
            Objects.requireNonNull(DB2Resource.get("DB2_PORT"), "Must set DB2_PORT to a non-null value if DB2_HOST is set");
            Objects.requireNonNull(DB2Resource.get("DB2_NAME"), "Must set DB2_NAME to a non-null value if DB2_HOST is set");
            Objects.requireNonNull(DB2Resource.get("DB2_USER"), "Must set DB2_USER to a non-null value if DB2_HOST is set");
            Objects.requireNonNull(DB2Resource.get("DB2_PASS"), "Must set DB2_PASS to a non-null value if DB2_HOST is set");
            this.options = new DB2ConnectOptions().setHost(DB2Resource.get("DB2_HOST")).setPort(Integer.valueOf(DB2Resource.get("DB2_PORT")).intValue()).setDatabase(DB2Resource.get("DB2_NAME")).setUser(DB2Resource.get("DB2_USER")).setPassword(DB2Resource.get("DB2_PASS"));
        }
        String jdbcUrl = "jdbc:db2://" + this.options.getHost() + ":" + this.options.getPort() + "/" + this.options.getDatabase();
        System.out.println("Initializing DB2 database at: " + jdbcUrl);
        try (Connection con = DriverManager.getConnection(jdbcUrl, this.options.getUser(), this.options.getPassword());){
            this.runInitSql(con);
        }
        this.started = true;
    }

    public DB2ConnectOptions options() {
        return new DB2ConnectOptions(this.options);
    }

    public DB2ConnectOptions secureOptions() {
        int securePort = CUSTOM_DB2 ? 50001 : this.instance.getMappedPort(50001);
        return new DB2ConnectOptions(this.options()).setPort(securePort).setSsl(true).setTrustStoreOptions(new JksOptions().setPath("src/test/resources/tls/db2-keystore.p12").setPassword("db2test"));
    }

    public boolean isZOS() {
        return this.isDb2OnZ;
    }

    private static String get(String name) {
        return System.getProperty(name, System.getenv(name));
    }

    private void runInitSql(Connection con) throws Exception {
        this.isDb2OnZ = con.getMetaData().getDatabaseProductVersion().startsWith("DSN");
        String currentLine = "";
        Path initScript = Paths.get("src", "test", "resources", this.isDb2OnZ ? "init.zos.sql" : "init.sql");
        System.out.println("Running init script at: " + initScript);
        for (String sql : Files.readAllLines(initScript)) {
            if (sql.startsWith("--")) continue;
            currentLine = currentLine + sql;
            if (!sql.endsWith(";")) continue;
            System.out.println("  " + currentLine);
            try {
                con.createStatement().execute(currentLine);
            }
            catch (SQLSyntaxErrorException e) {
                if (sql.startsWith("DROP ") && e.getErrorCode() == -204) {
                    System.out.println("  ignoring syntax exception: " + e.getMessage());
                }
                throw e;
            }
            currentLine = "";
        }
        if (!currentLine.isEmpty()) {
            throw new IllegalStateException("Dangling SQL on init script. Ensure all statements are terminated with ';' char. SQL: " + currentLine);
        }
    }
}

