/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.db2client.DB2TestBase;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Tuple;
import java.util.Arrays;
import java.util.function.Consumer;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class QueryVariationsTest
extends DB2TestBase {
    @Test
    public void testRenamedColumns(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("SELECT id AS THE_ID,message AS \"the message\"FROM immutable WHERE id = 10").execute(ctx.asyncAssertSuccess(rowSet -> {
            ctx.assertEquals((Object)1, (Object)rowSet.size());
            ctx.assertEquals(Arrays.asList("THE_ID", "the message"), (Object)rowSet.columnsNames());
            RowIterator rows = rowSet.iterator();
            ctx.assertTrue(rows.hasNext());
            Row row = (Row)rows.next();
            ctx.assertEquals((Object)10, (Object)row.getInteger(0));
            ctx.assertEquals((Object)10, (Object)row.getInteger("THE_ID"));
            ctx.assertEquals((Object)"Computers make very fast, very accurate mistakes.", (Object)row.getString(1));
            ctx.assertEquals((Object)"Computers make very fast, very accurate mistakes.", (Object)row.getString("the message"));
            ctx.assertFalse(rows.hasNext());
            conn.close();
        }))));
    }

    @Test
    public void testSubquery(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("SELECT id,message FROM immutable WHERE message IN (SELECT message FROM immutable WHERE id = '4' OR id = '7')").execute(ctx.asyncAssertSuccess(rowSet -> {
            ctx.assertEquals((Object)2, (Object)rowSet.size());
            ctx.assertEquals(Arrays.asList("ID", "MESSAGE"), (Object)rowSet.columnsNames());
            RowIterator rows = rowSet.iterator();
            ctx.assertTrue(rows.hasNext());
            Row row = (Row)rows.next();
            ctx.assertEquals((Object)4, (Object)row.getInteger(0));
            ctx.assertEquals((Object)"A bad random number generator: 1, 1, 1, 1, 1, 4.33e+67, 1, 1, 1", (Object)row.getString(1));
            ctx.assertTrue(rows.hasNext());
            row = (Row)rows.next();
            ctx.assertEquals((Object)7, (Object)row.getInteger(0));
            ctx.assertEquals((Object)"Any program that runs right is obsolete.", (Object)row.getString(1));
            conn.close();
        }))));
    }

    @Test
    public void testSubqueryPrepared(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT id,message FROM immutable WHERE message IN (SELECT message FROM immutable WHERE id = ? OR id = ?)").execute(Tuple.of((Object)4, (Object)7), ctx.asyncAssertSuccess(rowSet -> {
            ctx.assertEquals((Object)2, (Object)rowSet.size());
            ctx.assertEquals(Arrays.asList("ID", "MESSAGE"), (Object)rowSet.columnsNames());
            RowIterator rows = rowSet.iterator();
            ctx.assertTrue(rows.hasNext());
            Row row = (Row)rows.next();
            ctx.assertEquals((Object)4, (Object)row.getInteger(0));
            ctx.assertEquals((Object)"A bad random number generator: 1, 1, 1, 1, 1, 4.33e+67, 1, 1, 1", (Object)row.getString(1));
            ctx.assertTrue(rows.hasNext());
            row = (Row)rows.next();
            ctx.assertEquals((Object)7, (Object)row.getInteger(0));
            ctx.assertEquals((Object)"Any program that runs right is obsolete.", (Object)row.getString(1));
            conn.close();
        }))));
    }

    @Test
    public void testLikeQuery(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("SELECT id,message FROM immutable WHERE message LIKE '%computer%'").execute(ctx.asyncAssertSuccess(rowSet -> {
            ctx.assertEquals((Object)2, (Object)rowSet.size());
            ctx.assertEquals(Arrays.asList("ID", "MESSAGE"), (Object)rowSet.columnsNames());
            RowIterator rows = rowSet.iterator();
            ctx.assertTrue(rows.hasNext());
            Row row = (Row)rows.next();
            ctx.assertEquals((Object)2, (Object)row.getInteger(0));
            ctx.assertEquals((Object)"A computer scientist is someone who fixes things that aren't broken.", (Object)row.getString(1));
            ctx.assertTrue(rows.hasNext());
            row = (Row)rows.next();
            ctx.assertEquals((Object)5, (Object)row.getInteger(0));
            ctx.assertEquals((Object)"A computer program does what you tell it to do, not what you want it to do.", (Object)row.getString(1));
            conn.close();
        }))));
    }

    @Test
    public void testSectionReuse(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(con -> {
            con.prepare("SELECT * FROM Fortune WHERE id=1").flatMap(ps -> ps.query().execute()).onComplete(ctx.asyncAssertSuccess(rowSet -> {
                ctx.assertEquals((Object)1, (Object)rowSet.size());
                ctx.assertEquals(Arrays.asList("ID", "MESSAGE"), (Object)rowSet.columnsNames());
                RowIterator rows = rowSet.iterator();
                ctx.assertTrue(rows.hasNext());
                Row row = (Row)rows.next();
                ctx.assertEquals((Object)1, (Object)row.getInteger(0));
                ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString(1));
                ctx.assertFalse(rows.hasNext());
            }));
            con.prepare("SELECT * FROM immutable WHERE id=2").flatMap(ps -> ps.query().execute()).onComplete(ctx.asyncAssertSuccess(rowSet -> {
                ctx.assertEquals((Object)1, (Object)rowSet.size());
                ctx.assertEquals(Arrays.asList("ID", "MESSAGE"), (Object)rowSet.columnsNames());
                RowIterator rows = rowSet.iterator();
                ctx.assertTrue(rows.hasNext());
                Row row = (Row)rows.next();
                ctx.assertEquals((Object)2, (Object)row.getInteger(0));
                ctx.assertEquals((Object)"A computer scientist is someone who fixes things that aren't broken.", (Object)row.getString(1));
                ctx.assertFalse(rows.hasNext());
            }));
        }));
    }

    @Test
    public void testSequenceQuery(TestContext ctx) {
        Assume.assumeFalse((String)"TODO: Sequences behave differently on DB2/z and need to be implemented properly", (boolean)rule.isZOS());
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(con -> con.query("values nextval for my_seq").execute(ctx.asyncAssertSuccess(rowSet1 -> {
            int startingSeq = this.assertSequenceResult(ctx, (RowSet<Row>)rowSet1, seqVal -> ctx.assertTrue(seqVal >= 1, "Sequence value was not >= 1. Value: " + seqVal));
            con.query("VALUES nextval for my_seq").execute(ctx.asyncAssertSuccess(rowSet2 -> {
                this.assertSequenceResult(ctx, (RowSet<Row>)rowSet2, seqVal -> ctx.assertEquals((Object)(startingSeq + 1), seqVal));
                con.query("VALUES nextval for my_seq").execute(ctx.asyncAssertSuccess(rowSet3 -> this.assertSequenceResult(ctx, (RowSet<Row>)rowSet3, seqVal -> ctx.assertEquals((Object)(startingSeq + 2), seqVal))));
            }));
        }))));
    }

    @Test
    public void testSequenceQueryPrepared(TestContext ctx) {
        Assume.assumeFalse((String)"TODO: Sequences behave differently on DB2/z and need to be implemented properly", (boolean)rule.isZOS());
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(con -> con.preparedQuery("VALUES nextval for my_seq").execute(ctx.asyncAssertSuccess(rowSet1 -> {
            int startingSeq = this.assertSequenceResult(ctx, (RowSet<Row>)rowSet1, seqVal -> ctx.assertTrue(seqVal >= 1, "Sequence value was not >= 1. Value: " + seqVal));
            con.preparedQuery("values nextval for my_seq").execute(ctx.asyncAssertSuccess(rowSet2 -> {
                this.assertSequenceResult(ctx, (RowSet<Row>)rowSet2, seqVal -> ctx.assertEquals((Object)(startingSeq + 1), seqVal));
                con.preparedQuery("values nextval for my_seq").execute(ctx.asyncAssertSuccess(rowSet3 -> this.assertSequenceResult(ctx, (RowSet<Row>)rowSet3, seqVal -> ctx.assertEquals((Object)(startingSeq + 2), seqVal))));
            }));
        }))));
    }

    private int assertSequenceResult(TestContext ctx, RowSet<Row> rowSet, Consumer<Integer> validation) {
        ctx.assertEquals((Object)1, (Object)rowSet.size());
        RowIterator rows = rowSet.iterator();
        ctx.assertTrue(rows.hasNext());
        Row row = (Row)rows.next();
        ctx.assertNotNull((Object)row);
        int seqVal = row.getInteger(0);
        validation.accept(seqVal);
        return seqVal;
    }
}

