/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.db2client.DB2TestBase;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Tuple;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class GeneratedKeysTest
extends DB2TestBase {
    @Test
    public void testSelectGeneratedKeyPrepared(TestContext ctx) {
        String msg = "Some data from testSelectGeneratedKeyPrepared";
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT * FROM FINAL TABLE ( INSERT INTO Fortune (message) VALUES (?) )").execute(Tuple.of((Object)"Some data from testSelectGeneratedKeyPrepared"), ctx.asyncAssertSuccess(rowSet -> {
            ctx.assertEquals((Object)1, (Object)rowSet.size());
            Row row = (Row)rowSet.iterator().next();
            ctx.assertTrue(row.getInteger(0) >= 13, "Generated row ID should be >= 13 but was: " + row.getInteger(0));
            ctx.assertEquals((Object)"Some data from testSelectGeneratedKeyPrepared", (Object)row.getString(1));
            conn.close();
        }))));
    }

    @Test
    public void testSelectGeneratedKey(TestContext ctx) {
        String msg = "Some data from testSelectGeneratedKey";
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("SELECT * FROM FINAL TABLE ( INSERT INTO Fortune (message) VALUES ('Some data from testSelectGeneratedKey') )").execute(ctx.asyncAssertSuccess(rowSet -> {
            ctx.assertEquals((Object)1, (Object)rowSet.size());
            Row row = (Row)rowSet.iterator().next();
            ctx.assertTrue(row.getInteger(0) >= 13, "Generated row ID should be >= 13 but was: " + row.getInteger(0));
            ctx.assertEquals((Object)"Some data from testSelectGeneratedKey", (Object)row.getString(1));
            conn.close();
        }))));
    }
}

