/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client;

import io.vertx.core.json.JsonObject;
import io.vertx.db2client.impl.DB2ConnectionUriParser;
import org.junit.Assert;
import org.junit.Test;

public class DB2ConnectionUriParserTest {
    private String uri;
    private JsonObject actualParsedResult;
    private JsonObject expectedParsedResult;

    @Test
    public void testParsingUriSchemeDesignator() {
        this.uri = "db2://localhost";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUriSchemeDesignator() {
        this.uri = "db2e://localhost";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
    }

    @Test
    public void testParsingUserWithoutPassword() {
        this.uri = "db2://user@localhost";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user").put("host", (Object)"localhost");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingUserWithEmptyPassword() {
        this.uri = "db2://user:@localhost";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user").put("password", (Object)"").put("host", (Object)"localhost");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingUserWithPassword() {
        this.uri = "db2://user:secret@localhost";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user").put("password", (Object)"secret").put("host", (Object)"localhost");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingPasswordWithoutUser() {
        this.uri = "db2://:secret@localhost";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
    }

    @Test
    public void testParsingHostName() {
        this.uri = "db2://vertx.io";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"vertx.io");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingIpv4Address() {
        this.uri = "db2://192.168.1.1";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"192.168.1.1");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingIpv6Address() {
        this.uri = "db2://[2001:db8::1234]";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"2001:db8::1234");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingPort() {
        this.uri = "db2://localhost:1234";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost").put("port", (Object)1234);
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingSchemaName() {
        this.uri = "db2://localhost/mydb";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost").put("database", (Object)"mydb");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingOneAttribute() {
        this.uri = "db2://localhost?user=other";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost").put("user", (Object)"other");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingParameters() {
        this.uri = "db2://localhost?user=other&password=secret&port=1234";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost").put("user", (Object)"other").put("password", (Object)"secret").put("port", (Object)1234);
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingHostWithPort() {
        this.uri = "db2://localhost:1234";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost").put("port", (Object)1234);
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingEncodedDB() {
        this.uri = "db2://user_name@198.51.100.2:3306/world%5Fx";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user_name").put("host", (Object)"198.51.100.2").put("port", (Object)3306).put("database", (Object)"world_x");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri1() {
        this.uri = "db2://us@er@@";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri2() {
        this.uri = "db2://user/mydb//";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri3() {
        this.uri = "db2:///dbname/?host=localhost";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri4() {
        this.uri = "db2://user::1234";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri5() {
        this.uri = "db2://@:1234";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri6() {
        this.uri = "db2://:123:";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri7() {
        this.uri = "db2://@@/dbname?host";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
    }

    @Test
    public void testParsingUserInfoContainExclamationMark() {
        this.uri = "db2://user!name:dd!dd@127.0.0.1:3306/dbname";
        this.actualParsedResult = DB2ConnectionUriParser.parse((String)this.uri);
    }
}

