/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.tck;

import io.vertx.db2client.DB2Exception;
import io.vertx.db2client.junit.DB2Resource;
import io.vertx.db2client.tck.ClientConfig;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.sqlclient.tck.ConnectionTestBase;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class DB2ConnectionTest
extends ConnectionTestBase {
    @ClassRule
    public static DB2Resource rule = DB2Resource.SHARED_INSTANCE;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void printTestName(TestContext ctx) throws Exception {
        System.out.println(">>> BEGIN " + ((Object)((Object)this)).getClass().getSimpleName() + "." + this.testName.getMethodName());
    }

    public void setUp() throws Exception {
        super.setUp();
        this.options = rule.options();
        this.connector = ClientConfig.CONNECT.connect(this.vertx, this.options);
    }

    public void tearDown(TestContext ctx) {
        this.connector.close();
        super.tearDown(ctx);
    }

    @Test
    public void testConnectInvalidDatabase(TestContext ctx) {
        this.options.setDatabase("invalidDatabase");
        this.connect(ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception);
            DB2Exception ex = (DB2Exception)err;
            ctx.assertTrue(ex.getMessage().contains("invalidDatabase") || ex.getMessage().contains("The connection was closed by the database server."), "Unexpected message: " + ex.getMessage());
            ctx.assertTrue(ex.getSqlState() == "08004.C.2" || ex.getSqlState() == "08004.C.3", "Unexpected sql state: " + ex.getSqlState());
            ctx.assertTrue(ex.getErrorCode() == -30061 || ex.getErrorCode() == -4499, "Unexpected error code: " + ex.getErrorCode());
        }));
    }
}

