/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.tck;

import io.vertx.db2client.junit.DB2Resource;
import io.vertx.db2client.tck.ClientConfig;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.tck.BinaryDataTypeDecodeTestBase;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class DB2BinaryDataTypeDecodeTest
extends BinaryDataTypeDecodeTestBase {
    @ClassRule
    public static DB2Resource rule = DB2Resource.SHARED_INSTANCE;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void printTestName(TestContext ctx) throws Exception {
        System.out.println(">>> BEGIN " + ((Object)((Object)this)).getClass().getSimpleName() + "." + this.testName.getMethodName());
    }

    protected void initConnector() {
        this.connector = ClientConfig.CONNECT.connect(this.vertx, (SqlConnectOptions)rule.options());
    }

    @Test
    public void testBoolean(TestContext ctx) {
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT test_boolean FROM basicdatatype WHERE id = 1").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)1, row.getValue(0));
            ctx.assertEquals((Object)1, row.getValue("test_boolean"));
            ctx.assertEquals((Object)true, (Object)row.getBoolean(0));
            conn.close();
        }))));
    }

    @Test
    public void testDouble(TestContext ctx) {
        if (!rule.isZOS()) {
            super.testDouble(ctx);
            return;
        }
        this.testDecodeGeneric(ctx, "test_float_8", Double.class, 7.2E75);
    }

    @Test
    public void testSelectAll(TestContext ctx) {
        Assume.assumeFalse((boolean)rule.isZOS());
        super.testSelectAll(ctx);
    }
}

