/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.tck;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.DB2Connection;
import io.vertx.db2client.DB2Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.tck.Connector;

public enum ClientConfig {
    CONNECT{

        public Connector<SqlConnection> connect(final Vertx vertx, final SqlConnectOptions options) {
            return new Connector<SqlConnection>(){

                public void connect(Handler<AsyncResult<SqlConnection>> handler) {
                    DB2Connection.connect((Vertx)vertx, (DB2ConnectOptions)new DB2ConnectOptions(options.toJson()), ar -> {
                        if (ar.succeeded()) {
                            handler.handle((Object)Future.succeededFuture((Object)ar.result()));
                        } else {
                            handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                        }
                    });
                }

                public void close() {
                }
            };
        }
    }
    ,
    POOLED{

        public Connector<SqlConnection> connect(Vertx vertx, SqlConnectOptions options) {
            final DB2Pool pool = DB2Pool.pool((DB2ConnectOptions)new DB2ConnectOptions(options.toJson()), (PoolOptions)new PoolOptions().setMaxSize(1));
            return new Connector<SqlConnection>(){

                public void connect(Handler<AsyncResult<SqlConnection>> handler) {
                    pool.getConnection(ar -> {
                        if (ar.succeeded()) {
                            handler.handle((Object)Future.succeededFuture((Object)ar.result()));
                        } else {
                            handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                        }
                    });
                }

                public void close() {
                    pool.close();
                }
            };
        }
    };


    public abstract <C extends SqlClient> Connector<C> connect(Vertx var1, SqlConnectOptions var2);
}

