/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.junit.DB2Resource;
import io.vertx.db2client.tck.ClientConfig;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.tck.Connector;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class DB2TestBase {
    @ClassRule
    public static DB2Resource rule = DB2Resource.SHARED_INSTANCE;
    protected Vertx vertx;
    protected Connector<SqlConnection> connector;
    protected DB2ConnectOptions options;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void setUp(TestContext ctx) throws Exception {
        System.out.println(">>> BEGIN " + this.testName.getMethodName());
        this.vertx = Vertx.vertx();
        this.initConnector();
        for (String table : this.tablesToClean()) {
            this.cleanTestTable(ctx, table);
        }
    }

    @After
    public void tearDown(TestContext ctx) {
        this.connector.close();
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    protected void initConnector() {
        this.options = rule.options();
        this.connector = ClientConfig.CONNECT.connect(this.vertx, (SqlConnectOptions)this.options);
    }

    protected void connect(Handler<AsyncResult<SqlConnection>> handler) {
        this.connector.connect(handler);
    }

    protected void cleanTestTable(TestContext ctx, String table) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("DELETE FROM " + table).execute(ctx.asyncAssertSuccess(result -> conn.close()))));
    }

    protected List<String> tablesToClean() {
        return Collections.emptyList();
    }
}

