/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.DB2Connection;
import io.vertx.db2client.DB2Exception;
import io.vertx.db2client.DB2TestBase;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class DB2ErrorMessageTest
extends DB2TestBase {
    @Test
    public void testConnectInvalidDatabase(TestContext ctx) {
        this.options.setDatabase("DB_DOES_NOT_EXIST");
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)err;
            ctx.assertTrue(ex.getMessage().contains("provided was not found") || ex.getMessage().contains("The connection was closed by the database server"), "The SQL error message returned is not correct.  It should have contained \"provided was not found\" or \"The connection was closed by the database server\", but instead it said \"" + ex.getMessage() + "\"");
            ctx.assertTrue(ex.getErrorCode() == -1001 || ex.getErrorCode() == -4499, "Wrong SQL code received.  Expecting -1001 or -4499, but received " + ex.getErrorCode());
            ctx.assertTrue(ex.getSqlState().equalsIgnoreCase("2E000") || ex.getSqlState() == "08004.C.3", "Wrong SQL state received.  Expecting 2E000 or 08004.C.3, but received " + ex.getSqlState());
        }));
    }

    @Test
    public void testConnectInvalidUsername(TestContext ctx) {
        this.options.setUser("INVALID_USER_FOR_TESTING");
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)err;
            ctx.assertTrue(ex.getMessage().contains("Invalid credentials"), "The SQL error message returned is not correct.  It should have contained \"Invalid credentials\", but instead it said \"" + ex.getMessage() + "\"");
            ctx.assertEquals((Object)-4214, (Object)ex.getErrorCode());
            ctx.assertEquals((Object)"08004.C.1", (Object)ex.getSqlState());
        }));
    }

    @Test
    public void testConnectInvalidPassword(TestContext ctx) {
        this.options.setPassword("INVALID_PASSWORD_FOR_TESTING");
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)err;
            ctx.assertTrue(ex.getMessage().contains("Invalid credentials"), "The SQL error message returned is not correct.  It should have contained \"Invalid credentials\", but instead it said \"" + ex.getMessage() + "\"");
            ctx.assertEquals((Object)-4214, (Object)ex.getErrorCode());
            ctx.assertEquals((Object)"08004.C.1", (Object)ex.getSqlState());
        }));
    }

    @Test
    public void testQueryBlankDatabase(TestContext ctx) {
        try {
            this.options.setDatabase("");
            ctx.fail("Expected a DB2Exception to be thrown");
        }
        catch (DB2Exception ex) {
            ctx.assertTrue(ex.getMessage().contains("The database name cannot be blank or null"), "The SQL error message returned is not correct.  It should have contained \"The database name cannot be blank or null\", but instead it said \"" + ex.getMessage() + "\"");
            ctx.assertEquals((Object)-1001, (Object)ex.getErrorCode());
            ctx.assertEquals((Object)"XJ004.C", (Object)ex.getSqlState());
        }
    }

    @Test
    public void testQueryBlankUsername(TestContext ctx) {
        try {
            this.options.setUser("");
            ctx.fail("Expected a DB2Exception to be thrown");
        }
        catch (DB2Exception ex) {
            ctx.assertTrue(ex.getMessage().contains("The user cannot be blank or null"), "The SQL error message returned is not correct.  It should have contained \"The user cannot be blank or null\", but instead it said \"" + ex.getMessage() + "\"");
            ctx.assertEquals((Object)-4461, (Object)ex.getErrorCode());
            ctx.assertEquals((Object)"08001.C.7", (Object)ex.getSqlState());
        }
    }

    @Test
    public void testQueryBlankPassword(TestContext ctx) {
        try {
            this.options.setPassword("");
            ctx.fail("Expected a DB2Exception to be thrown");
        }
        catch (DB2Exception ex) {
            ctx.assertTrue(ex.getMessage().contains("The password cannot be blank or null"), "The SQL error message returned is not correct.  It should have contained \"The password cannot be blank or null\", but instead it said \"" + ex.getMessage() + "\"");
            ctx.assertEquals((Object)-4461, (Object)ex.getErrorCode());
            ctx.assertEquals((Object)"08001.C.8", (Object)ex.getSqlState());
        }
    }

    @Test
    public void testQueryBlankTable(TestContext ctx) {
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT id, message FROM ").execute(ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)((Object)err);
            ctx.assertTrue(ex.getMessage().contains("The SQL syntax provided was invalid"), "The SQL error message returned is not correct.  It should have contained \"The SQL syntax provided was invalid\", but instead it said \"" + ex.getMessage() + "\"");
            ctx.assertEquals((Object)-104, (Object)ex.getErrorCode());
            ctx.assertEquals((Object)"42601", (Object)ex.getSqlState());
        }))));
    }

    @Test
    public void testInvalidTableQuery(TestContext ctx) {
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT id, message FROM TABLE_DOES_NOT_EXIST").execute(ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)((Object)err);
            ctx.assertTrue(ex.getMessage().contains("provided is not defined"), "The SQL error message returned is not correct.  It should have contained \"provided is not defined\", but instead it said \"" + ex.getMessage() + "\"");
            ctx.assertEquals((Object)-204, (Object)ex.getErrorCode());
            ctx.assertEquals((Object)"42704", (Object)ex.getSqlState());
        }))));
    }

    @Test
    public void testInvalidColumnQuery(TestContext ctx) {
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT INVALID_COLUMN FROM immutable").execute(ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)((Object)err);
            ctx.assertTrue(ex.getMessage().contains("provided does not exist"), "The SQL error message returned is not correct.  It should have contained \"provided does not exist\", but instead it said \"" + ex.getMessage() + "\"");
            ctx.assertEquals((Object)-206, (Object)ex.getErrorCode());
            ctx.assertEquals((Object)"42703", (Object)ex.getSqlState());
        }))));
    }

    @Test
    public void testInvalidQuery(TestContext ctx) {
        DB2Connection.connect((Vertx)this.vertx, (DB2ConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("KJHDKJAHDQWEUWHQDDA:SHDL:KASHDJ").execute(ctx.asyncAssertFailure(err -> {
            ctx.assertTrue(err instanceof DB2Exception, "The error message returned is of the wrong type.  It should be a DB2Exception, but it was of type " + err.getClass().getSimpleName());
            DB2Exception ex = (DB2Exception)((Object)err);
            ctx.assertTrue(ex.getMessage().contains("The SQL syntax provided was invalid"), "The SQL error message returned is not correct.  It should have contained \"The SQL syntax provided was invalid\", but instead it said \"" + ex.getMessage() + "\"");
            ctx.assertEquals((Object)-104, (Object)ex.getErrorCode());
            ctx.assertEquals((Object)"42601", (Object)ex.getSqlState());
        }))));
    }
}

