/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.db2client.DB2TestBase;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Tuple;
import java.sql.RowId;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class DB2DataTypeTest
extends DB2TestBase {
    @Test
    public void testFloatIntoFloatColumn(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("INSERT INTO db2_types (id,test_float) VALUES (?, ?)").execute(Tuple.of((Object)1, (Object)Float.valueOf(5.0f)), ctx.asyncAssertSuccess(insertResult -> conn.preparedQuery("SELECT id,test_float FROM db2_types WHERE id = 1").execute(ctx.asyncAssertSuccess(rows -> {
            ctx.assertEquals((Object)1, (Object)rows.size());
            Row row = (Row)rows.iterator().next();
            ctx.assertEquals((Object)1, (Object)row.getInteger(0));
            ctx.assertEquals((Object)Float.valueOf(5.0f), (Object)row.getFloat(1));
        }))))));
    }

    @Test
    public void testByteIntoSmallIntColumn(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("INSERT INTO db2_types (id,test_byte) VALUES (?, ?)").execute(Tuple.of((Object)2, (Object)-54), ctx.asyncAssertSuccess(insertResult -> conn.preparedQuery("SELECT id,test_byte FROM db2_types WHERE id = 2").execute(ctx.asyncAssertSuccess(rows -> {
            ctx.assertEquals((Object)1, (Object)rows.size());
            Row row = (Row)rows.iterator().next();
            ctx.assertEquals((Object)2, (Object)row.getInteger(0));
            ctx.assertEquals((Object)-54, row.get(Byte.class, 1));
        }))))));
    }

    @Test
    public void testByteArrayIntoVarchar(TestContext ctx) {
        byte[] expected = "hello world".getBytes();
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("INSERT INTO db2_types (id,test_bytes) VALUES (?, ?)").execute(Tuple.of((Object)3, (Object)"hello world".getBytes()), ctx.asyncAssertSuccess(insertResult -> conn.preparedQuery("SELECT id,test_bytes FROM db2_types WHERE id = 3").execute(ctx.asyncAssertSuccess(rows -> {
            ctx.assertEquals((Object)1, (Object)rows.size());
            Row row = (Row)rows.iterator().next();
            ctx.assertEquals((Object)3, (Object)row.getInteger(0));
            ctx.assertTrue(Arrays.equals(expected, row.getBuffer(1).getBytes()), "Expecting " + Arrays.toString(expected) + " but got " + Arrays.toString(row.getBuffer(1).getBytes()));
        }))))));
    }

    @Test
    public void testByteBufIntoVarchar(TestContext ctx) {
        byte[] expected = "hello world".getBytes();
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("INSERT INTO db2_types (id,test_bytes) VALUES (?, ?)").execute(Tuple.of((Object)4, (Object)Buffer.buffer((byte[])expected)), ctx.asyncAssertSuccess(insertResult -> conn.preparedQuery("SELECT id,test_bytes FROM db2_types WHERE id = 4").execute(ctx.asyncAssertSuccess(rows -> {
            ctx.assertEquals((Object)1, (Object)rows.size());
            Row row = (Row)rows.iterator().next();
            ctx.assertEquals((Object)4, (Object)row.getInteger(0));
            ctx.assertTrue(Arrays.equals(expected, row.getBuffer(1).getBytes()), "Expecting " + Arrays.toString(expected) + " but got " + Arrays.toString(row.getBuffer(1).getBytes()));
        }))))));
    }

    @Test
    public void testTimestamp(TestContext ctx) {
        LocalDateTime now = LocalDateTime.now();
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("INSERT INTO db2_types (id,test_tstamp) VALUES (?,?)").execute(Tuple.of((Object)5, (Object)now), ctx.asyncAssertSuccess(insertResult -> conn.preparedQuery("SELECT id,test_tstamp FROM db2_types WHERE id = ?").execute(Tuple.of((Object)5), ctx.asyncAssertSuccess(rows -> {
            ctx.assertEquals((Object)1, (Object)rows.size());
            Row row = (Row)rows.iterator().next();
            int nowNanos = now.getNano() - 1000 * now.get(ChronoField.MICRO_OF_SECOND);
            int dbNanos = row.getLocalDateTime(1).getNano() - 1000 * row.getLocalDateTime(1).get(ChronoField.MICRO_OF_SECOND);
            ctx.assertEquals((Object)5, (Object)row.getInteger(0));
            ctx.assertEquals((Object)(dbNanos > 0 ? now : now.minusNanos(nowNanos)), (Object)row.getLocalDateTime(1));
        }))))));
    }

    @Test
    public void testRowId(TestContext ctx) {
        Assume.assumeTrue((String)"Only DB2/Z supports the ROWID column type", (boolean)rule.isZOS());
        String msg = "insert data for testRowId";
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("INSERT INTO ROWTEST (message) VALUES ('insert data for testRowId')").execute(ctx.asyncAssertSuccess(insertResult -> conn.preparedQuery("SELECT * FROM ROWTEST WHERE message = 'insert data for testRowId'").execute(ctx.asyncAssertSuccess(rows -> {
            RowId rowId = this.verifyRowId(ctx, (RowSet<Row>)rows, "insert data for testRowId");
            conn.preparedQuery("SELECT * FROM ROWTEST WHERE id = ?").execute(Tuple.of((Object)rowId), ctx.asyncAssertSuccess(rows2 -> this.verifyRowId(ctx, (RowSet<Row>)rows2, "insert data for testRowId")));
        }))))));
    }

    private RowId verifyRowId(TestContext ctx, RowSet<Row> rows, String msg) {
        ctx.assertEquals((Object)1, (Object)rows.size());
        Row row = (Row)rows.iterator().next();
        ctx.assertEquals((Object)msg, (Object)row.getString(1));
        RowId rowid = (RowId)row.get(RowId.class, 0);
        ctx.assertNotNull((Object)rowid);
        ctx.assertEquals((Object)22, (Object)rowid.getBytes().length);
        return rowid;
    }
}

