/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.spring;

import io.vertx.config.ConfigRetriever;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.config.ConfigStoreOptions;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.config.server.ConfigServerApplication;
import org.springframework.context.ConfigurableApplicationContext;

@RunWith(value=VertxUnitRunner.class)
public class SpringConfigServerStoreTest {
    private ConfigRetriever retriever;
    private Vertx vertx;
    private static ConfigurableApplicationContext springConfigServer;

    @BeforeClass
    public static void initSpringConfigServer() {
        springConfigServer = new SpringApplicationBuilder(new Object[]{ConfigServerApplication.class}).properties(new String[]{"spring.config.name=configserver"}).run(new String[0]);
    }

    @AfterClass
    public static void shutdownSpringConfigServer() {
        springConfigServer.close();
    }

    @Before
    public void setUp(TestContext tc) {
        this.vertx = Vertx.vertx();
        this.vertx.exceptionHandler(tc.exceptionHandler());
    }

    @After
    public void tearDown() {
        this.retriever.close();
        this.vertx.close();
    }

    @Test
    public void testWithFooDev(TestContext tc) {
        Async async = tc.async();
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("spring-config-server").setConfig(new JsonObject().put("url", "http://localhost:8888/foo/development"))));
        this.retriever.getConfig(json -> {
            AssertionsForInterfaceTypes.assertThat((boolean)json.succeeded()).isTrue();
            JsonObject config = (JsonObject)json.result();
            AssertionsForInterfaceTypes.assertThat((String)config.getString("bar")).isEqualToIgnoringCase((CharSequence)"spam");
            AssertionsForInterfaceTypes.assertThat((String)config.getString("foo")).isEqualToIgnoringCase((CharSequence)"baz");
            AssertionsForInterfaceTypes.assertThat((String)config.getString("info.description")).isEqualToIgnoringCase((CharSequence)"Spring Cloud Samples");
            async.complete();
        });
    }

    @Test
    public void testWithStoresCloud(TestContext tc) {
        Async async = tc.async();
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("spring-config-server").setConfig(new JsonObject().put("url", "http://localhost:8888/stores/cloud").put("timeout", Integer.valueOf(10000)))));
        this.retriever.getConfig(json -> {
            AssertionsForInterfaceTypes.assertThat((boolean)json.succeeded()).isTrue();
            JsonObject config = (JsonObject)json.result();
            AssertionsForInterfaceTypes.assertThat((Integer)config.getInteger("hystrix.command.default.execution.isolation.thread.timeoutInMilliseconds")).isEqualTo(60000);
            AssertionsForInterfaceTypes.assertThat((String)config.getString("eureka.password")).isEqualToIgnoringCase((CharSequence)"password");
            AssertionsForInterfaceTypes.assertThat((String)config.getString("spring.data.mongodb.uri")).isEqualToIgnoringCase((CharSequence)"${vcap.services.${PREFIX:}mongodb.credentials.uri}");
            AssertionsForInterfaceTypes.assertThat((String)config.getString("eureka.client.serviceUrl.defaultZone")).isEqualToIgnoringCase((CharSequence)"http://localhost:8761/eureka/");
            async.complete();
        });
    }

    @Test
    public void testWithUnknownConfiguration(TestContext tc) {
        Async async = tc.async();
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("spring-config-server").setConfig(new JsonObject().put("url", "http://localhost:8888/missing/missing").put("timeout", Integer.valueOf(10000)))));
        this.retriever.getConfig(json -> {
            AssertionsForInterfaceTypes.assertThat((boolean)json.succeeded()).isTrue();
            JsonObject config = (JsonObject)json.result();
            AssertionsForInterfaceTypes.assertThat((String)config.getString("eureka.client.serviceUrl.defaultZone")).isEqualToIgnoringCase((CharSequence)"http://localhost:8761/eureka/");
            async.complete();
        });
    }

    @Test
    public void testWithErrorConfiguration(TestContext tc) {
        Async async = tc.async();
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("spring-config-server").setConfig(new JsonObject().put("url", "http://localhost:8888/missing/missing/missing").put("timeout", Integer.valueOf(10000)))));
        this.retriever.getConfig(json -> {
            AssertionsForInterfaceTypes.assertThat((boolean)json.succeeded()).isFalse();
            async.complete();
        });
    }

    @Test
    public void testWithWrongServerConfiguration(TestContext tc) {
        Async async = tc.async();
        this.retriever = ConfigRetriever.create((Vertx)this.vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(new ConfigStoreOptions().setType("spring-config-server").setConfig(new JsonObject().put("url", "http://not-valid.de").put("timeout", Integer.valueOf(10000)))));
        this.retriever.getConfig(json -> {
            AssertionsForInterfaceTypes.assertThat((boolean)json.succeeded()).isFalse();
            async.complete();
        });
    }
}

