/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.mods.web;

import java.io.File;
import org.vertx.java.busmods.BusModBase;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.AsyncResultHandler;
import org.vertx.java.core.Future;
import org.vertx.java.core.Handler;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.RouteMatcher;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.sockjs.SockJSServer;
import org.vertx.mods.web.StaticFileHandler;

public abstract class WebServerBase
extends BusModBase {
    public static final int DEFAULT_PORT = 80;
    public static final String DEFAULT_ADDRESS = "0.0.0.0";
    public static final String DEFAULT_WEB_ROOT = "web";
    public static final String DEFAULT_INDEX_PAGE = "index.html";
    public static final String DEFAULT_AUTH_ADDRESS = "vertx.basicauthmanager.authorise";
    public static final long DEFAULT_AUTH_TIMEOUT = 300000L;

    public void start(final Future<Void> result) {
        this.start();
        HttpServer server = this.vertx.createHttpServer();
        if (this.getOptionalBooleanConfig("ssl", false)) {
            ((HttpServer)((HttpServer)server.setSSL(true)).setKeyStorePassword(this.getOptionalStringConfig("key_store_password", "wibble"))).setKeyStorePath(this.getOptionalStringConfig("key_store_path", "server-keystore.jks"));
        }
        if (this.getOptionalBooleanConfig("route_matcher", false)) {
            server.requestHandler((Handler)this.routeMatcher());
        } else if (this.getOptionalBooleanConfig("static_files", true)) {
            server.requestHandler(this.staticHandler());
        }
        boolean bridge = this.getOptionalBooleanConfig("bridge", false);
        if (bridge) {
            SockJSServer sjsServer = this.vertx.createSockJSServer(server);
            JsonArray inboundPermitted = this.getOptionalArrayConfig("inbound_permitted", new JsonArray());
            JsonArray outboundPermitted = this.getOptionalArrayConfig("outbound_permitted", new JsonArray());
            sjsServer.bridge(this.getOptionalObjectConfig("sjs_config", new JsonObject().putString("prefix", "/eventbus")), inboundPermitted, outboundPermitted, this.getOptionalLongConfig("auth_timeout", 300000L), this.getOptionalStringConfig("auth_address", DEFAULT_AUTH_ADDRESS));
        }
        server.listen(this.getOptionalIntConfig("port", 80), this.getOptionalStringConfig("host", DEFAULT_ADDRESS), (Handler)new AsyncResultHandler<HttpServer>(){

            public void handle(AsyncResult<HttpServer> ar) {
                if (!ar.succeeded()) {
                    result.setFailure(ar.cause());
                } else {
                    result.setResult(null);
                }
            }
        });
    }

    protected abstract RouteMatcher routeMatcher();

    protected Handler<HttpServerRequest> staticHandler() {
        String webRoot = this.getOptionalStringConfig("web_root", DEFAULT_WEB_ROOT);
        String index = this.getOptionalStringConfig("index_page", DEFAULT_INDEX_PAGE);
        String webRootPrefix = webRoot + File.separator;
        String indexPage = webRootPrefix + index;
        boolean gzipFiles = this.getOptionalBooleanConfig("gzip_files", false);
        boolean caching = this.getOptionalBooleanConfig("caching", false);
        return new StaticFileHandler(this.vertx, webRootPrefix, indexPage, gzipFiles, caching);
    }
}

