/*
 * Decompiled with CFR 0.152.
 */
package io.vantiq.client.main;

import io.vantiq.client.SubscriptionCallback;
import io.vantiq.client.SubscriptionMessage;
import io.vantiq.client.Vantiq;
import io.vantiq.client.VantiqResponse;
import java.net.SocketTimeoutException;
import java.util.Date;

public class SubscribeTopic {
    private static void println(String msg) {
        System.out.println(new Date() + " - " + msg);
    }

    private static void errorln(String err) {
        System.err.println(new Date() + " - " + err);
    }

    public static void main(String ... args2) throws Exception {
        if (args2.length != 4) {
            System.err.println("Usage: java " + SubscribeTopic.class.getName() + " <serverUrl> <username> <password> <topic>");
            System.exit(1);
        }
        String server = args2[0];
        String username = args2[1];
        String password = args2[2];
        Vantiq vantiq = new Vantiq(args2[0]);
        VantiqResponse resp = vantiq.authenticate(args2[1], args2[2]);
        if (!resp.isSuccess()) {
            throw new RuntimeException(resp.toString());
        }
        vantiq.subscribe(Vantiq.SystemResources.TOPICS.value(), args2[3], null, new SubscriptionCallback(){

            @Override
            public void onConnect() {
                SubscribeTopic.println("Subscription created.");
            }

            @Override
            public void onMessage(SubscriptionMessage message) {
                SubscribeTopic.println(message.getBody().toString());
            }

            @Override
            public void onError(String error) {
                SubscribeTopic.errorln(error);
            }

            @Override
            public void onFailure(Throwable t2) {
                if (t2 instanceof SocketTimeoutException) {
                    SubscribeTopic.errorln("WebSocket timed out.");
                    System.exit(2);
                } else {
                    SubscribeTopic.errorln(t2.toString());
                    SubscribeTopic.errorln(t2.getMessage());
                    t2.printStackTrace();
                }
            }
        });
    }
}

