/*
 * Decompiled with CFR 0.152.
 */
package io.vantiq.client.intg;

import com.google.gson.JsonObject;
import com.google.gson.internal.LinkedTreeMap;
import io.vantiq.client.SortSpec;
import io.vantiq.client.UnitTestResponseHandler;
import io.vantiq.client.UnitTestSubscriptionCallback;
import io.vantiq.client.Vantiq;
import io.vantiq.client.VantiqError;
import io.vantiq.client.VantiqResponse;
import io.vantiq.client.intg.IntegrationTests;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okio.BufferedSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class VantiqIntegrationTest {
    private Vantiq vantiq;
    private final UnitTestResponseHandler handler = new UnitTestResponseHandler();
    private static String server = null;
    private static String username = null;
    private static String password = null;
    private static String token = null;
    private static boolean usingProxy = false;

    @BeforeClass
    public static void setUpIntgTest() throws Exception {
        server = System.getProperty("server");
        username = System.getProperty("username");
        password = System.getProperty("password");
        token = System.getProperty("token");
        Boolean missingUserPass = username == null || password == null;
        Boolean missingToken = token == null;
        if (server == null || missingUserPass.booleanValue() && missingToken.booleanValue()) {
            throw new IllegalStateException("Must set 'server', 'username', and 'password', or 'token' Java System Properties");
        }
        String scheme = new URI(server).getScheme();
        usingProxy = System.getProperty(scheme + ".proxyHost") != null;
    }

    @Before
    public void setUp() throws Exception {
        this.doSetup(null);
    }

    void doSetup(Authenticator auth) throws Exception {
        this.vantiq = auth == null ? new Vantiq(server) : new Vantiq(server, auth);
        if (username != null && !username.equals("") && password != null && !password.equals("")) {
            this.vantiq.authenticate(username, password);
        } else if (token != null && !token.equals("")) {
            this.vantiq.setAccessToken(token);
        } else {
            throw new IllegalStateException("Must set 'server', 'username', and 'password', or 'token' Java System Properties");
        }
        this.waitForCompletion();
        MatcherAssert.assertThat((String)("Authenticated: " + this.handler), (Object)this.vantiq.isAuthenticated(), (Matcher)Is.is((Object)true));
        this.handler.reset();
    }

    @After
    public void tearDown() throws Exception {
        this.vantiq = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCompletion() throws InterruptedException {
        UnitTestResponseHandler unitTestResponseHandler = this.handler;
        synchronized (unitTestResponseHandler) {
            this.handler.wait(2000L);
        }
    }

    private String getISOString(Date d) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(d);
    }

    @Test
    public void testSelect() throws Exception {
        this.performSelectTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectUserAuthenticator() throws Exception {
        this.vantiq = null;
        String scheme = new URI(server).getScheme();
        final String proxyUser = System.getProperty(scheme + ".proxyUser");
        final String proxyPw = System.getProperty(scheme + ".proxyPassword");
        try {
            System.clearProperty(scheme + ".proxyUser");
            System.clearProperty(scheme + ".proxyPassword");
            Authenticator okAuth = new Authenticator(){

                @Override
                public Request authenticate(@Nullable Route route, @NotNull Response response) throws IOException {
                    String credential = Credentials.basic(proxyUser, proxyPw);
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
            };
            this.doSetup(okAuth);
            this.performSelectTest();
        }
        finally {
            if (proxyUser != null) {
                System.setProperty(scheme + ".proxyUser", proxyUser);
            }
            if (proxyPw != null) {
                System.setProperty(scheme + ".proxyPassword", proxyPw);
            }
        }
    }

    void performSelectTest() throws Exception {
        this.vantiq.select("system.types", null, null, null, this.handler);
        this.waitForCompletion();
        JsonObject match = null;
        for (JsonObject obj : this.handler.getBodyAsList()) {
            if (!"TestType".equals(obj.get("name").getAsString())) continue;
            match = obj;
        }
        MatcherAssert.assertThat((String)"TestType", match, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testSelectWithConstraints() throws Exception {
        JsonObject where = new JsonObject();
        where.addProperty("name", "TestType");
        this.vantiq.select("system.types", Arrays.asList("_id", "name"), (Object)where, null, this.handler);
        this.waitForCompletion();
        MatcherAssert.assertThat((String)"Single TestType result", (Object)this.handler.getBodyAsList().size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((String)"Single TestType result", (Object)this.handler.getBodyAsList().get(0).get("name").getAsString(), (Matcher)Is.is((Object)"TestType"));
    }

    @Test
    public void testSelectWithSorting() throws Exception {
        this.vantiq.select("system.types", Arrays.asList("_id", "name"), null, new SortSpec("name", true), this.handler);
        this.waitForCompletion();
        List<JsonObject> result = this.handler.getBodyAsList();
        String firstName = result.get(0).get("name").getAsString();
        String lastName = result.get(result.size() - 1).get("name").getAsString();
        MatcherAssert.assertThat((String)"Ensure results are sorted", (Object)firstName.compareTo(lastName), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testSelectOne() throws Exception {
        this.vantiq.selectOne("system.types", "TestType", this.handler);
        this.waitForCompletion();
        MatcherAssert.assertThat((String)"TestType result", (Object)this.handler.getBodyAsJsonObject().get("name").getAsString(), (Matcher)Is.is((Object)"TestType"));
    }

    @Test
    public void testCount() throws Exception {
        this.vantiq.select("system.types", Collections.singletonList("_id"), null, null, this.handler);
        this.waitForCompletion();
        int countFromSelect = this.handler.getBodyAsList().size();
        this.vantiq.count("system.types", null, this.handler.reset());
        this.waitForCompletion();
        MatcherAssert.assertThat((String)"Count match", (Object)this.handler.getBodyAsInt(), (Matcher)Is.is((Object)countFromSelect));
    }

    @Test
    public void testCountWithConstraints() throws Exception {
        JsonObject where = new JsonObject();
        where.addProperty("name", "TestType");
        this.vantiq.count("system.types", where, this.handler);
        this.waitForCompletion();
        MatcherAssert.assertThat((String)"Count match", (Object)this.handler.getBodyAsInt(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testInsertAndUpdateRecord() throws Exception {
        Date now = new Date();
        String id = "IU-" + now.getTime();
        JsonObject record = new JsonObject();
        record.addProperty("id", id);
        record.addProperty("ts", this.getISOString(now));
        record.addProperty("x", 3.14159);
        record.addProperty("k", 42);
        JsonObject embedded = new JsonObject();
        embedded.addProperty("a", 1);
        embedded.addProperty("b", 2);
        record.add("o", embedded);
        this.vantiq.insert("TestType", record, this.handler);
        this.waitForCompletion();
        JsonObject where = new JsonObject();
        where.addProperty("id", id);
        this.vantiq.select("TestType", null, (Object)where, null, this.handler.reset());
        this.waitForCompletion();
        MatcherAssert.assertThat((String)"Insert succeeded", (Object)this.handler.getBodyAsList().size(), (Matcher)Is.is((Object)1));
        JsonObject inserted = this.handler.getBodyAsList().get(0);
        MatcherAssert.assertThat((String)"Insert has correct value", (Object)inserted.get("k").getAsInt(), (Matcher)Is.is((Object)42));
        JsonObject toUpdate = new JsonObject();
        toUpdate.addProperty("k", 13);
        this.vantiq.update("TestType", inserted.get("_id").getAsString(), toUpdate, this.handler.reset());
        this.waitForCompletion();
        this.vantiq.select("TestType", null, (Object)where, null, this.handler.reset());
        this.waitForCompletion();
        MatcherAssert.assertThat((String)"Update succeeded", (Object)this.handler.getBodyAsList().size(), (Matcher)Is.is((Object)1));
        JsonObject updated = this.handler.getBodyAsList().get(0);
        MatcherAssert.assertThat((String)"Update has correct value", (Object)updated.get("k").getAsInt(), (Matcher)Is.is((Object)13));
        MatcherAssert.assertThat((String)"Update maintains other properties", (Object)updated.get("o").getAsJsonObject().get("a").getAsInt(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testUpsertRecord() throws Exception {
        Date now = new Date();
        String id = "UP-" + now.getTime();
        JsonObject record = new JsonObject();
        record.addProperty("id", id);
        record.addProperty("ts", this.getISOString(now));
        record.addProperty("x", 3.14159);
        record.addProperty("k", 42);
        JsonObject embedded = new JsonObject();
        embedded.addProperty("a", 1);
        embedded.addProperty("b", 2);
        record.add("o", embedded);
        this.vantiq.upsert("TestType", record, this.handler);
        this.waitForCompletion();
        Assert.assertTrue((String)"Upsert (insert) succeeded", (boolean)this.handler.success);
        JsonObject where = new JsonObject();
        where.addProperty("id", id);
        this.vantiq.select("TestType", null, (Object)where, null, this.handler.reset());
        this.waitForCompletion();
        MatcherAssert.assertThat((String)"Insert succeeded", (Object)this.handler.getBodyAsList().size(), (Matcher)Is.is((Object)1));
        JsonObject inserted = this.handler.getBodyAsList().get(0);
        MatcherAssert.assertThat((String)"Insert has correct value", (Object)inserted.get("k").getAsInt(), (Matcher)Is.is((Object)42));
        inserted.addProperty("k", 13);
        this.vantiq.upsert("TestType", inserted, this.handler.reset());
        this.waitForCompletion();
        Assert.assertTrue((String)"Upsert (update) succeeded", (boolean)this.handler.success);
        this.vantiq.select("TestType", null, (Object)where, null, this.handler.reset());
        this.waitForCompletion();
        MatcherAssert.assertThat((String)"Update succeeded", (Object)this.handler.getBodyAsList().size(), (Matcher)Is.is((Object)1));
        JsonObject updated = this.handler.getBodyAsList().get(0);
        MatcherAssert.assertThat((String)"Update has correct value", (Object)updated.get("k").getAsInt(), (Matcher)Is.is((Object)13));
        MatcherAssert.assertThat((String)"Update maintains other properties", (Object)updated.get("o").getAsJsonObject().get("a").getAsInt(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testDelete() throws Exception {
        Date now = new Date();
        String id = "DL-" + now.getTime();
        JsonObject record = new JsonObject();
        record.addProperty("id", id);
        record.addProperty("ts", this.getISOString(now));
        record.addProperty("x", 3.14159);
        record.addProperty("k", 42);
        JsonObject embedded = new JsonObject();
        embedded.addProperty("a", 1);
        embedded.addProperty("b", 2);
        record.add("o", embedded);
        this.vantiq.insert("TestType", record, this.handler);
        this.waitForCompletion();
        Assert.assertTrue((String)"Insert succeeded", (boolean)this.handler.success);
        HashMap<String, String> qual = new HashMap<String, String>();
        qual.put("id", id);
        this.vantiq.select("TestType", Arrays.asList("_id", "id"), qual, null, this.handler.reset());
        this.waitForCompletion();
        MatcherAssert.assertThat((String)"Select found inserted", (Object)this.handler.getBodyAsList().size(), (Matcher)Is.is((Object)1));
        JsonObject where = new JsonObject();
        where.addProperty("id", id);
        this.vantiq.delete("TestType", where, this.handler.reset());
        this.waitForCompletion();
        Assert.assertTrue((String)"Delete succeeded", (boolean)this.handler.success);
        this.vantiq.select("TestType", Arrays.asList("_id", "id"), qual, null, this.handler.reset());
        this.waitForCompletion();
        MatcherAssert.assertThat((String)"Delete removed record", (Object)this.handler.getBodyAsList().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void testDeleteOne() throws Exception {
        Date now = new Date();
        String id = "DLONE-" + now.getTime();
        JsonObject record = new JsonObject();
        record.addProperty("id", id);
        record.addProperty("ts", this.getISOString(now));
        record.addProperty("x", 3.14159);
        record.addProperty("k", 42);
        JsonObject embedded = new JsonObject();
        embedded.addProperty("a", 1);
        embedded.addProperty("b", 2);
        record.add("o", embedded);
        this.vantiq.insert("TestType", record, this.handler);
        this.waitForCompletion();
        Assert.assertTrue((String)"Insert succeeded", (boolean)this.handler.success);
        HashMap<String, String> qual = new HashMap<String, String>();
        qual.put("id", id);
        this.vantiq.select("TestType", Arrays.asList("_id", "id"), qual, null, this.handler.reset());
        this.waitForCompletion();
        MatcherAssert.assertThat((String)"Select found inserted", (Object)this.handler.getBodyAsList().size(), (Matcher)Is.is((Object)1));
        JsonObject match = this.handler.getBodyAsList().get(0);
        this.vantiq.deleteOne("TestType", match.get("_id").getAsString(), this.handler.reset());
        this.waitForCompletion();
        Assert.assertTrue((String)"Delete succeeded", (boolean)this.handler.success);
        this.vantiq.select("TestType", Arrays.asList("_id", "id"), qual, null, this.handler.reset());
        this.waitForCompletion();
        MatcherAssert.assertThat((String)"Delete removed record", (Object)this.handler.getBodyAsList().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void testPublishServiceEvent() throws Exception {
        Date now = new Date();
        String id = "PB-" + now.getTime();
        JsonObject message = new JsonObject();
        message.addProperty("id", id);
        message.addProperty("ts", this.getISOString(now));
        message.addProperty("x", 3.14159);
        message.addProperty("k", 42);
        JsonObject embedded = new JsonObject();
        embedded.addProperty("a", 1);
        embedded.addProperty("b", 2);
        message.add("o", embedded);
        this.vantiq.publish(Vantiq.SystemResources.SERVICES.value(), "testService/inboundTestEvent", message, this.handler);
        this.waitForCompletion();
        Assert.assertTrue((String)"Publish to Svc Event succeeded", (boolean)this.handler.success);
        Thread.sleep(1500L);
        JsonObject where = new JsonObject();
        where.addProperty("id", id);
        this.vantiq.select("TestType", null, (Object)where, null, this.handler.reset());
        this.waitForCompletion();
        MatcherAssert.assertThat((String)"Found result", (Object)this.handler.getBodyAsList().size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((String)"Correct value", (Object)this.handler.getBodyAsList().get(0).get("k").getAsInt(), (Matcher)Is.is((Object)42));
    }

    @Test
    public void testPublishTopic() throws Exception {
        Date now = new Date();
        String id = "PBT-" + now.getTime();
        JsonObject message = new JsonObject();
        message.addProperty("id", id);
        message.addProperty("ts", this.getISOString(now));
        message.addProperty("x", 3.14159);
        message.addProperty("k", 42);
        JsonObject embedded = new JsonObject();
        embedded.addProperty("a", 1);
        embedded.addProperty("b", 2);
        message.add("o", embedded);
        this.vantiq.publish("topics", "/test/topic", message, this.handler);
        this.waitForCompletion();
        Assert.assertTrue((String)"Publish succeeded", (boolean)this.handler.success);
        Thread.sleep(5000L);
        JsonObject where = new JsonObject();
        where.addProperty("id", id);
        this.vantiq.select("TestType", null, (Object)where, null, this.handler.reset());
        this.waitForCompletion();
        MatcherAssert.assertThat((String)"Found result", (Object)this.handler.getBodyAsList().size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((String)"Correct value", (Object)this.handler.getBodyAsList().get(0).get("k").getAsInt(), (Matcher)Is.is((Object)42));
    }

    @Test
    public void testExecuteProcedure() throws Exception {
        JsonObject params = new JsonObject();
        params.addProperty("arg1", 3.14159);
        params.addProperty("arg2", "xxx");
        this.vantiq.execute("echo", params, this.handler);
        this.waitForCompletion();
        MatcherAssert.assertThat((String)("No Errors" + this.handler.getErrors()), (boolean)this.handler.success);
        MatcherAssert.assertThat((String)"Response body exists", (this.handler.getBodyAsJsonObject() != null ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"Response property exists", (this.handler.getBodyAsJsonObject().get("arg1") != null ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"Valid response", (Object)this.handler.getBodyAsJsonObject().get("arg1").getAsDouble(), (Matcher)Is.is((Object)3.14159));
        MatcherAssert.assertThat((String)"Valid response", (Object)this.handler.getBodyAsJsonObject().get("arg2").getAsString(), (Matcher)Is.is((Object)"xxx"));
    }

    @Test
    public void testSubscribeServiceEvent() throws Exception {
        UnitTestSubscriptionCallback callback = new UnitTestSubscriptionCallback();
        this.vantiq.subscribe(Vantiq.SystemResources.SERVICES.value(), "testService/testEvent", null, callback);
        callback.waitForCompletion(5000);
        MatcherAssert.assertThat((String)"Connected", (Object)callback.isConnected(), (Matcher)Is.is((Object)true));
        callback.reset();
        JsonObject params = new JsonObject();
        this.vantiq.execute("testService.publishToOutbound", params, this.handler);
        this.waitForCompletion();
        callback.waitForCompletion(5000);
        MatcherAssert.assertThat((String)"Message received", (Object)callback.hasFired(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((String)"Request Id", (Object)callback.getMessage().getHeaders().get("X-Request-Id"), (Matcher)Is.is((Object)"/services/testService/testEvent"));
        Map respBody = (Map)callback.getMessage().getBody();
        MatcherAssert.assertThat((String)"Body Path", (Object)((String)respBody.get("path")), (Matcher)Is.is((Object)"/topics/services/testService/testEvent/publish"));
        MatcherAssert.assertThat((String)"Event contents type", (Object)((Map)respBody.get("value")), (Matcher)CoreMatchers.instanceOf(Map.class));
        MatcherAssert.assertThat((String)"Event contents value", (Object)((String)((Map)respBody.get("value")).get("name")), (Matcher)Is.is((Object)"outbound event"));
    }

    @Test
    public void testSubscribeTopic() throws Exception {
        UnitTestSubscriptionCallback callback = new UnitTestSubscriptionCallback();
        this.vantiq.subscribe(Vantiq.SystemResources.TOPICS.value(), "/test/topic", null, callback);
        callback.waitForCompletion(5000);
        MatcherAssert.assertThat((String)"Connected", (Object)callback.isConnected(), (Matcher)Is.is((Object)true));
        callback.reset();
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("ts", this.getISOString(new Date()));
        body.put("id", "SUB-" + new Date().getTime());
        VantiqResponse r = this.vantiq.publish("topics", "/test/topic", body);
        MatcherAssert.assertThat((String)"Valid publish", (Object)r.isSuccess(), (Matcher)Is.is((Object)true));
        callback.waitForCompletion();
        MatcherAssert.assertThat((String)"Message received", (Object)callback.hasFired(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((String)"Request Id", (Object)callback.getMessage().getHeaders().get("X-Request-Id"), (Matcher)Is.is((Object)"/topics/test/topic"));
        Map respBody = (Map)callback.getMessage().getBody();
        MatcherAssert.assertThat((String)"Body Path", (Object)((String)respBody.get("path")), (Matcher)Is.is((Object)"/topics/test/topic/publish"));
    }

    @Test
    public void testSubscribeReliableTopic() throws Exception {
        HashMap<String, Object> topic = new HashMap<String, Object>();
        topic.put("name", "/test/topic");
        topic.put("description", "topic description");
        topic.put("isReliable", true);
        topic.put("redeliveryFrequency", 1);
        topic.put("redeliveryTTL", 100);
        VantiqResponse t2 = this.vantiq.upsert("system.topics", topic);
        MatcherAssert.assertThat((String)"Valid insert", (Object)t2.isSuccess(), (Matcher)Is.is((Object)true));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("persistent", true);
        UnitTestSubscriptionCallback callback = new UnitTestSubscriptionCallback();
        this.vantiq.subscribe(Vantiq.SystemResources.TOPICS.value(), "/test/topic", null, callback, params);
        callback.waitForConnection();
        MatcherAssert.assertThat((String)"Connected", (Object)callback.isConnected(), (Matcher)Is.is((Object)true));
        LinkedTreeMap msg = (LinkedTreeMap)callback.getMessage().getBody();
        MatcherAssert.assertThat(msg.get("subscriptionName"), (Matcher)CoreMatchers.instanceOf(String.class));
        MatcherAssert.assertThat((Object)callback.getMessage().getHeaders().get("X-Request-Id"), (Matcher)CoreMatchers.instanceOf(String.class));
        if (!callback.isConnected()) {
            callback.reset();
            callback.waitForCompletion();
        }
        MatcherAssert.assertThat((String)"Connected", (Object)callback.isConnected(), (Matcher)Is.is((Object)true));
        callback.reset();
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("ts", this.getISOString(new Date()));
        body.put("id", "SUBRE-" + new Date().getTime());
        VantiqResponse r = this.vantiq.publish("topics", "/test/topic", body);
        MatcherAssert.assertThat((String)"Valid publish", (Object)r.isSuccess(), (Matcher)Is.is((Object)true));
        callback.waitForCompletion();
        MatcherAssert.assertThat((String)"Message received", (Object)callback.hasFired(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((String)"Request Id", (Object)callback.getMessage().getHeaders().get("X-Request-Id"), (Matcher)Is.is((Object)"/topics/test/topic"));
        Map respBody = (Map)callback.getMessage().getBody();
        MatcherAssert.assertThat((String)"Body Path", (Object)((String)respBody.get("path")), (Matcher)Is.is((Object)"/topics/test/topic/publish"));
        callback.reset();
        callback.waitForCompletion();
        MatcherAssert.assertThat((String)"Message received", (Object)callback.hasFired(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((String)"Request Id", (Object)callback.getMessage().getHeaders().get("X-Request-Id"), (Matcher)Is.is((Object)"/topics/test/topic"));
        respBody = (Map)callback.getMessage().getBody();
        MatcherAssert.assertThat((String)"Body Path", (Object)((String)respBody.get("path")), (Matcher)Is.is((Object)"/topics/test/topic/publish"));
    }

    @Test
    public void testSubscribeReconnectReliableTopic() throws Exception {
        HashMap<String, Object> topic = new HashMap<String, Object>();
        topic.put("name", "/test/topic");
        topic.put("description", "topic description");
        topic.put("isReliable", true);
        topic.put("redeliveryFrequency", 1);
        topic.put("redeliveryTTL", 100);
        VantiqResponse t2 = this.vantiq.upsert("system.topics", topic);
        MatcherAssert.assertThat((String)"Valid insert", (Object)t2.isSuccess(), (Matcher)Is.is((Object)true));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("persistent", true);
        UnitTestSubscriptionCallback callback = new UnitTestSubscriptionCallback();
        this.vantiq.subscribe(Vantiq.SystemResources.TOPICS.value(), "/test/topic", null, callback, params);
        callback.waitForConnection();
        MatcherAssert.assertThat((String)"Connected", (Object)callback.isConnected(), (Matcher)Is.is((Object)true));
        LinkedTreeMap msg = (LinkedTreeMap)callback.getMessage().getBody();
        MatcherAssert.assertThat(msg.get("subscriptionName"), (Matcher)CoreMatchers.instanceOf(String.class));
        MatcherAssert.assertThat((Object)callback.getMessage().getHeaders().get("X-Request-Id"), (Matcher)CoreMatchers.instanceOf(String.class));
        String ackId = msg.get("subscriptionName").toString();
        String requestId = callback.getMessage().getHeaders().get("X-Request-Id");
        if (!callback.isConnected()) {
            callback.reset();
            callback.waitForCompletion();
        }
        MatcherAssert.assertThat((String)"Connected", (Object)callback.isConnected(), (Matcher)Is.is((Object)true));
        callback.reset();
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("ts", this.getISOString(new Date()));
        body.put("id", "RECONN-" + new Date().getTime());
        VantiqResponse r = this.vantiq.publish("topics", "/test/topic", body);
        MatcherAssert.assertThat((String)"Valid publish", (Object)r.isSuccess(), (Matcher)Is.is((Object)true));
        callback.waitForCompletion();
        MatcherAssert.assertThat((String)"Message received", (Object)callback.hasFired(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((String)"Request Id", (Object)callback.getMessage().getHeaders().get("X-Request-Id"), (Matcher)Is.is((Object)"/topics/test/topic"));
        Map respBody = (Map)callback.getMessage().getBody();
        MatcherAssert.assertThat((String)"Body Path", (Object)((String)respBody.get("path")), (Matcher)Is.is((Object)"/topics/test/topic/publish"));
        callback.reset();
        callback.waitForCompletion();
        MatcherAssert.assertThat((String)"Message received", (Object)callback.hasFired(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((String)"Request Id", (Object)callback.getMessage().getHeaders().get("X-Request-Id"), (Matcher)Is.is((Object)"/topics/test/topic"));
        respBody = (Map)callback.getMessage().getBody();
        MatcherAssert.assertThat((String)"Body Path", (Object)((String)respBody.get("path")), (Matcher)Is.is((Object)"/topics/test/topic/publish"));
        this.vantiq.closeWebsocket();
        params.put("requestId", requestId);
        params.put("subscriptionId", ackId);
        this.vantiq.subscribe(Vantiq.SystemResources.TOPICS.value(), "/test/topic", null, callback, params);
        callback.waitForCompletion();
        MatcherAssert.assertThat((String)"Message received", (Object)callback.hasFired(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((String)"Request Id", (Object)callback.getMessage().getHeaders().get("X-Request-Id"), (Matcher)Is.is((Object)"/topics/test/topic"));
        callback.reset();
        callback.waitForCompletion();
        MatcherAssert.assertThat((String)"Message received", (Object)callback.hasFired(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((String)"Request Id", (Object)callback.getMessage().getHeaders().get("X-Request-Id"), (Matcher)Is.is((Object)"/topics/test/topic"));
        callback.reset();
    }

    @Test
    public void testAcknowledgeReliableTopic() throws Exception {
        HashMap<String, Object> topic = new HashMap<String, Object>();
        topic.put("name", "/test/topic");
        topic.put("description", "topic description");
        topic.put("isReliable", true);
        topic.put("redeliveryFrequency", 5);
        topic.put("redeliveryTTL", 100);
        VantiqResponse t2 = this.vantiq.upsert("system.topics", topic);
        MatcherAssert.assertThat((String)"Valid insert", (Object)t2.isSuccess(), (Matcher)Is.is((Object)true));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("persistent", true);
        UnitTestSubscriptionCallback callback = new UnitTestSubscriptionCallback();
        this.vantiq.subscribe(Vantiq.SystemResources.TOPICS.value(), "/test/topic", null, callback, params);
        callback.waitForConnection();
        MatcherAssert.assertThat((String)"Connected", (Object)callback.isConnected(), (Matcher)Is.is((Object)true));
        LinkedTreeMap msg = (LinkedTreeMap)callback.getMessage().getBody();
        MatcherAssert.assertThat(msg.get("subscriptionName"), (Matcher)CoreMatchers.instanceOf(String.class));
        MatcherAssert.assertThat((Object)callback.getMessage().getHeaders().get("X-Request-Id"), (Matcher)CoreMatchers.instanceOf(String.class));
        String ackId = msg.get("subscriptionName").toString();
        String requestId = callback.getMessage().getHeaders().get("X-Request-Id");
        if (!callback.isConnected()) {
            callback.reset();
            callback.waitForCompletion();
        }
        MatcherAssert.assertThat((String)"Connected", (Object)callback.isConnected(), (Matcher)Is.is((Object)true));
        callback.reset();
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("ts", this.getISOString(new Date()));
        body.put("id", "ACK-" + new Date().getTime());
        VantiqResponse r = this.vantiq.publish("topics", "/test/topic", body);
        MatcherAssert.assertThat((String)"Valid publish", (Object)r.isSuccess(), (Matcher)Is.is((Object)true));
        callback.waitForCompletion();
        MatcherAssert.assertThat((String)"Message received", (Object)callback.hasFired(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((String)"Request Id", (Object)callback.getMessage().getHeaders().get("X-Request-Id"), (Matcher)Is.is((Object)"/topics/test/topic"));
        Map respBody = (Map)callback.getMessage().getBody();
        MatcherAssert.assertThat((String)"Body Path", (Object)((String)respBody.get("path")), (Matcher)Is.is((Object)"/topics/test/topic/publish"));
        callback.reset();
        this.vantiq.ack(ackId, requestId, respBody);
        this.waitForCompletion();
        HashMap<String, String> where = new HashMap<String, String>();
        where.put("subscriptionName", ackId);
        this.vantiq.select("ArsEventAcknowledgement", null, where, null);
    }

    @Test
    @Ignore(value="Setup JSONPlaceholder polling Source and run this test explicitly")
    public void testSubscribeSource() throws Exception {
        UnitTestSubscriptionCallback callback = new UnitTestSubscriptionCallback();
        this.vantiq.subscribe(Vantiq.SystemResources.SOURCES.value(), "JSONPlaceholder", null, callback);
        callback.waitForCompletion();
        MatcherAssert.assertThat((String)"Connected", (Object)callback.isConnected(), (Matcher)Is.is((Object)true));
        callback.reset();
        callback.waitForCompletion(5000);
        MatcherAssert.assertThat((String)"Message received", (Object)callback.hasFired(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((String)"Request Id", (Object)callback.getMessage().getHeaders().get("X-Request-Id"), (Matcher)Is.is((Object)"/sources/JSONPlaceholder"));
        Map respBody = (Map)callback.getMessage().getBody();
        MatcherAssert.assertThat((String)"Body Path", (Object)((String)respBody.get("path")), (Matcher)Is.is((Object)"/sources/JSONPlaceholder/receive"));
    }

    @Test
    public void testSubscribeType() throws Exception {
        UnitTestSubscriptionCallback callback = new UnitTestSubscriptionCallback();
        this.vantiq.subscribe(Vantiq.SystemResources.TYPES.value(), "TestType", Vantiq.TypeOperation.INSERT, callback);
        callback.waitForCompletion();
        MatcherAssert.assertThat((String)"Connected", (Object)callback.isConnected(), (Matcher)Is.is((Object)true));
        callback.reset();
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("id", "SUB-" + new Date().getTime());
        record.put("ts", "2016-10-26T23:22:12Z");
        record.put("x", 3.14159);
        record.put("k", 42);
        HashMap<String, Integer> inner = new HashMap<String, Integer>();
        inner.put("a", 1);
        inner.put("b", 2);
        record.put("o", inner);
        VantiqResponse r = this.vantiq.insert("TestType", record);
        MatcherAssert.assertThat((String)"Valid insert", (Object)r.isSuccess(), (Matcher)Is.is((Object)true));
        callback.waitForCompletion(5000);
        MatcherAssert.assertThat((String)"Message received", (Object)callback.hasFired(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((String)"Request Id", (Object)callback.getMessage().getHeaders().get("X-Request-Id"), (Matcher)Is.is((Object)"/types/TestType/insert"));
        Map respBody = (Map)callback.getMessage().getBody();
        MatcherAssert.assertThat((String)"Body Path", (Object)((String)respBody.get("path")), (Matcher)CoreMatchers.startsWith((String)"/types/TestType/insert"));
    }

    @Test
    public void testUploadAndDownload() throws Exception {
        String fileName = "testFile.txt";
        File file = new File(this.getClass().getResource("/" + fileName).getFile());
        this.vantiq.upload(file, "text/plain", fileName, this.handler);
        this.waitForCompletion();
        Assert.assertTrue((String)"Upload succeeded", (boolean)this.handler.success);
        MatcherAssert.assertThat((String)"Correct name", (Object)((JsonObject)this.handler.getBody()).get("name").getAsString(), (Matcher)Is.is((Object)fileName));
        MatcherAssert.assertThat((String)"Correct fileType", (Object)((JsonObject)this.handler.getBody()).get("fileType").getAsString(), (Matcher)Is.is((Object)"text/plain"));
        MatcherAssert.assertThat((String)"Correct content", (Object)((JsonObject)this.handler.getBody()).get("content").getAsString(), (Matcher)Is.is((Object)("/docs/" + fileName)));
        this.handler.reset();
        this.vantiq.selectOne("system.documents", fileName, this.handler);
        this.waitForCompletion();
        Assert.assertTrue((String)"Select succeeded", (boolean)this.handler.success);
        MatcherAssert.assertThat((String)"Correct name", (Object)((JsonObject)this.handler.getBody()).get("name").getAsString(), (Matcher)Is.is((Object)fileName));
        MatcherAssert.assertThat((String)"Correct fileType", (Object)((JsonObject)this.handler.getBody()).get("fileType").getAsString(), (Matcher)Is.is((Object)"text/plain"));
        MatcherAssert.assertThat((String)"Correct content", (Object)((JsonObject)this.handler.getBody()).get("content").getAsString(), (Matcher)Is.is((Object)("/docs/" + fileName)));
        this.handler.reset();
        this.vantiq.download("/docs/" + fileName, this.handler);
        this.waitForCompletion();
        MatcherAssert.assertThat((String)"Download succeeded", (boolean)this.handler.success);
        MatcherAssert.assertThat((String)"Correct content type", (Object)this.handler.getContentType(), (Matcher)Is.is((Object)"text/plain"));
        BufferedSource source2 = (BufferedSource)this.handler.getBody();
        MatcherAssert.assertThat((String)"Correct file content", (Object)source2.readByteArray(), (Matcher)Is.is((Object)Files.readAllBytes(file.toPath())));
    }

    @Test
    public void testUploadAndDownloadSync() throws Exception {
        String fileName = "testFile.txt";
        File file = new File(this.getClass().getResource("/" + fileName).getFile());
        VantiqResponse response = this.vantiq.upload(file, "text/plain", fileName);
        Assert.assertTrue((String)"Upload succeeded", (boolean)response.isSuccess());
        MatcherAssert.assertThat((String)"Correct name", (Object)((JsonObject)response.getBody()).get("name").getAsString(), (Matcher)Is.is((Object)fileName));
        MatcherAssert.assertThat((String)"Correct fileType", (Object)((JsonObject)response.getBody()).get("fileType").getAsString(), (Matcher)Is.is((Object)"text/plain"));
        MatcherAssert.assertThat((String)"Correct content", (Object)((JsonObject)response.getBody()).get("content").getAsString(), (Matcher)Is.is((Object)("/docs/" + fileName)));
        response = this.vantiq.selectOne("system.documents", fileName);
        Assert.assertTrue((String)"Select succeeded", (boolean)response.isSuccess());
        MatcherAssert.assertThat((String)"Correct name", (Object)((JsonObject)response.getBody()).get("name").getAsString(), (Matcher)Is.is((Object)fileName));
        MatcherAssert.assertThat((String)"Correct fileType", (Object)((JsonObject)response.getBody()).get("fileType").getAsString(), (Matcher)Is.is((Object)"text/plain"));
        MatcherAssert.assertThat((String)"Correct content", (Object)((JsonObject)response.getBody()).get("content").getAsString(), (Matcher)Is.is((Object)("/docs/" + fileName)));
        response = this.vantiq.download("/docs/" + fileName);
        MatcherAssert.assertThat((String)"Download succeeded", (boolean)response.isSuccess());
        MatcherAssert.assertThat((String)"Correct content type", (Object)response.getContentType(), (Matcher)Is.is((Object)"text/plain"));
        BufferedSource source2 = (BufferedSource)response.getBody();
        MatcherAssert.assertThat((String)"Correct file content", (Object)source2.readByteArray(), (Matcher)Is.is((Object)Files.readAllBytes(file.toPath())));
    }

    @Test
    public void testUploadAndDownloadJPG() throws Exception {
        String fileName = "testImage.jpg";
        this.testUploadAndDownloadImageHelper(fileName, "image/jpeg");
    }

    @Test
    public void testUploadAndDownloadPNG() throws Exception {
        String fileName = "testImage.png";
        this.testUploadAndDownloadImageHelper(fileName, "image/png");
    }

    public void testUploadAndDownloadImageHelper(String fileName, String contentType) throws Exception {
        File file = new File(this.getClass().getResource("/" + fileName).getFile());
        String resourcePath = "/resources/" + Vantiq.SystemResources.IMAGES.value();
        this.vantiq.upload(file, contentType, fileName, resourcePath, this.handler);
        this.waitForCompletion();
        if (this.handler.error) {
            List<VantiqError> errs = this.handler.getErrors();
            assert (errs.size() == 1);
            VantiqError err = errs.get(0);
            Assume.assumeFalse((boolean)"io.vantiq.resource.not.installed".equals(err.getCode()));
        }
        Assert.assertTrue((String)"Upload succeeded", (boolean)this.handler.success);
        MatcherAssert.assertThat((String)"Correct name", (Object)((JsonObject)this.handler.getBody()).get("name").getAsString(), (Matcher)Is.is((Object)fileName));
        MatcherAssert.assertThat((String)"Correct fileType", (Object)((JsonObject)this.handler.getBody()).get("fileType").getAsString(), (Matcher)Is.is((Object)contentType));
        MatcherAssert.assertThat((String)"Correct content", (Object)((JsonObject)this.handler.getBody()).get("content").getAsString(), (Matcher)Is.is((Object)("/pics/" + fileName)));
        this.handler.reset();
        this.vantiq.selectOne("system.images", fileName, this.handler);
        this.waitForCompletion();
        Assert.assertTrue((String)"Select succeeded", (boolean)this.handler.success);
        MatcherAssert.assertThat((String)"Correct name", (Object)((JsonObject)this.handler.getBody()).get("name").getAsString(), (Matcher)Is.is((Object)fileName));
        MatcherAssert.assertThat((String)"Correct fileType", (Object)((JsonObject)this.handler.getBody()).get("fileType").getAsString(), (Matcher)Is.is((Object)contentType));
        MatcherAssert.assertThat((String)"Correct content", (Object)((JsonObject)this.handler.getBody()).get("content").getAsString(), (Matcher)Is.is((Object)("/pics/" + fileName)));
        this.handler.reset();
        this.vantiq.download("/pics/" + fileName, this.handler);
        this.waitForCompletion();
        MatcherAssert.assertThat((String)"Download succeeded", (boolean)this.handler.success);
        MatcherAssert.assertThat((String)"Correct content type", (Object)this.handler.getContentType(), (Matcher)Is.is((Object)contentType));
        BufferedSource source2 = (BufferedSource)this.handler.getBody();
        MatcherAssert.assertThat((String)"Correct file content", (Object)source2.readByteArray(), (Matcher)Is.is((Object)Files.readAllBytes(file.toPath())));
    }

    @Test
    public void testUploadAndDownloadJPGSync() throws Exception {
        String fileName = "testImage.jpg";
        this.testUploadAndDownloadImageSyncHelper(fileName, "image/jpeg");
    }

    @Test
    public void testUploadAndDownloadPNGSync() throws Exception {
        String fileName = "testImage.png";
        this.testUploadAndDownloadImageSyncHelper(fileName, "image/png");
    }

    public void testUploadAndDownloadImageSyncHelper(String fileName, String contentType) throws Exception {
        String resourcePath;
        File file = new File(this.getClass().getResource("/" + fileName).getFile());
        VantiqResponse response = this.vantiq.upload(file, contentType, fileName, resourcePath = "/resources/" + Vantiq.SystemResources.IMAGES.value());
        if (response.hasErrors()) {
            List<VantiqError> errs = response.getErrors();
            assert (errs.size() == 1);
            VantiqError err = errs.get(0);
            Assume.assumeFalse((boolean)"io.vantiq.resource.not.installed".equals(err.getCode()));
        }
        Assert.assertTrue((String)"Upload succeeded", (boolean)response.isSuccess());
        MatcherAssert.assertThat((String)"Correct name", (Object)((JsonObject)response.getBody()).get("name").getAsString(), (Matcher)Is.is((Object)fileName));
        MatcherAssert.assertThat((String)"Correct fileType", (Object)((JsonObject)response.getBody()).get("fileType").getAsString(), (Matcher)Is.is((Object)contentType));
        MatcherAssert.assertThat((String)"Correct content", (Object)((JsonObject)response.getBody()).get("content").getAsString(), (Matcher)Is.is((Object)("/pics/" + fileName)));
        response = this.vantiq.selectOne("system.images", fileName);
        Assert.assertTrue((String)"Select succeeded", (boolean)response.isSuccess());
        MatcherAssert.assertThat((String)"Correct name", (Object)((JsonObject)response.getBody()).get("name").getAsString(), (Matcher)Is.is((Object)fileName));
        MatcherAssert.assertThat((String)"Correct fileType", (Object)((JsonObject)response.getBody()).get("fileType").getAsString(), (Matcher)Is.is((Object)contentType));
        MatcherAssert.assertThat((String)"Correct content", (Object)((JsonObject)response.getBody()).get("content").getAsString(), (Matcher)Is.is((Object)("/pics/" + fileName)));
        response = this.vantiq.download("/pics/" + fileName);
        MatcherAssert.assertThat((String)"Download succeeded", (boolean)response.isSuccess());
        MatcherAssert.assertThat((String)"Correct content type", (Object)response.getContentType(), (Matcher)Is.is((Object)contentType));
        BufferedSource source2 = (BufferedSource)response.getBody();
        MatcherAssert.assertThat((String)"Correct file content", (Object)source2.readByteArray(), (Matcher)Is.is((Object)Files.readAllBytes(file.toPath())));
    }

    @Test
    public void testUploadAndDownloadVideo() throws Exception {
        String fileName = "testVideo.mp4";
        File file = new File(this.getClass().getResource("/" + fileName).getFile());
        String resourcePath = "/resources/" + Vantiq.SystemResources.VIDEOS.value();
        this.vantiq.upload(file, "video/mp4", fileName, resourcePath, this.handler);
        this.waitForCompletion();
        if (this.handler.error) {
            List<VantiqError> errs = this.handler.getErrors();
            assert (errs.size() == 1);
            VantiqError err = errs.get(0);
            Assume.assumeFalse((boolean)"io.vantiq.resource.not.installed".equals(err.getCode()));
        }
        Assert.assertTrue((String)"Upload succeeded", (boolean)this.handler.success);
        MatcherAssert.assertThat((String)"Correct name", (Object)((JsonObject)this.handler.getBody()).get("name").getAsString(), (Matcher)Is.is((Object)fileName));
        MatcherAssert.assertThat((String)"Correct fileType", (Object)((JsonObject)this.handler.getBody()).get("fileType").getAsString(), (Matcher)Is.is((Object)"video/mp4"));
        MatcherAssert.assertThat((String)"Correct content", (Object)((JsonObject)this.handler.getBody()).get("content").getAsString(), (Matcher)Is.is((Object)("/vids/" + fileName)));
        this.handler.reset();
        this.vantiq.selectOne("system.videos", fileName, this.handler);
        this.waitForCompletion();
        Assert.assertTrue((String)"Select succeeded", (boolean)this.handler.success);
        MatcherAssert.assertThat((String)"Correct name", (Object)((JsonObject)this.handler.getBody()).get("name").getAsString(), (Matcher)Is.is((Object)fileName));
        MatcherAssert.assertThat((String)"Correct fileType", (Object)((JsonObject)this.handler.getBody()).get("fileType").getAsString(), (Matcher)Is.is((Object)"video/mp4"));
        MatcherAssert.assertThat((String)"Correct content", (Object)((JsonObject)this.handler.getBody()).get("content").getAsString(), (Matcher)Is.is((Object)("/vids/" + fileName)));
        this.handler.reset();
        this.vantiq.download("/vids/" + fileName, this.handler);
        this.waitForCompletion();
        MatcherAssert.assertThat((String)"Download succeeded", (boolean)this.handler.success);
        MatcherAssert.assertThat((String)"Correct content type", (Object)this.handler.getContentType(), (Matcher)Is.is((Object)"video/mp4"));
        BufferedSource source2 = (BufferedSource)this.handler.getBody();
        MatcherAssert.assertThat((String)"Correct file content", (Object)source2.readByteArray(), (Matcher)Is.is((Object)Files.readAllBytes(file.toPath())));
    }

    @Test
    public void testUploadAndDownloadVideoSync() throws Exception {
        String resourcePath;
        String fileName = "testVideo.mp4";
        File file = new File(this.getClass().getResource("/" + fileName).getFile());
        VantiqResponse response = this.vantiq.upload(file, "video/mp4", fileName, resourcePath = "/resources/" + Vantiq.SystemResources.VIDEOS.value());
        if (response.hasErrors()) {
            List<VantiqError> errs = response.getErrors();
            assert (errs.size() == 1);
            VantiqError err = errs.get(0);
            Assume.assumeFalse((boolean)"io.vantiq.resource.not.installed".equals(err.getCode()));
        }
        Assert.assertTrue((String)"Upload succeeded", (boolean)response.isSuccess());
        MatcherAssert.assertThat((String)"Correct name", (Object)((JsonObject)response.getBody()).get("name").getAsString(), (Matcher)Is.is((Object)fileName));
        MatcherAssert.assertThat((String)"Correct fileType", (Object)((JsonObject)response.getBody()).get("fileType").getAsString(), (Matcher)Is.is((Object)"video/mp4"));
        MatcherAssert.assertThat((String)"Correct content", (Object)((JsonObject)response.getBody()).get("content").getAsString(), (Matcher)Is.is((Object)("/vids/" + fileName)));
        response = this.vantiq.selectOne("system.videos", fileName);
        Assert.assertTrue((String)"Select succeeded", (boolean)response.isSuccess());
        MatcherAssert.assertThat((String)"Correct name", (Object)((JsonObject)response.getBody()).get("name").getAsString(), (Matcher)Is.is((Object)fileName));
        MatcherAssert.assertThat((String)"Correct fileType", (Object)((JsonObject)response.getBody()).get("fileType").getAsString(), (Matcher)Is.is((Object)"video/mp4"));
        MatcherAssert.assertThat((String)"Correct content", (Object)((JsonObject)response.getBody()).get("content").getAsString(), (Matcher)Is.is((Object)("/vids/" + fileName)));
        response = this.vantiq.download("/vids/" + fileName);
        MatcherAssert.assertThat((String)"Download succeeded", (boolean)response.isSuccess());
        MatcherAssert.assertThat((String)"Correct content type", (Object)response.getContentType(), (Matcher)Is.is((Object)"video/mp4"));
        BufferedSource source2 = (BufferedSource)response.getBody();
        MatcherAssert.assertThat((String)"Correct file content", (Object)source2.readByteArray(), (Matcher)Is.is((Object)Files.readAllBytes(file.toPath())));
    }
}

