/*
 * Decompiled with CFR 0.152.
 */
package io.vantiq.client.internal;

import com.google.gson.JsonObject;
import io.vantiq.client.VantiqResponse;
import io.vantiq.client.VantiqTestBase;
import io.vantiq.client.internal.VantiqSession;
import java.io.File;
import okhttp3.mockwebserver.MockResponse;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VantiqSessionRequestTest
extends VantiqTestBase {
    private VantiqSession session;

    @Before
    public void setUpAuth() throws Exception {
        this.session = new VantiqSession(this.server.url("/").toString());
        this.server.enqueue(new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody(new VantiqTestBase.JsonObjectBuilder().addProperty("accessToken", "234592dadf23412").json()));
        this.session.authenticate("joe", "no-one-will-guess", this.handler);
        this.server.takeRequest();
        this.waitForCompletion();
        this.handler.reset();
    }

    @After
    public void tearDownSession() {
        this.session = null;
    }

    @Test
    public void testHandleJSONResponse() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody(new VantiqTestBase.JsonObjectBuilder().addProperty("a", 1.2).addProperty("b", 2.4).json()));
        this.session.get("/resources/types", null, this.handler);
        this.waitForCompletion();
        Assert.assertTrue((String)"Successful response", (boolean)this.handler.success);
        Assert.assertThat((String)"Valid body", (Object)this.handler.getBodyAsJsonObject().get("a").getAsDouble(), (Matcher)Is.is((Object)1.2));
    }

    @Test
    public void testHandleEmptyResponse() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200));
        this.session.get("/resources/types", null, this.handler);
        this.waitForCompletion();
        Assert.assertTrue((String)"Successful response", (boolean)this.handler.success);
        Assert.assertThat((String)"Empty bytes body", (Object)((byte[])this.handler.getBody()).length, (Matcher)Is.is((Object)0));
    }

    @Test
    public void testHandleNonJSONResponse() throws Exception {
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"text/plain").setResponseCode(200).setBody("Hello!"));
        this.session.get("/resources/types", null, this.handler);
        this.waitForCompletion();
        Assert.assertTrue((String)"Successful response", (boolean)this.handler.success);
        Assert.assertThat((String)"Plain text body", (Object)this.handler.getBodyAsString(), (Matcher)Is.is((Object)"Hello!"));
    }

    @Test
    public void testHandleJSONResponseSync() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody(new VantiqTestBase.JsonObjectBuilder().addProperty("a", 1.2).addProperty("b", 2.4).json()));
        VantiqResponse response = this.session.get("/resources/types", null, null);
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Valid body", (Object)((JsonObject)response.getBody()).get("a").getAsDouble(), (Matcher)Is.is((Object)1.2));
    }

    @Test
    public void testHandleEmptyResponseSync() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200));
        VantiqResponse response = this.session.get("/resources/types", null, null);
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Empty bytes body", (Object)((byte[])response.getBody()).length, (Matcher)Is.is((Object)0));
    }

    @Test
    public void testHandleNonJSONResponseSync() throws Exception {
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"text/plain").setResponseCode(200).setBody("Hello!"));
        VantiqResponse response = this.session.get("/resources/types", null, null);
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Plain text body", (Object)((String)response.getBody()), (Matcher)Is.is((Object)"Hello!"));
    }

    @Test
    public void testUpload() throws Exception {
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"application/json").setResponseCode(200).setBody(new VantiqTestBase.JsonObjectBuilder().addProperty("a", 1.2).addProperty("b", 2.4).json()));
        this.session.upload("/resources/documents", new File(this.getClass().getResource("/testFile.txt").getFile()), "text/plain", "Test File", null, this.handler);
        this.waitForCompletion();
        Assert.assertTrue((String)"Successful response", (boolean)this.handler.success);
    }

    @Test
    public void testUploadSync() throws Exception {
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"application/json").setResponseCode(200).setBody(new VantiqTestBase.JsonObjectBuilder().addProperty("a", 1.2).addProperty("b", 2.4).json()));
        VantiqResponse response = this.session.upload("/resources/documents", new File(this.getClass().getResource("/testFile.txt").getFile()), "text/plain", "Test File", null, null);
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
    }

    @Test
    public void testUploadImageJPG() throws Exception {
        String fileName = "/testImage.jpg";
        this.testUploadImageHelper(fileName, "image/jpeg");
    }

    @Test
    public void testUploadImagePNG() throws Exception {
        String fileName = "/testImage.png";
        this.testUploadImageHelper(fileName, "image/png");
    }

    public void testUploadImageHelper(String fileName, String contentType) throws Exception {
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"application/json").setResponseCode(200).setBody(new VantiqTestBase.JsonObjectBuilder().addProperty("a", 1.2).addProperty("b", 2.4).json()));
        this.session.upload("/resources/images", new File(this.getClass().getResource(fileName).getFile()), contentType, "Test File", null, this.handler);
        this.waitForCompletion();
        Assert.assertTrue((String)"Successful response", (boolean)this.handler.success);
    }

    @Test
    public void testUploadImageJPGSync() throws Exception {
        String fileName = "/testImage.jpg";
        this.testUploadImageSyncHelper(fileName, "image/jpeg");
    }

    @Test
    public void testUploadImagePNGSync() throws Exception {
        String fileName = "/testImage.png";
        this.testUploadImageSyncHelper(fileName, "image/png");
    }

    public void testUploadImageSyncHelper(String fileName, String contentType) throws Exception {
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"application/json").setResponseCode(200).setBody(new VantiqTestBase.JsonObjectBuilder().addProperty("a", 1.2).addProperty("b", 2.4).json()));
        VantiqResponse response = this.session.upload("/resources/images", new File(this.getClass().getResource(fileName).getFile()), contentType, "Test File", null, null);
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
    }

    @Test
    public void testUploadVideo() throws Exception {
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"application/json").setResponseCode(200).setBody(new VantiqTestBase.JsonObjectBuilder().addProperty("a", 1.2).addProperty("b", 2.4).json()));
        this.session.upload("/resources/videos", new File(this.getClass().getResource("/testVideo.mp4").getFile()), "video/mp4", "Test File", null, this.handler);
        this.waitForCompletion();
        Assert.assertTrue((String)"Successful response", (boolean)this.handler.success);
    }

    @Test
    public void testUploadVideoSync() throws Exception {
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"application/json").setResponseCode(200).setBody(new VantiqTestBase.JsonObjectBuilder().addProperty("a", 1.2).addProperty("b", 2.4).json()));
        VantiqResponse response = this.session.upload("/resources/videos", new File(this.getClass().getResource("/testVideo.mp4").getFile()), "video/mp4", "Test File", null, null);
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
    }
}

