/*
 * Decompiled with CFR 0.152.
 */
package io.vantiq.client.internal;

import io.vantiq.client.VantiqError;
import io.vantiq.client.VantiqResponse;
import io.vantiq.client.VantiqTestBase;
import io.vantiq.client.internal.VantiqSession;
import java.util.Collections;
import java.util.HashMap;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VantiqSessionConnectAuthTest
extends VantiqTestBase {
    private VantiqSession session;

    @Before
    public void setUpSession() {
        this.session = new VantiqSession(this.server.url("/").toString());
    }

    @After
    public void tearDownSession() {
        this.session = null;
    }

    @Test
    public void testAuthenticate() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody(new VantiqTestBase.JsonObjectBuilder().addProperty("accessToken", "abc123").json()));
        this.session.authenticate("joe", "no-one-will-guess", this.handler);
        this.waitForCompletion();
        Assert.assertTrue((String)"Successful response", (boolean)this.handler.success);
        Assert.assertTrue((String)"Session authenticated", (boolean)this.session.isAuthenticated());
        Assert.assertThat((String)"Valid access token", (Object)this.session.getAccessToken(), (Matcher)CoreMatchers.is((Object)"abc123"));
    }

    @Test
    public void testHandleAuthenticationFailure() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(401).setHeader("Content-Type", (Object)"application/json").setBody(this.toJson(Collections.singletonList(new VantiqError("io.vantiq.server.error", "Unauthorized", Collections.emptyList())))));
        this.session.authenticate("bad", "user", this.handler);
        this.waitForCompletion();
        Assert.assertTrue((String)"Should not be success", (!this.handler.success ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should be error", (boolean)this.handler.error);
        Assert.assertTrue((String)"Session not authenticated", (!this.session.isAuthenticated() ? 1 : 0) != 0);
        Assert.assertThat((String)"Should be no access token", (Object)this.session.getAccessToken(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((String)"HTTP Status", (Object)this.handler.getStatusCode(), (Matcher)CoreMatchers.is((Object)401));
        Assert.assertThat((String)"Error code", (Object)this.handler.getErrors().get(0).getCode(), (Matcher)CoreMatchers.is((Object)"io.vantiq.server.error"));
    }

    @Test
    public void testPassTokenOnAuthenticatedSession() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody(new VantiqTestBase.JsonObjectBuilder().addProperty("accessToken", "abc123").json()));
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"application/json").setResponseCode(200));
        this.session.authenticate("joe", "no-one-will-guess", this.handler);
        this.waitForCompletion();
        this.server.takeRequest();
        this.session.get("/resources/types", new HashMap<String, String>(), this.handler.reset());
        this.waitForCompletion();
        RecordedRequest request = this.server.takeRequest();
        Assert.assertThat((String)"Correct path", (Object)request.getPath(), (Matcher)CoreMatchers.is((Object)"/api/v1/resources/types"));
        Assert.assertThat((String)"Ensure token", (Object)request.getHeader("Authorization"), (Matcher)CoreMatchers.is((Object)("Bearer " + this.session.getAccessToken())));
        Assert.assertTrue((boolean)this.session.isAuthenticated());
    }

    @Test
    public void testUnauthorizedGet() throws Exception {
        try {
            this.session.get("/resources/types", null, this.handler);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }

    @Test
    public void testUnauthorizedPut() throws Exception {
        try {
            this.session.put("/resources/types/abc123", null, null, this.handler);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }

    @Test
    public void testUnauthorizedPost() throws Exception {
        try {
            this.session.post("/resources/types", null, null, this.handler);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }

    @Test
    public void testUnauthorizedDelete() throws Exception {
        try {
            this.session.delete("/resources/types/abc123", null, this.handler);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }

    @Test
    public void testAuthenticateSync() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody(new VantiqTestBase.JsonObjectBuilder().addProperty("accessToken", "abc123").json()));
        this.session.authenticate("joe", "no-one-will-guess", null);
        Assert.assertTrue((String)"Session authenticated", (boolean)this.session.isAuthenticated());
        Assert.assertThat((String)"Valid access token", (Object)this.session.getAccessToken(), (Matcher)CoreMatchers.is((Object)"abc123"));
    }

    @Test
    public void testHandleAuthenticationFailureSync() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(401).setHeader("Content-Type", (Object)"application/json").setBody(this.toJson(Collections.singletonList(new VantiqError("io.vantiq.server.error", "Unauthorized", Collections.emptyList())))));
        VantiqResponse response = this.session.authenticate("bad", "user", null);
        Assert.assertTrue((String)"Should not be success", (boolean)response.hasErrors());
        Assert.assertTrue((String)"Should be error", (!response.hasException() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Session not authenticated", (!this.session.isAuthenticated() ? 1 : 0) != 0);
        Assert.assertThat((String)"Should be no access token", (Object)this.session.getAccessToken(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((String)"HTTP Status", (Object)response.getStatusCode(), (Matcher)CoreMatchers.is((Object)401));
        Assert.assertThat((String)"Error code", (Object)response.getErrors().get(0).getCode(), (Matcher)CoreMatchers.is((Object)"io.vantiq.server.error"));
    }
}

