/*
 * Decompiled with CFR 0.152.
 */
package io.vantiq.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.vantiq.client.UnitTestResponseHandler;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.Map;
import okhttp3.mockwebserver.MockWebServer;
import okio.Buffer;
import org.junit.After;
import org.junit.Before;

public class VantiqTestBase {
    public static final String USERNAME = "joe";
    public static final String PASSWORD = "no-one-will-guess";
    protected MockWebServer server;
    protected final UnitTestResponseHandler handler;
    protected final Gson gson = new Gson();

    protected VantiqTestBase() {
        this(true);
    }

    protected VantiqTestBase(boolean useHandler) {
        this.handler = useHandler ? new UnitTestResponseHandler() : null;
    }

    @Before
    public void setUp() throws Exception {
        this.server = new MockWebServer();
        this.server.start();
        if (this.handler != null) {
            this.handler.reset();
        }
    }

    @After
    public void tearDown() throws Exception {
        this.server.shutdown();
        this.server = null;
    }

    protected String toJson(Object values2) {
        if (values2 instanceof List) {
            String v = this.gson.toJson(values2, new TypeToken<List>(){}.getType());
            return v;
        }
        if (values2 instanceof Map) {
            return this.gson.toJson(values2, new TypeToken<Map>(){}.getType());
        }
        throw new IllegalArgumentException("Invalid values type: " + values2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForCompletion() throws InterruptedException {
        UnitTestResponseHandler unitTestResponseHandler = this.handler;
        synchronized (unitTestResponseHandler) {
            this.handler.wait(2000L);
        }
    }

    public String readAll(Buffer body) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream((int)body.size());
        body.copyTo(os);
        return new String(os.toByteArray());
    }

    public class JsonObjectBuilder {
        private JsonObject obj = new JsonObject();

        public JsonObjectBuilder addProperty(String name, String value) {
            this.obj.addProperty(name, value);
            return this;
        }

        public JsonObjectBuilder addProperty(String name, Number value) {
            this.obj.addProperty(name, value);
            return this;
        }

        public JsonObject obj() {
            return this.obj;
        }

        public String json() {
            return VantiqTestBase.this.gson.toJson(this.obj);
        }
    }

    public class JsonArrayBuilder {
        private JsonArray arr = new JsonArray();

        public JsonArrayBuilder add(JsonObject obj) {
            this.arr.add(obj);
            return this;
        }

        public JsonArray array() {
            return this.arr;
        }

        public String json() {
            return VantiqTestBase.this.gson.toJson(this.arr);
        }
    }
}

