/*
 * Decompiled with CFR 0.152.
 */
package io.vantiq.client;

import com.google.gson.JsonObject;
import io.vantiq.client.SortSpec;
import io.vantiq.client.Vantiq;
import io.vantiq.client.VantiqResponse;
import io.vantiq.client.VantiqTestBase;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.StringContains;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VantiqRequestSyncTest
extends VantiqTestBase {
    private Vantiq vantiq;

    public VantiqRequestSyncTest() {
        super(false);
    }

    @Before
    public void setUpVantiq() throws Exception {
        this.vantiq = new Vantiq(this.server.url("/").toString());
        this.server.enqueue(new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody(new VantiqTestBase.JsonObjectBuilder(this).addProperty("accessToken", "234592dadf23412").json()));
        this.vantiq.authenticate("joe", "no-one-will-guess");
        Assert.assertThat((String)"Authenticated", (Object)this.vantiq.isAuthenticated(), (Matcher)Is.is((Object)true));
        this.server.takeRequest();
    }

    @After
    public void tearDownVantiq() {
        this.vantiq = null;
    }

    @Test
    public void testSelectQuery() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody(new VantiqTestBase.JsonArrayBuilder(this).add(new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 1).addProperty("b", "bingo").obj()).add(new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 2).addProperty("b", "jenga").obj()).json()));
        VantiqResponse response = this.vantiq.select("MyType", null, null, null);
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Valid body", (Object)((JsonObject)((List)response.getBody()).get(0)).get("a").getAsInt(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testSelectQueryWithOptions() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody(new VantiqTestBase.JsonArrayBuilder(this).add(new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 1).addProperty("b", "bingo").obj()).add(new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 2).addProperty("b", "jenga").obj()).json()));
        HashMap<String, String> options = null;
        options = new HashMap<String, String>();
        options.put("AnyOption", "true");
        VantiqResponse response = this.vantiq.select("MyType", null, null, null, 0L, options);
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
    }

    @Test
    public void testSelectQueryWithConstraints() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody(new VantiqTestBase.JsonArrayBuilder(this).add(new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 1).addProperty("b", "bingo").obj()).json()));
        List<String> props = Arrays.asList("_id", "b");
        JsonObject where = new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 1).obj();
        SortSpec sort = new SortSpec("a", true);
        VantiqResponse response = this.vantiq.select("MyType", props, where, sort);
        RecordedRequest request = this.server.takeRequest();
        HttpUrl url = HttpUrl.parse("http://localhost" + request.getPath());
        Assert.assertThat((String)"Valid props", (Object)url.queryParameter("props"), (Matcher)Is.is((Object)"[\"_id\",\"b\"]"));
        Assert.assertThat((String)"Valid where", (Object)url.queryParameter("where"), (Matcher)Is.is((Object)"{\"a\":1}"));
        Assert.assertThat((String)"Valid sort", (Object)url.queryParameter("sort"), (Matcher)Is.is((Object)"{\"a\":-1}"));
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Valid body", (Object)((JsonObject)((List)response.getBody()).get(0)).get("a").getAsInt(), (Matcher)Is.is((Object)1));
        Assert.assertThat((String)"Valid body", (Object)((JsonObject)((List)response.getBody()).get(0)).get("b").getAsString(), (Matcher)Is.is((Object)"bingo"));
    }

    @Test
    public void testSelectOne() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody(new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 1).addProperty("b", "bingo").json()));
        VantiqResponse response = this.vantiq.selectOne("MyType", "abc123");
        RecordedRequest request = this.server.takeRequest();
        Assert.assertThat((String)"Valid path", (Object)request.getPath(), (Matcher)Is.is((Object)"/api/v1/resources/custom/MyType/abc123"));
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Valid body", (Object)((JsonObject)response.getBody()).get("a").getAsInt(), (Matcher)Is.is((Object)1));
        Assert.assertThat((String)"Valid body", (Object)((JsonObject)response.getBody()).get("b").getAsString(), (Matcher)Is.is((Object)"bingo"));
    }

    @Test
    public void testCountQuery() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setHeader("X-Total-Count", (Object)2).setBody(new VantiqTestBase.JsonArrayBuilder(this).add(new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 1).addProperty("b", "bingo").obj()).add(new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 2).addProperty("b", "jenga").obj()).json()));
        VantiqResponse response = this.vantiq.count("MyType", null);
        RecordedRequest request = this.server.takeRequest();
        HttpUrl url = HttpUrl.parse("http://localhost" + request.getPath());
        Assert.assertThat((String)"Count parameter", (Object)url.queryParameter("count"), (Matcher)Is.is((Object)"true"));
        Assert.assertThat((String)"Props", (Object)url.queryParameter("props"), (Matcher)Is.is((Object)"[\"_id\"]"));
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Count", (Object)((Integer)response.getBody()), (Matcher)Is.is((Object)2));
    }

    @Test
    public void testCountQueryWithConstraints() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setHeader("X-Total-Count", (Object)1).setBody(new VantiqTestBase.JsonArrayBuilder(this).add(new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 1).addProperty("b", "bingo").obj()).json()));
        JsonObject where = new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 1).obj();
        VantiqResponse response = this.vantiq.count("MyType", where);
        RecordedRequest request = this.server.takeRequest();
        HttpUrl url = HttpUrl.parse("http://localhost" + request.getPath());
        Assert.assertThat((String)"Count parameter", (Object)url.queryParameter("count"), (Matcher)Is.is((Object)"true"));
        Assert.assertThat((String)"Props", (Object)url.queryParameter("props"), (Matcher)Is.is((Object)"[\"_id\"]"));
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Count", (Object)((Integer)response.getBody()), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testInsert() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody(new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 1).addProperty("b", "foo").json()));
        JsonObject obj = new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 1).addProperty("b", "foo").obj();
        VantiqResponse response = this.vantiq.insert("MyType", obj);
        RecordedRequest request = this.server.takeRequest();
        Assert.assertThat((String)"Valid path", (Object)request.getPath(), (Matcher)Is.is((Object)"/api/v1/resources/custom/MyType"));
        JsonObject reqObj = this.gson.fromJson(this.readAll(request.getBody()), JsonObject.class);
        Assert.assertThat((String)"Valid request body", (Object)reqObj.get("a").getAsInt(), (Matcher)Is.is((Object)1));
        Assert.assertThat((String)"Valid request body", (Object)reqObj.get("b").getAsString(), (Matcher)Is.is((Object)"foo"));
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Valid body", (Object)((JsonObject)response.getBody()).get("a").getAsInt(), (Matcher)Is.is((Object)1));
        Assert.assertThat((String)"Valid body", (Object)((JsonObject)response.getBody()).get("b").getAsString(), (Matcher)Is.is((Object)"foo"));
    }

    @Test
    public void testUpdate() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody(new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 1).addProperty("b", "foo").json()));
        JsonObject obj = new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 1).addProperty("b", "foo").obj();
        String key = "12345";
        VantiqResponse response = this.vantiq.update("MyType", key, obj);
        RecordedRequest request = this.server.takeRequest();
        Assert.assertThat((String)"Valid path", (Object)request.getPath(), (Matcher)Is.is((Object)"/api/v1/resources/custom/MyType/12345"));
        JsonObject reqObj = this.gson.fromJson(this.readAll(request.getBody()), JsonObject.class);
        Assert.assertThat((String)"Valid request body", (Object)reqObj.get("a").getAsInt(), (Matcher)Is.is((Object)1));
        Assert.assertThat((String)"Valid request body", (Object)reqObj.get("b").getAsString(), (Matcher)Is.is((Object)"foo"));
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Valid body", (Object)((JsonObject)response.getBody()).get("a").getAsInt(), (Matcher)Is.is((Object)1));
        Assert.assertThat((String)"Valid body", (Object)((JsonObject)response.getBody()).get("b").getAsString(), (Matcher)Is.is((Object)"foo"));
    }

    @Test
    public void testUpsert() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody(new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 1).addProperty("b", "foo").json()));
        JsonObject obj = new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 1).addProperty("b", "foo").obj();
        VantiqResponse response = this.vantiq.upsert("MyType", obj);
        RecordedRequest request = this.server.takeRequest();
        HttpUrl url = HttpUrl.parse("http://localhost" + request.getPath());
        Assert.assertThat((String)"Valid path", (Object)url.encodedPath(), (Matcher)Is.is((Object)"/api/v1/resources/custom/MyType"));
        Assert.assertThat((String)"Upsert parameter", (Object)url.queryParameter("upsert"), (Matcher)Is.is((Object)"true"));
        JsonObject reqObj = this.gson.fromJson(this.readAll(request.getBody()), JsonObject.class);
        Assert.assertThat((String)"Valid request body", (Object)reqObj.get("a").getAsInt(), (Matcher)Is.is((Object)1));
        Assert.assertThat((String)"Valid request body", (Object)reqObj.get("b").getAsString(), (Matcher)Is.is((Object)"foo"));
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Valid body", (Object)((JsonObject)response.getBody()).get("a").getAsInt(), (Matcher)Is.is((Object)1));
        Assert.assertThat((String)"Valid body", (Object)((JsonObject)response.getBody()).get("b").getAsString(), (Matcher)Is.is((Object)"foo"));
    }

    @Test
    public void testDelete() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(204).setHeader("X-Total-Count", (Object)2));
        JsonObject where = new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 1).obj();
        VantiqResponse response = this.vantiq.delete("MyType", where);
        RecordedRequest request = this.server.takeRequest();
        HttpUrl url = HttpUrl.parse("http://localhost" + request.getPath());
        Assert.assertThat((String)"Valid path", (Object)url.encodedPath(), (Matcher)Is.is((Object)"/api/v1/resources/custom/MyType"));
        Assert.assertThat((String)"Count parameter", (Object)url.queryParameter("count"), (Matcher)Is.is((Object)"true"));
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Result", (Object)((Boolean)response.getBody()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testDeleteOne() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(204));
        VantiqResponse response = this.vantiq.deleteOne("MyType", "12345");
        RecordedRequest request = this.server.takeRequest();
        HttpUrl url = HttpUrl.parse("http://localhost" + request.getPath());
        Assert.assertThat((String)"Valid path", (Object)url.encodedPath(), (Matcher)Is.is((Object)"/api/v1/resources/custom/MyType/12345"));
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Result", (Object)((Boolean)response.getBody()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testPublishTopic() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200));
        JsonObject msg = new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 1).obj();
        VantiqResponse response = this.vantiq.publish(Vantiq.SystemResources.TOPICS.value(), "/foo/bar", msg);
        RecordedRequest request = this.server.takeRequest();
        HttpUrl url = HttpUrl.parse("http://localhost" + request.getPath());
        Assert.assertThat((String)"Valid path", (Object)url.encodedPath(), (Matcher)Is.is((Object)"/api/v1/resources/topics//foo/bar"));
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Result", (Object)((Boolean)response.getBody()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testPublishService() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200));
        JsonObject msg = new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 1).obj();
        VantiqResponse response = this.vantiq.publish(Vantiq.SystemResources.SERVICES.value(), "foo", msg);
        RecordedRequest request = this.server.takeRequest();
        HttpUrl url = HttpUrl.parse("http://localhost" + request.getPath());
        Assert.assertThat((String)"Valid path", (Object)url.encodedPath(), (Matcher)Is.is((Object)"/api/v1/resources/services/foo"));
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Result", (Object)((Boolean)response.getBody()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testPublishSource() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200));
        JsonObject msg = new VantiqTestBase.JsonObjectBuilder(this).addProperty("a", 1).obj();
        VantiqResponse response = this.vantiq.publish(Vantiq.SystemResources.SOURCES.value(), "foo", msg);
        RecordedRequest request = this.server.takeRequest();
        HttpUrl url = HttpUrl.parse("http://localhost" + request.getPath());
        Assert.assertThat((String)"Valid path", (Object)url.encodedPath(), (Matcher)Is.is((Object)"/api/v1/resources/sources/foo"));
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Result", (Object)((Boolean)response.getBody()), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testPreventPublishOnOtherTypes() throws Exception {
        try {
            this.vantiq.publish(Vantiq.SystemResources.TYPES.value(), "MyType", null);
            Assert.fail((String)"Should only allow publish on sources and topics");
        }
        catch (IllegalArgumentException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)Is.is((Object)"Only 'sources', 'services' and 'topics' support publish"));
        }
    }

    @Test
    public void testExecuteProcedure() throws Exception {
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"application/json").setResponseCode(200).setBody(new VantiqTestBase.JsonObjectBuilder(this).addProperty("total", 3).json()));
        JsonObject params = new VantiqTestBase.JsonObjectBuilder(this).addProperty("arg1", 1).addProperty("arg2", 2).obj();
        VantiqResponse response = this.vantiq.execute("adder", params);
        RecordedRequest request = this.server.takeRequest();
        HttpUrl url = HttpUrl.parse("http://localhost" + request.getPath());
        Assert.assertThat((String)"Valid path", (Object)url.encodedPath(), (Matcher)Is.is((Object)"/api/v1/resources/procedures/adder"));
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Valid body", (Object)((JsonObject)response.getBody()).get("total").getAsInt(), (Matcher)Is.is((Object)3));
    }

    @Test
    public void testMissingProcedure() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(404));
        JsonObject params = new VantiqTestBase.JsonObjectBuilder(this).addProperty("arg1", 1).addProperty("arg2", 2).obj();
        VantiqResponse response = this.vantiq.execute("whoops", params);
        RecordedRequest request = this.server.takeRequest();
        HttpUrl url = HttpUrl.parse("http://localhost" + request.getPath());
        Assert.assertThat((String)"Valid path", (Object)url.encodedPath(), (Matcher)Is.is((Object)"/api/v1/resources/procedures/whoops"));
        Assert.assertTrue((String)"Error response", (!response.isSuccess() ? 1 : 0) != 0);
        Assert.assertThat((String)"Missing procedure", (Object)response.getStatusCode(), (Matcher)Is.is((Object)404));
    }

    @Test
    public void testQuerySource() throws Exception {
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"application/json").setResponseCode(200).setBody(new VantiqTestBase.JsonObjectBuilder(this).addProperty("total", 3).json()));
        JsonObject params = new VantiqTestBase.JsonObjectBuilder(this).addProperty("arg1", 1).addProperty("arg2", 2).obj();
        VantiqResponse response = this.vantiq.query("adder", params);
        RecordedRequest request = this.server.takeRequest();
        HttpUrl url = HttpUrl.parse("http://localhost" + request.getPath());
        Assert.assertThat((String)"Valid path", (Object)url.encodedPath(), (Matcher)Is.is((Object)"/api/v1/resources/sources/adder/query"));
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Valid body", (Object)((JsonObject)response.getBody()).get("total").getAsInt(), (Matcher)Is.is((Object)3));
    }

    @Test
    public void testSubscribeServiceEvent() throws Exception {
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"application/json").setResponseCode(200).setBody(new VantiqTestBase.JsonObjectBuilder(this).json()));
        this.vantiq.subscribe(Vantiq.SystemResources.SERVICES.value(), "myService/myEvent", null, null);
    }

    @Test
    public void testUploadInvalidSession() throws Exception {
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"application/json").setResponseCode(401));
        String fileName = "testFile.txt";
        File file = new File(this.getClass().getResource("/" + fileName).getFile());
        VantiqResponse response = this.vantiq.upload(file, "text/plain", fileName);
        Assert.assertTrue((String)"Error response", (!response.isSuccess() ? 1 : 0) != 0);
        Assert.assertThat((String)"Invalid Authentication Status", (Object)response.getStatusCode(), (Matcher)Is.is((Object)401));
    }

    @Test
    public void testUpload() throws Exception {
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"application/json").setResponseCode(200));
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"application/json").setResponseCode(200).setBody(new VantiqTestBase.JsonObjectBuilder(this).addProperty("name", "testFile.txt").addProperty("fileType", "text/plain").addProperty("content", "/docs/assets/someplace/testFile.txt").json()));
        String fileName = "testFile.txt";
        File file = new File(this.getClass().getResource("/" + fileName).getFile());
        VantiqResponse response = this.vantiq.upload(file, "text/plain", fileName);
        RecordedRequest request = this.server.takeRequest();
        HttpUrl url = HttpUrl.parse("http://localhost" + request.getPath());
        Assert.assertThat((String)"Valid path", (Object)url.encodedPath(), (Matcher)Is.is((Object)"/api/v1/_status"));
        Assert.assertThat((String)"Valid method", (Object)request.getMethod(), (Matcher)Is.is((Object)"GET"));
        request = this.server.takeRequest();
        url = HttpUrl.parse("http://localhost" + request.getPath());
        Assert.assertThat((String)"Valid path", (Object)url.encodedPath(), (Matcher)Is.is((Object)"/api/v1/resources/documents"));
        Assert.assertThat((String)"Valid method", (Object)request.getMethod(), (Matcher)Is.is((Object)"POST"));
        String multipartBody = request.getBody().readUtf8();
        String pattern = "Content-Disposition: form-data; name=\"defaultName\"; filename=\"testFile.txt\"";
        Assert.assertThat((String)"Valid multi-part header", (Object)multipartBody, (Matcher)StringContains.containsString((String)pattern));
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Valid body - name", (Object)((JsonObject)response.getBody()).get("name").getAsString(), (Matcher)Is.is((Object)"testFile.txt"));
        Assert.assertThat((String)"Valid body - fileType", (Object)((JsonObject)response.getBody()).get("fileType").getAsString(), (Matcher)Is.is((Object)"text/plain"));
    }

    @Test
    public void testUploadImageInvalidSessionJPG() throws Exception {
        String fileName = "testImage.jpg";
        this.testUploadImageInvalidSessionHelper(fileName, "image/jpeg");
    }

    @Test
    public void testUploadImageInvalidSessionPNG() throws Exception {
        String fileName = "testImage.png";
        this.testUploadImageInvalidSessionHelper(fileName, "image/png");
    }

    public void testUploadImageInvalidSessionHelper(String fileName, String contentType) throws Exception {
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"application/json").setResponseCode(401));
        File file = new File(this.getClass().getResource("/" + fileName).getFile());
        VantiqResponse response = this.vantiq.upload(file, contentType, fileName, "/resources/images");
        Assert.assertTrue((String)"Error response", (!response.isSuccess() ? 1 : 0) != 0);
        Assert.assertThat((String)"Invalid Authentication Status", (Object)response.getStatusCode(), (Matcher)Is.is((Object)401));
    }

    @Test
    public void testUploadImageJPG() throws Exception {
        String fileName = "testImage.jpg";
        this.testUploadImageHelper(fileName, "image/jpeg");
    }

    @Test
    public void testUploadImagePNG() throws Exception {
        String fileName = "testImage.png";
        this.testUploadImageHelper(fileName, "image/png");
    }

    public void testUploadImageHelper(String fileName, String contentType) throws Exception {
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"application/json").setResponseCode(200));
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"application/json").setResponseCode(200).setBody(new VantiqTestBase.JsonObjectBuilder(this).addProperty("name", fileName).addProperty("fileType", contentType).addProperty("content", "/pics/assets/someplace/" + fileName).json()));
        File file = new File(this.getClass().getResource("/" + fileName).getFile());
        VantiqResponse response = this.vantiq.upload(file, contentType, fileName, "/resources/images");
        RecordedRequest request = this.server.takeRequest();
        HttpUrl url = HttpUrl.parse("http://localhost" + request.getPath());
        Assert.assertThat((String)"Valid path", (Object)url.encodedPath(), (Matcher)Is.is((Object)"/api/v1/_status"));
        Assert.assertThat((String)"Valid method", (Object)request.getMethod(), (Matcher)Is.is((Object)"GET"));
        request = this.server.takeRequest();
        url = HttpUrl.parse("http://localhost" + request.getPath());
        Assert.assertThat((String)"Valid path", (Object)url.encodedPath(), (Matcher)Is.is((Object)"/api/v1/resources/images"));
        Assert.assertThat((String)"Valid method", (Object)request.getMethod(), (Matcher)Is.is((Object)"POST"));
        String multipartBody = request.getBody().readUtf8();
        String pattern = "Content-Disposition: form-data; name=\"defaultName\"; filename=\"" + fileName + "\"";
        Assert.assertThat((String)"Valid multi-part header", (Object)multipartBody, (Matcher)StringContains.containsString((String)pattern));
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Valid body - name", (Object)((JsonObject)response.getBody()).get("name").getAsString(), (Matcher)Is.is((Object)fileName));
        Assert.assertThat((String)"Valid body - fileType", (Object)((JsonObject)response.getBody()).get("fileType").getAsString(), (Matcher)Is.is((Object)contentType));
    }

    @Test
    public void testUploadVideoInvalidSession() throws Exception {
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"application/json").setResponseCode(401));
        String fileName = "testVideo.mp4";
        File file = new File(this.getClass().getResource("/" + fileName).getFile());
        VantiqResponse response = this.vantiq.upload(file, "video/mp4", fileName, "/resources/videos");
        Assert.assertTrue((String)"Error response", (!response.isSuccess() ? 1 : 0) != 0);
        Assert.assertThat((String)"Invalid Authentication Status", (Object)response.getStatusCode(), (Matcher)Is.is((Object)401));
    }

    @Test
    public void testUploadVideo() throws Exception {
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"application/json").setResponseCode(200));
        this.server.enqueue(new MockResponse().setHeader("Content-Type", (Object)"application/json").setResponseCode(200).setBody(new VantiqTestBase.JsonObjectBuilder(this).addProperty("name", "testVideo.mp4").addProperty("fileType", "video/mp4").addProperty("content", "/vids/assets/someplace/testVideo.mp4").json()));
        String fileName = "testVideo.mp4";
        File file = new File(this.getClass().getResource("/" + fileName).getFile());
        VantiqResponse response = this.vantiq.upload(file, "video/mp4", fileName, "/resources/videos");
        RecordedRequest request = this.server.takeRequest();
        HttpUrl url = HttpUrl.parse("http://localhost" + request.getPath());
        Assert.assertThat((String)"Valid path", (Object)url.encodedPath(), (Matcher)Is.is((Object)"/api/v1/_status"));
        Assert.assertThat((String)"Valid method", (Object)request.getMethod(), (Matcher)Is.is((Object)"GET"));
        request = this.server.takeRequest();
        url = HttpUrl.parse("http://localhost" + request.getPath());
        Assert.assertThat((String)"Valid path", (Object)url.encodedPath(), (Matcher)Is.is((Object)"/api/v1/resources/videos"));
        Assert.assertThat((String)"Valid method", (Object)request.getMethod(), (Matcher)Is.is((Object)"POST"));
        String multipartBody = request.getBody().readUtf8();
        String pattern = "Content-Disposition: form-data; name=\"defaultName\"; filename=\"testVideo.mp4\"";
        Assert.assertThat((String)"Valid multi-part header", (Object)multipartBody, (Matcher)StringContains.containsString((String)pattern));
        Assert.assertTrue((String)"Successful response", (boolean)response.isSuccess());
        Assert.assertThat((String)"Valid body - name", (Object)((JsonObject)response.getBody()).get("name").getAsString(), (Matcher)Is.is((Object)"testVideo.mp4"));
        Assert.assertThat((String)"Valid body - fileType", (Object)((JsonObject)response.getBody()).get("fileType").getAsString(), (Matcher)Is.is((Object)"video/mp4"));
    }
}

