/*
 * Decompiled with CFR 0.152.
 */
package io.vantiq.client;

import io.vantiq.client.ResponseHandler;
import io.vantiq.client.Vantiq;
import io.vantiq.client.VantiqTestBase;
import java.io.File;
import okhttp3.mockwebserver.MockResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VantiqConnectAuthTest
extends VantiqTestBase {
    private Vantiq vantiq;

    @Before
    public void setUpVantiq() {
        this.vantiq = new Vantiq(this.server.url("/").toString());
    }

    @After
    public void tearDownVantiq() {
        this.vantiq = null;
    }

    @Test
    public void testAuthenticate() throws Exception {
        this.server.enqueue(new MockResponse().setResponseCode(200).setHeader("Content-Type", (Object)"application/json").setBody(new VantiqTestBase.JsonObjectBuilder().addProperty("accessToken", "abc123").json()));
        this.vantiq.authenticate("joe", "no-one-will-guess", this.handler);
        this.waitForCompletion();
        Assert.assertTrue((String)"Successful response", (boolean)this.handler.success);
        Assert.assertTrue((String)"Session authenticated", (boolean)this.vantiq.isAuthenticated());
        Assert.assertThat((String)"Result", (Object)this.handler.getBodyAsBoolean(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testUnauthorizedSelect() throws Exception {
        try {
            this.vantiq.select("TestType", null, null, null, this.handler);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }

    @Test
    public void testUnauthorizedSelectOne() throws Exception {
        try {
            this.vantiq.selectOne("TestType", "abc123", this.handler);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }

    @Test
    public void testUnauthorizedCount() throws Exception {
        try {
            this.vantiq.count("TestType", null, this.handler);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }

    @Test
    public void testUnauthorizedInsert() throws Exception {
        try {
            this.vantiq.insert("TestType", null, this.handler);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }

    @Test
    public void testUnauthorizedUpdate() throws Exception {
        try {
            this.vantiq.update("TestType", null, null, this.handler);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }

    @Test
    public void testUnauthorizedUpsert() throws Exception {
        try {
            this.vantiq.upsert("TestType", null, this.handler);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }

    @Test
    public void testUnauthorizedDelete() throws Exception {
        try {
            this.vantiq.delete("TestType", null, this.handler);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }

    @Test
    public void testUnauthorizedDeleteOne() throws Exception {
        try {
            this.vantiq.deleteOne("TestType", null, this.handler);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }

    @Test
    public void testUnauthorizedPublish() throws Exception {
        try {
            this.vantiq.publish("topics", "/test/topic", null, this.handler);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }

    @Test
    public void testUnauthorizedExecute() throws Exception {
        try {
            this.vantiq.execute("testProcedure", null, this.handler);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }

    @Test
    public void testUnauthorizedQuery() throws Exception {
        try {
            this.vantiq.query("testSource", null, this.handler);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }

    @Test
    public void testUnauthorizedSubscribe() throws Exception {
        try {
            this.vantiq.subscribe("topics", "/test/topic", null, null);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }

    @Test
    public void testUnauthorizedUpload() throws Exception {
        try {
            ResponseHandler nullResponseHandler = null;
            this.vantiq.upload(new File("/foo/bar/file.txt"), "text/plain", "file.txt", nullResponseHandler);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }

    @Test
    public void testUnauthorizedUploadImage() throws Exception {
        try {
            this.vantiq.upload(new File("/foo/bar/file.jpg"), "image/jpeg", "file.jpg", "/resources/images", null);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }

    @Test
    public void testUnauthorizedUploadVideo() throws Exception {
        try {
            this.vantiq.upload(new File("/foo/bar/file.mp4"), "video/mp4", "file.mp4", "/resources/videos", null);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }

    @Test
    public void testUnauthorizedDownload() throws Exception {
        try {
            this.vantiq.download("file.txt", null);
            Assert.fail((String)"Should not allow unauthenticated requests");
        }
        catch (IllegalStateException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.is((Object)"Not authenticated"));
        }
    }
}

