/*
 * Decompiled with CFR 0.152.
 */
package io.vantiq.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.vantiq.client.ResponseHandler;
import io.vantiq.client.SortSpec;
import io.vantiq.client.SubscriptionCallback;
import io.vantiq.client.VantiqError;
import io.vantiq.client.VantiqResponse;
import io.vantiq.client.internal.VantiqSession;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Authenticator;
import okhttp3.Response;

public class Vantiq {
    private static Gson gson = new Gson();
    private VantiqSession session;
    private boolean enablePings = true;

    public Vantiq(String server, int apiVersion) {
        this.session = new VantiqSession(server, apiVersion);
    }

    public Vantiq(String server, int apiVersion, Authenticator proxyAuthenticator) {
        this.session = new VantiqSession(server, apiVersion, proxyAuthenticator);
    }

    public Vantiq(String server) {
        this.session = new VantiqSession(server);
    }

    public Vantiq(String server, Authenticator proxyAuthenticator) {
        this.session = new VantiqSession(server, proxyAuthenticator);
    }

    public boolean isAuthenticated() {
        return this.session.isAuthenticated();
    }

    public String getServer() {
        return this.session.getServer();
    }

    public void setServer(String server) {
        this.session.setServer(server);
    }

    public String getUsername() {
        return this.session.getUsername();
    }

    public void setUsername(String username) {
        this.session.setUsername(username);
    }

    public boolean isEnablePings() {
        return this.enablePings;
    }

    public void setEnablePings(boolean enablePings) {
        this.enablePings = enablePings;
    }

    public void authenticate(String username, String password, ResponseHandler responseHandler) {
        this.session.authenticate(username, password, new PassThruResponseHandler(responseHandler){

            @Override
            public void onSuccess(Object body, Response response) {
                this.delegate.onSuccess(true, response);
            }
        });
    }

    public VantiqResponse authenticate(String username, String password) {
        VantiqResponse response = this.session.authenticate(username, password, null);
        if (response != null) {
            response.setBody(response.isSuccess());
        }
        return response;
    }

    public void revoke(String accessToken, ResponseHandler responseHandler) {
        this.session.revoke(accessToken, new PassThruResponseHandler(responseHandler){

            @Override
            public void onSuccess(Object body, Response response) {
                this.delegate.onSuccess(true, response);
            }
        });
    }

    public VantiqResponse revoke(String accessToken) {
        VantiqResponse response = this.session.revoke(accessToken, null);
        if (response != null) {
            response.setBody(response.isSuccess());
        }
        return response;
    }

    public void refresh(String accessToken, ResponseHandler responseHandler) {
        this.session.refresh(accessToken, new PassThruResponseHandler(responseHandler){

            @Override
            public void onSuccess(Object body, Response response) {
                this.delegate.onSuccess(true, response);
            }
        });
    }

    public VantiqResponse refresh(String accessToken) {
        VantiqResponse response = this.session.refresh(accessToken, null);
        if (response != null) {
            response.setBody(response.isSuccess());
        }
        return response;
    }

    public String buildPath(String qualifiedName, String id) {
        String path;
        if (qualifiedName.startsWith("system.")) {
            String systemResourceName = qualifiedName.substring(7);
            path = "/resources/" + systemResourceName;
        } else {
            path = "/resources/custom/" + qualifiedName;
        }
        if (id != null) {
            path = path + "/" + id;
        }
        return path;
    }

    public void select(String resource, List<String> propSpecs, Object where, SortSpec sortSpec, ResponseHandler responseHandler) {
        String path = this.buildPath(resource, null);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (propSpecs != null) {
            queryParams.put("props", VantiqSession.gson.toJson(propSpecs));
        }
        if (where != null) {
            queryParams.put("where", VantiqSession.gson.toJson(where));
        }
        if (sortSpec != null) {
            queryParams.put("sort", VantiqSession.gson.toJson(sortSpec.serialize()));
        }
        this.session.get(path, queryParams, new PassThruResponseHandler(responseHandler){

            @Override
            public void onSuccess(Object body, Response response) {
                if (body instanceof JsonArray) {
                    JsonArray arr = (JsonArray)body;
                    ArrayList<JsonObject> resultBody = new ArrayList<JsonObject>();
                    for (int i = 0; i < arr.size(); ++i) {
                        resultBody.add((JsonObject)arr.get(i));
                    }
                    this.delegate.onSuccess(resultBody, response);
                }
            }
        });
    }

    public void batch(JsonArray requests, ResponseHandler responseHandler) {
        String path = "/batch";
        HashMap<String, String> queryParams = new HashMap<String, String>();
        for (int i = 0; i < requests.size(); ++i) {
            JsonObject jo = (JsonObject)requests.get(i);
            JsonObject headers = (JsonObject)jo.get("headers");
            headers.addProperty("Authorization", "Bearer " + this.getAccessToken());
        }
        String body = requests.toString();
        this.session.post(path, queryParams, body, new PassThruResponseHandler(responseHandler){

            @Override
            public void onSuccess(Object body, Response response) {
                if (body instanceof JsonArray) {
                    JsonArray arr = (JsonArray)body;
                    ArrayList<JsonObject> resultBody = new ArrayList<JsonObject>();
                    for (int i = 0; i < arr.size(); ++i) {
                        resultBody.add((JsonObject)arr.get(i));
                    }
                    this.delegate.onSuccess(resultBody, response);
                }
            }
        });
    }

    public VantiqResponse batch(JsonArray requests) {
        String path = "/batch";
        HashMap<String, String> queryParams = new HashMap<String, String>();
        for (int i = 0; i < requests.size(); ++i) {
            JsonObject jo = (JsonObject)requests.get(i);
            JsonObject headers = (JsonObject)jo.get("headers");
            headers.addProperty("Authorization", "Bearer " + this.getAccessToken());
        }
        String body = requests.toString();
        VantiqResponse response = this.session.post(path, queryParams, body, null);
        if (response != null && response.getBody() instanceof JsonArray) {
            JsonArray arr = (JsonArray)response.getBody();
            ArrayList<JsonObject> resultBody = new ArrayList<JsonObject>();
            for (int i = 0; i < arr.size(); ++i) {
                resultBody.add((JsonObject)arr.get(i));
            }
            response.setBody(resultBody);
        }
        return response;
    }

    public VantiqResponse select(String resource, List<String> propSpecs, Object where, SortSpec sortSpec) {
        return this.select(resource, propSpecs, where, sortSpec, 0L, null);
    }

    public VantiqResponse select(String resource, List<String> propSpecs, Object where, SortSpec sortSpec, long limit) {
        return this.select(resource, propSpecs, where, sortSpec, limit, null);
    }

    public VantiqResponse select(String resource, List<String> propSpecs, Object where, SortSpec sortSpec, long limit, Map<String, String> options) {
        VantiqResponse response;
        String path = this.buildPath(resource, null);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (propSpecs != null) {
            queryParams.put("props", VantiqSession.gson.toJson(propSpecs));
        }
        if (where != null) {
            queryParams.put("where", VantiqSession.gson.toJson(where));
        }
        if (options != null) {
            queryParams.putAll(options);
        }
        if (sortSpec != null) {
            queryParams.put("sort", VantiqSession.gson.toJson(sortSpec.serialize()));
        }
        if (limit > 0L) {
            queryParams.put("limit", Long.toString(limit));
            queryParams.put("count", "true");
        }
        if ((response = this.session.get(path, queryParams, null)) != null && response.getBody() instanceof JsonArray) {
            JsonArray arr = (JsonArray)response.getBody();
            ArrayList<JsonObject> resultBody = new ArrayList<JsonObject>();
            for (int i = 0; i < arr.size(); ++i) {
                resultBody.add((JsonObject)arr.get(i));
            }
            response.setBody(resultBody);
        }
        return response;
    }

    public void selectOne(String resource, String id, ResponseHandler responseHandler) {
        String path = this.buildPath(resource, id);
        this.session.get(path, null, responseHandler);
    }

    public VantiqResponse selectOne(String resource, String id) {
        String path = this.buildPath(resource, id);
        return this.session.get(path, null, null);
    }

    public void count(String resource, Object where, ResponseHandler responseHandler) {
        String path = this.buildPath(resource, null);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("count", "true");
        queryParams.put("props", VantiqSession.gson.toJson(Collections.singletonList("_id")));
        if (where != null) {
            queryParams.put("where", VantiqSession.gson.toJson(where));
        }
        this.session.get(path, queryParams, new PassThruResponseHandler(responseHandler){

            @Override
            public void onSuccess(Object body, Response response) {
                String cntValue = response.header("X-Total-Count");
                try {
                    if (cntValue != null) {
                        this.delegate.onSuccess(Integer.parseInt(cntValue), response);
                    } else {
                        this.delegate.onSuccess(0, response);
                    }
                }
                catch (NumberFormatException ex) {
                    this.delegate.onFailure(ex);
                }
            }
        });
    }

    public VantiqResponse count(String resource, Object where) {
        VantiqResponse response;
        String path = this.buildPath(resource, null);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("count", "true");
        queryParams.put("props", VantiqSession.gson.toJson(Collections.singletonList("_id")));
        if (where != null) {
            queryParams.put("where", VantiqSession.gson.toJson(where));
        }
        if ((response = this.session.get(path, queryParams, null)) != null) {
            response.setBody(response.getCount());
        }
        return response;
    }

    public void rawGet(String fullPath, Map<String, String> queryParams, Map<String, String> extraHeaders, ResponseHandler responseHandler) {
        this.session.rawGet(fullPath, queryParams, extraHeaders, responseHandler);
    }

    public VantiqResponse rawGet(String fullPath, Map<String, String> queryParams, Map<String, String> extraHeaders) {
        return this.session.rawGet(fullPath, queryParams, extraHeaders, null);
    }

    public void post(String path, Object object, ResponseHandler responseHandler) {
        this.session.post(path, null, VantiqSession.gson.toJson(object), responseHandler);
    }

    public VantiqResponse post(String path, Object object) {
        return this.session.post(path, null, VantiqSession.gson.toJson(object), null);
    }

    public void put(String path, Object object, ResponseHandler responseHandler) {
        this.session.put(path, null, VantiqSession.gson.toJson(object), responseHandler);
    }

    public VantiqResponse put(String path, Object object) {
        return this.session.put(path, null, VantiqSession.gson.toJson(object), null);
    }

    public void del(String path, ResponseHandler responseHandler) {
        this.session.delete(path, null, new PassThruResponseHandler(responseHandler){

            @Override
            public void onSuccess(Object body, Response response) {
                this.delegate.onSuccess(true, response);
            }
        });
    }

    public VantiqResponse del(String path) {
        VantiqResponse response = this.session.delete(path, null, null);
        if (response != null && response.isSuccess()) {
            response.setBody(true);
        }
        return response;
    }

    public void insert(String resource, Object object, ResponseHandler responseHandler) {
        String path = this.buildPath(resource, null);
        this.session.post(path, null, VantiqSession.gson.toJson(object), responseHandler);
    }

    public VantiqResponse insert(String resource, Object object) {
        String path = this.buildPath(resource, null);
        return this.session.post(path, null, VantiqSession.gson.toJson(object), null);
    }

    public void update(String resource, String id, Object object, ResponseHandler responseHandler) {
        String path = this.buildPath(resource, id);
        this.session.put(path, null, VantiqSession.gson.toJson(object), responseHandler);
    }

    public VantiqResponse update(String resource, String id, Object object) {
        String path = this.buildPath(resource, id);
        return this.session.put(path, null, VantiqSession.gson.toJson(object), null);
    }

    public void upsert(String resource, Object object, ResponseHandler responseHandler) {
        JsonObject jsonObj;
        String path = this.buildPath(resource, null);
        if (object instanceof JsonObject && (jsonObj = (JsonObject)object).has("_id")) {
            jsonObj.remove("_id");
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("upsert", "true");
        this.session.post(path, queryParams, VantiqSession.gson.toJson(object), responseHandler);
    }

    public VantiqResponse upsert(String resource, Object object) {
        JsonObject jsonObj;
        String path = this.buildPath(resource, null);
        if (object instanceof JsonObject && (jsonObj = (JsonObject)object).has("_id")) {
            jsonObj.remove("_id");
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("upsert", "true");
        return this.session.post(path, queryParams, VantiqSession.gson.toJson(object), null);
    }

    public void delete(String resource, Object where, ResponseHandler responseHandler) {
        String path = this.buildPath(resource, null);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("count", "true");
        if (where != null) {
            queryParams.put("where", VantiqSession.gson.toJson(where));
        }
        this.session.delete(path, queryParams, new PassThruResponseHandler(responseHandler){

            @Override
            public void onSuccess(Object body, Response response) {
                this.delegate.onSuccess(true, response);
            }
        });
    }

    public VantiqResponse delete(String resource, Object where) {
        VantiqResponse response;
        String path = this.buildPath(resource, null);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("count", "true");
        if (where != null) {
            queryParams.put("where", VantiqSession.gson.toJson(where));
        }
        if ((response = this.session.delete(path, queryParams, null)) != null && response.isSuccess()) {
            response.setBody(true);
        }
        return response;
    }

    public void deleteOne(String resource, String id, ResponseHandler responseHandler) {
        String path = this.buildPath(resource, id);
        this.session.delete(path, null, new PassThruResponseHandler(responseHandler){

            @Override
            public void onSuccess(Object body, Response response) {
                this.delegate.onSuccess(true, response);
            }
        });
    }

    public VantiqResponse deleteOne(String resource, String id) {
        String path = this.buildPath(resource, id);
        VantiqResponse response = this.session.delete(path, null, null);
        if (response != null && response.isSuccess()) {
            response.setBody(true);
        }
        return response;
    }

    public void publish(String resource, String id, Object payload, ResponseHandler responseHandler) {
        if (!(SystemResources.SOURCES.value().equals(resource) || SystemResources.TOPICS.value().equals(resource) || SystemResources.SERVICES.value().equals(resource))) {
            throw new IllegalArgumentException("Only 'sources', 'services' and 'topics' support publish");
        }
        String path = "/resources/" + resource + "/" + id;
        this.session.post(path, null, VantiqSession.gson.toJson(payload), new PassThruResponseHandler(responseHandler){

            @Override
            public void onSuccess(Object body, Response response) {
                this.delegate.onSuccess(true, response);
            }
        });
    }

    public VantiqResponse publish(String resource, String id, Object payload) {
        if (!(SystemResources.SOURCES.value().equals(resource) || SystemResources.TOPICS.value().equals(resource) || SystemResources.SERVICES.value().equals(resource))) {
            throw new IllegalArgumentException("Only 'sources', 'services' and 'topics' support publish");
        }
        String path = "/resources/" + resource + "/" + id;
        VantiqResponse response = this.session.post(path, null, VantiqSession.gson.toJson(payload), null);
        if (response != null && response.isSuccess()) {
            response.setBody(true);
        }
        return response;
    }

    public void execute(String procedure, Object params, ResponseHandler responseHandler) {
        String path = "/resources/" + SystemResources.PROCEDURES.value() + "/" + procedure;
        this.session.post(path, null, VantiqSession.gson.toJson(params), responseHandler);
    }

    public VantiqResponse execute(String procedure, Object params) {
        String path = "/resources/" + SystemResources.PROCEDURES.value() + "/" + procedure;
        return this.session.post(path, null, VantiqSession.gson.toJson(params), null);
    }

    public void query(String source2, Object params, ResponseHandler responseHandler) {
        String path = "/resources/sources/" + source2 + "/query";
        this.session.post(path, null, VantiqSession.gson.toJson(params), responseHandler);
    }

    public VantiqResponse query(String source2, Object params) {
        String path = "/resources/sources/" + source2 + "/query";
        return this.session.post(path, null, VantiqSession.gson.toJson(params), null);
    }

    public void getNamespaceUsers(String namespace, ResponseHandler responseHandler) {
        String path = "/resources/namespaces/" + namespace + "/authorizedUsers";
        this.session.get(path, null, responseHandler);
    }

    public VantiqResponse getNamespaceUsers(String namespace) {
        String path = "/resources/namespaces/" + namespace + "/authorizedUsers";
        return this.session.get(path, null, null);
    }

    public void upload(final File file, final String contentType, final String documentPath, final ResponseHandler responseHandler) {
        this.session.get("_status", null, new ResponseHandler(){

            @Override
            public void onSuccess(Object body, Response response) {
                String path = "/resources/" + SystemResources.DOCUMENTS.value();
                Vantiq.this.session.upload(path, file, contentType, documentPath, null, responseHandler);
            }

            @Override
            public void onError(List<VantiqError> errors, Response response) {
                responseHandler.onError(errors, response);
            }

            @Override
            public void onFailure(Throwable t2) {
                responseHandler.onFailure(t2);
            }
        });
    }

    public VantiqResponse upload(File file, String contentType, String documentPath) {
        VantiqResponse response = this.session.get("_status", null, null);
        if (response.getStatusCode() != 200) {
            return response;
        }
        String path = "/resources/" + SystemResources.DOCUMENTS.value();
        return this.session.upload(path, file, contentType, documentPath, null, null);
    }

    public void upload(final File file, final String contentType, final String filePath, final String resourcePath, final ResponseHandler responseHandler) {
        this.session.get("_status", null, new ResponseHandler(){

            @Override
            public void onSuccess(Object body, Response response) {
                Vantiq.this.session.upload(resourcePath, file, contentType, filePath, null, responseHandler);
            }

            @Override
            public void onError(List<VantiqError> errors, Response response) {
                responseHandler.onError(errors, response);
            }

            @Override
            public void onFailure(Throwable t2) {
                responseHandler.onFailure(t2);
            }
        });
    }

    public VantiqResponse upload(File file, String contentType, String filePath, String resourcePath) {
        VantiqResponse response = this.session.get("_status", null, null);
        if (response.getStatusCode() != 200) {
            return response;
        }
        return this.session.upload(resourcePath, file, contentType, filePath, null, null);
    }

    public VantiqResponse download(String path) {
        return this.session.download(path, null);
    }

    public void download(String path, ResponseHandler responseHandler) {
        this.session.download(path, responseHandler);
    }

    public void subscribe(String resource, String id, TypeOperation operation, SubscriptionCallback callback, Map<String, Object> parameters) {
        String path = SystemResources.TOPICS.value().equals(resource) ? "/" + resource + id : "/" + resource + "/" + id;
        if (SystemResources.SOURCES.value().equals(resource) || SystemResources.SERVICES.value().equals(resource) || SystemResources.TOPICS.value().equals(resource)) {
            if (operation != null) {
                throw new IllegalArgumentException("Operation only support for 'types'");
            }
        } else if (SystemResources.TYPES.value().equals(resource)) {
            if (operation == null) {
                throw new IllegalArgumentException("Operation required for 'types'");
            }
            path = path + "/" + operation.toString().toLowerCase();
        } else {
            throw new IllegalArgumentException("Only 'topics', 'sources' and 'types' support subscribe");
        }
        this.session.subscribe(path, callback, this.enablePings, parameters);
    }

    public void subscribe(String resource, String id, TypeOperation operation, SubscriptionCallback callback) {
        this.subscribe(resource, id, operation, callback, null);
    }

    public void ack(String subscriptionId, String requestId, Map msg) throws IOException {
        Double sequenceId = (double)((Double)msg.get("sequenceId"));
        Double partitionId = (double)((Double)msg.get("partitionId"));
        this.session.ack(requestId, subscriptionId, sequenceId, partitionId);
    }

    public void unsubscribeAll() {
        this.session.unsubscribeAll();
    }

    public void closeWebsocket() {
        this.session.close();
    }

    public void setAccessToken(String accessToken) {
        this.session.setAccessToken(accessToken);
    }

    public String getAccessToken() {
        return this.session.getAccessToken();
    }

    public void setTargetNamespace(String targetNamespace) {
        this.session.setTargetNamespace(targetNamespace);
    }

    public String getTargetNamespace() {
        return this.session.getTargetNamespace();
    }

    public String getIdToken() {
        return this.session.getIdToken();
    }

    public void setReadTimeout(long timeout2) {
        this.session.setReadTimeout(timeout2);
    }

    public long getReadTimeout() {
        return this.session.getReadTimeout();
    }

    public void setWriteTimeout(long timeout2) {
        this.session.setWriteTimeout(timeout2);
    }

    public long getWriteTimeout() {
        return this.session.getWriteTimeout();
    }

    public void setConnectTimeout(long timeout2) {
        this.session.setConnectTimeout(timeout2);
    }

    public long getConnectTimeout() {
        return this.session.getConnectTimeout();
    }

    public static enum SystemResources {
        ANALYTICS_MODELS("analyticsmodels"),
        DOCUMENTS("documents"),
        CONFIGURATIONS("configurations"),
        NAMESPACES("namespaces"),
        NODES("nodes"),
        PROCEDURES("procedures"),
        PROFILES("profiles"),
        RULES("rules"),
        SCALARS("scalars"),
        SERVICES("services"),
        SOURCES("sources"),
        TOPICS("topics"),
        TYPES("types"),
        USERS("users"),
        IMAGES("images"),
        VIDEOS("videos");

        private String value;

        private SystemResources(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static enum TypeOperation {
        INSERT,
        UPDATE,
        DELETE;

    }

    class PassThruResponseHandler
    implements ResponseHandler {
        protected ResponseHandler delegate;

        public PassThruResponseHandler(ResponseHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onSuccess(Object body, Response response) {
            this.delegate.onSuccess(body, response);
        }

        @Override
        public void onError(List<VantiqError> errors, Response response) {
            this.delegate.onError(errors, response);
        }

        @Override
        public void onFailure(Throwable t2) {
            this.delegate.onFailure(t2);
        }
    }
}

