/*
 * Decompiled with CFR 0.152.
 */
package io.vantiq.client;

import io.vantiq.client.SubscriptionCallback;
import io.vantiq.client.SubscriptionMessage;

public class UnitTestSubscriptionCallback
implements SubscriptionCallback {
    private boolean connected = false;
    private SubscriptionMessage message;
    private Throwable cause;
    private String error;
    private boolean fired = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnect() {
        this.fired = true;
        this.connected = true;
        UnitTestSubscriptionCallback unitTestSubscriptionCallback = this;
        synchronized (unitTestSubscriptionCallback) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(SubscriptionMessage message) {
        this.fired = true;
        this.message = message;
        UnitTestSubscriptionCallback unitTestSubscriptionCallback = this;
        synchronized (unitTestSubscriptionCallback) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(String error) {
        this.fired = true;
        this.error = error;
        UnitTestSubscriptionCallback unitTestSubscriptionCallback = this;
        synchronized (unitTestSubscriptionCallback) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(Throwable t2) {
        this.fired = true;
        this.cause = t2;
        UnitTestSubscriptionCallback unitTestSubscriptionCallback = this;
        synchronized (unitTestSubscriptionCallback) {
            this.notify();
        }
    }

    public SubscriptionMessage getMessage() {
        return this.message;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String getError() {
        return this.error;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void waitForCompletion(int timeout2) throws InterruptedException {
        if (!this.fired) {
            this.wait(timeout2);
        }
    }

    public synchronized void waitForConnection(int timeout2) throws InterruptedException {
        long limitTime;
        long now = limitTime = System.currentTimeMillis() + (long)timeout2;
        while (!this.connected && now <= limitTime) {
            this.wait(timeout2);
            now = System.currentTimeMillis();
        }
    }

    public synchronized void waitForConnection() throws InterruptedException {
        this.waitForConnection(2000);
    }

    public synchronized void waitForCompletion() throws InterruptedException {
        this.waitForCompletion(2000);
    }

    public void reset() {
        this.message = null;
        this.cause = null;
        this.error = null;
        this.connected = false;
        this.fired = false;
    }

    public boolean hasFired() {
        return this.fired;
    }

    public String toString() {
        if (this.message != null) {
            return "Message: " + this.message.toString();
        }
        if (this.error != null) {
            return "Error: " + this.error;
        }
        if (this.cause != null) {
            return "Failure: " + this.cause.toString();
        }
        if (this.connected) {
            return "Connected";
        }
        return "Callback not called";
    }
}

