/*
 * Decompiled with CFR 0.152.
 */
package io.vantiq.client;

import io.vantiq.client.BaseResponseHandler;
import io.vantiq.client.VantiqError;
import java.util.List;
import okhttp3.Response;

public class UnitTestResponseHandler
extends BaseResponseHandler {
    public boolean success = false;
    public boolean error = false;
    public boolean failure = false;

    public UnitTestResponseHandler reset() {
        this.success = false;
        this.error = false;
        this.failure = false;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(Object body, Response response) {
        super.onSuccess(body, response);
        this.success = true;
        UnitTestResponseHandler unitTestResponseHandler = this;
        synchronized (unitTestResponseHandler) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(List<VantiqError> errors, Response response) {
        super.onError(errors, response);
        this.error = true;
        UnitTestResponseHandler unitTestResponseHandler = this;
        synchronized (unitTestResponseHandler) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(Throwable t2) {
        super.onFailure(t2);
        this.failure = true;
        UnitTestResponseHandler unitTestResponseHandler = this;
        synchronized (unitTestResponseHandler) {
            this.notify();
        }
    }

    public String toString() {
        if (this.success) {
            return "SUCCESS: " + this.getBody();
        }
        if (this.error) {
            return "ERROR: [" + this.getStatusCode() + "]: " + this.getErrors();
        }
        if (this.failure) {
            return "FAILURE: " + this.getException();
        }
        return "UNKNOWN STATE";
    }
}

