/*
 * Decompiled with CFR 0.152.
 */
package io.vantiq.client;

import com.google.gson.JsonObject;
import io.vantiq.client.ResponseHandler;
import io.vantiq.client.VantiqError;
import io.vantiq.client.VantiqResponse;
import java.util.List;
import okhttp3.Response;

public class BaseResponseHandler
implements ResponseHandler {
    private VantiqResponse response;

    @Override
    public void onSuccess(Object body, Response response) {
        try {
            this.response = new VantiqResponse(body, response);
        }
        finally {
            this.completionHook(true);
        }
    }

    @Override
    public void onError(List<VantiqError> errors, Response response) {
        try {
            this.response = new VantiqResponse(errors, response);
        }
        finally {
            this.completionHook(false);
        }
    }

    @Override
    public void onFailure(Throwable exception) {
        try {
            this.response = new VantiqResponse(exception);
        }
        finally {
            this.completionHook(false);
        }
    }

    public VantiqResponse getResponse() {
        return this.response;
    }

    public void completionHook(boolean success) {
    }

    public boolean hasErrors() {
        return this.response != null && this.response.hasErrors();
    }

    public boolean hasException() {
        return this.response != null && this.response.hasException();
    }

    public Throwable getException() {
        return this.response != null ? this.response.getException() : null;
    }

    public List<VantiqError> getErrors() {
        return this.response != null ? this.response.getErrors() : null;
    }

    public int getCount() {
        return this.response != null ? this.response.getCount() : -1;
    }

    public String getContentType() {
        return this.response != null ? this.response.getContentType() : null;
    }

    public int getStatusCode() {
        return this.response != null ? this.response.getStatusCode() : -1;
    }

    public Object getBody() {
        return this.response != null ? this.response.getBody() : null;
    }

    public JsonObject getBodyAsJsonObject() {
        Object body = this.getBody();
        return body instanceof JsonObject ? (JsonObject)body : null;
    }

    public List<JsonObject> getBodyAsList() {
        Object body = this.getBody();
        return body instanceof List ? (List)body : null;
    }

    public String getBodyAsString() {
        Object body = this.getBody();
        return body instanceof String ? (String)body : null;
    }

    public int getBodyAsInt() {
        Object body = this.getBody();
        return body instanceof Integer ? (Integer)body : 0;
    }

    public boolean getBodyAsBoolean() {
        Object body = this.getBody();
        return body instanceof Boolean ? (Boolean)body : false;
    }
}

