/*
 * Decompiled with CFR 0.152.
 */
package io.typst.command.algebra;

import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;

public interface Either<L, R> {
    default public Optional<R> toJavaOptional() {
        return this instanceof Right ? Optional.of(((Right)this).getRight()) : Optional.empty();
    }

    public static <A> Either<Throwable, A> catching(Supplier<A> f) {
        try {
            return new Right(f.get());
        }
        catch (Throwable ex) {
            return new Left(ex);
        }
    }

    public static final class Right<L, R>
    implements Either<L, R> {
        private final R right;

        @Generated
        public Right(R right) {
            this.right = right;
        }

        @Generated
        public R getRight() {
            return this.right;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Right)) {
                return false;
            }
            Right other = (Right)o;
            R this$right = this.getRight();
            R other$right = other.getRight();
            return !(this$right == null ? other$right != null : !this$right.equals(other$right));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            R $right = this.getRight();
            result = result * 59 + ($right == null ? 43 : $right.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Either.Right(right=" + this.getRight() + ")";
        }
    }

    public static final class Left<L, R>
    implements Either<L, R> {
        private final L left;

        @Generated
        public Left(L left) {
            this.left = left;
        }

        @Generated
        public L getLeft() {
            return this.left;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Left)) {
                return false;
            }
            Left other = (Left)o;
            L this$left = this.getLeft();
            L other$left = other.getLeft();
            return !(this$left == null ? other$left != null : !this$left.equals(other$left));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            L $left = this.getLeft();
            result = result * 59 + ($left == null ? 43 : $left.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Either.Left(left=" + this.getLeft() + ")";
        }
    }
}

