/*
 * Decompiled with CFR 0.152.
 */
package io.typst.command;

import io.typst.command.ParseContext;
import io.typst.command.algebra.Tuple2;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;

public final class Argument<A> {
    private final String name;
    private final Class<?> classType;
    private final Function<List<String>, Tuple2<Optional<A>, List<String>>> parser;
    private final Function<ParseContext, List<String>> contextualTabCompleter;

    public static <A> Argument<A> ofUnary(String name, Class<?> classType, Function<String, Optional<A>> parser, Supplier<List<String>> tabCompleter) {
        return Argument.of(name, classType, args -> {
            LinkedList newArgs = new LinkedList(args);
            String arg = newArgs.size() >= 1 ? (String)newArgs.remove(0) : "";
            return new Tuple2(arg.length() >= 1 ? (Optional)parser.apply(arg) : Optional.empty(), newArgs);
        }, tabCompleter);
    }

    public static <A> Argument<A> of(String name, Class<?> classType, Function<List<String>, Tuple2<Optional<A>, List<String>>> parser, Supplier<List<String>> tabCompletes) {
        return new Argument<A>(name, classType, parser, ctx -> (List)tabCompletes.get());
    }

    public Argument<A> withTabCompletes(Supplier<List<String>> f) {
        return this.withContextualTabCompleter(ctx -> (List)f.get());
    }

    public Argument<Optional<A>> asOptional() {
        return new Argument<Optional<A>>(this.name, this.classType, args -> {
            Tuple2<Optional<Optional>, List<String>> ret = this.getParser().apply((List<String>)args);
            return args.isEmpty() ? ret.map1(Optional::of) : ret.map1(aO -> aO.map(Optional::of));
        }, this.getContextualTabCompleter());
    }

    public <B> Argument<B> map(Function<A, B> f) {
        return new Argument<A>(this.name, this.classType, args -> {
            Tuple2<Optional<Optional>, List<String>> pair = this.getParser().apply((List<String>)args);
            return pair.map1(a -> a.map(f));
        }, this.getContextualTabCompleter());
    }

    @Generated
    private Argument(String name, Class<?> classType, Function<List<String>, Tuple2<Optional<A>, List<String>>> parser, Function<ParseContext, List<String>> contextualTabCompleter) {
        this.name = name;
        this.classType = classType;
        this.parser = parser;
        this.contextualTabCompleter = contextualTabCompleter;
    }

    @Generated
    public static <A> Argument<A> ofContext(String name, Class<?> classType, Function<List<String>, Tuple2<Optional<A>, List<String>>> parser, Function<ParseContext, List<String>> contextualTabCompleter) {
        return new Argument<A>(name, classType, parser, contextualTabCompleter);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Class<?> getClassType() {
        return this.classType;
    }

    @Generated
    public Function<List<String>, Tuple2<Optional<A>, List<String>>> getParser() {
        return this.parser;
    }

    @Generated
    public Function<ParseContext, List<String>> getContextualTabCompleter() {
        return this.contextualTabCompleter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Argument)) {
            return false;
        }
        Argument other = (Argument)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Class<?> this$classType = this.getClassType();
        Class<?> other$classType = other.getClassType();
        if (this$classType == null ? other$classType != null : !this$classType.equals(other$classType)) {
            return false;
        }
        Function<List<String>, Tuple2<Optional<A>, List<String>>> this$parser = this.getParser();
        Function<List<String>, Tuple2<Optional<A>, List<String>>> other$parser = other.getParser();
        if (this$parser == null ? other$parser != null : !this$parser.equals(other$parser)) {
            return false;
        }
        Function<ParseContext, List<String>> this$contextualTabCompleter = this.getContextualTabCompleter();
        Function<ParseContext, List<String>> other$contextualTabCompleter = other.getContextualTabCompleter();
        return !(this$contextualTabCompleter == null ? other$contextualTabCompleter != null : !this$contextualTabCompleter.equals(other$contextualTabCompleter));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Class<?> $classType = this.getClassType();
        result = result * 59 + ($classType == null ? 43 : $classType.hashCode());
        Function<List<String>, Tuple2<Optional<A>, List<String>>> $parser = this.getParser();
        result = result * 59 + ($parser == null ? 43 : $parser.hashCode());
        Function<ParseContext, List<String>> $contextualTabCompleter = this.getContextualTabCompleter();
        result = result * 59 + ($contextualTabCompleter == null ? 43 : $contextualTabCompleter.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Argument(name=" + this.getName() + ", classType=" + this.getClassType() + ", parser=" + this.getParser() + ", contextualTabCompleter=" + this.getContextualTabCompleter() + ")";
    }

    @Generated
    public Argument<A> withName(String name) {
        return this.name == name ? this : new Argument<A>(name, this.classType, this.parser, this.contextualTabCompleter);
    }

    @Generated
    public Argument<A> withClassType(Class<?> classType) {
        return this.classType == classType ? this : new Argument<A>(this.name, classType, this.parser, this.contextualTabCompleter);
    }

    @Generated
    public Argument<A> withParser(Function<List<String>, Tuple2<Optional<A>, List<String>>> parser) {
        return this.parser == parser ? this : new Argument<A>(this.name, this.classType, parser, this.contextualTabCompleter);
    }

    @Generated
    public Argument<A> withContextualTabCompleter(Function<ParseContext, List<String>> contextualTabCompleter) {
        return this.contextualTabCompleter == contextualTabCompleter ? this : new Argument<A>(this.name, this.classType, this.parser, contextualTabCompleter);
    }
}

