/*
 * Decompiled with CFR 0.152.
 */
package io.typst.command;

import io.typst.command.algebra.Either;
import io.typst.command.algebra.Tuple2;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public final class Converters {
    public static Optional<Integer> parseInt(String s) {
        return Either.catching(() -> Integer.parseInt(s)).toJavaOptional();
    }

    public static Optional<Long> parseLong(String s) {
        return Either.catching(() -> Long.parseLong(s)).toJavaOptional();
    }

    public static Optional<Float> parseFloat(String s) {
        return Either.catching(() -> Float.valueOf(Float.parseFloat(s))).toJavaOptional();
    }

    public static Optional<Double> parseDouble(String s) {
        return Either.catching(() -> Double.parseDouble(s)).toJavaOptional();
    }

    public static Optional<Boolean> parseBoolean(String s) {
        return Either.catching(() -> Boolean.parseBoolean(s)).toJavaOptional();
    }

    public static Optional<Map<Object, Object>> asMap(Object o) {
        return o instanceof Map ? Optional.of((Map)o) : Optional.empty();
    }

    public static <K, V> Optional<Map<K, V>> toMapAs(Function<Tuple2<Object, Object>, Tuple2<K, V>> f, Object o) {
        return Converters.asMap(o).map(m -> m.entrySet().stream().map(pair -> (Tuple2)f.apply(new Tuple2(pair.getKey(), pair.getValue()))).collect(Collectors.toMap(Tuple2::getA, Tuple2::getB, (a, b) -> b, LinkedHashMap::new)));
    }

    public static Optional<Collection<Object>> asCollection(Object o) {
        return o instanceof Collection ? Optional.of((Collection)o) : Optional.empty();
    }

    public static <A> Optional<Collection<A>> toCollectionAs(Function<Object, A> f, Object o) {
        return Converters.asCollection(o).map(xs -> xs.stream().map(f).collect(Collectors.toList()));
    }

    public static <A> Stream<A> toStream(Optional<A> aO) {
        Object a = aO.orElse(null);
        return a != null ? Stream.of(a) : Stream.empty();
    }

    public static <A, B> Function<A, Stream<B>> toStreamF(Function<A, Optional<B>> f) {
        return a -> Converters.toStream((Optional)f.apply(a));
    }

    @Generated
    private Converters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

