/*
 * Decompiled with CFR 0.152.
 */
package io.typst.command;

import io.typst.command.CommandSpec;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class CommandHelp {
    private final String label;
    private final List<String> arguments;
    private final CommandSpec spec;
    private final String language;

    public static String format(CommandHelp help) {
        String space;
        String label = help.getLabel();
        CommandSpec spec = help.getSpec();
        List<String> args = help.getArguments();
        String string = space = args.isEmpty() ? "" : " ";
        String argSuffix = help.getLanguage().equals("ko") ? (spec.getArguments().stream().anyMatch(arg -> !arg.getName().isEmpty()) ? space + "\u00a7e" + spec.getArguments().stream().map(s -> String.format("(%s)", CommandHelp.translateToKor(s.getName()))).collect(Collectors.joining(" ")) : "") : (spec.getArguments().stream().anyMatch(arg -> !arg.getName().isEmpty()) ? space + "\u00a7e" + spec.getArguments().stream().map(arg -> String.format("(%s)", arg.getName())).collect(Collectors.joining(" ")) : "");
        String description = spec.getDescription();
        String descSuffix = description.isEmpty() ? "" : " \u00a7f- " + description;
        return String.format("\u00a7a/%s %s", label, String.join((CharSequence)" ", args)) + argSuffix + descSuffix;
    }

    public static String translateToKor(String argumentName) {
        switch (argumentName) {
            case "string": {
                return "\ubb38\uc790\uc5f4";
            }
            case "int": 
            case "long": {
                return "\uc815\uc218";
            }
            case "float": 
            case "double": {
                return "\uc2e4\uc218";
            }
            case "bool": {
                return "bool";
            }
            case "strings": {
                return "\ubb38\uc790\uc5f4..";
            }
        }
        return argumentName;
    }

    @Generated
    private CommandHelp(String label, List<String> arguments, CommandSpec spec, String language) {
        this.label = label;
        this.arguments = arguments;
        this.spec = spec;
        this.language = language;
    }

    @Generated
    public static CommandHelp of(String label, List<String> arguments, CommandSpec spec, String language) {
        return new CommandHelp(label, arguments, spec, language);
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public List<String> getArguments() {
        return this.arguments;
    }

    @Generated
    public CommandSpec getSpec() {
        return this.spec;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandHelp)) {
            return false;
        }
        CommandHelp other = (CommandHelp)o;
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        List<String> this$arguments = this.getArguments();
        List<String> other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        CommandSpec this$spec = this.getSpec();
        CommandSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !((Object)this$spec).equals(other$spec)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        return !(this$language == null ? other$language != null : !this$language.equals(other$language));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        List<String> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        CommandSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : ((Object)$spec).hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CommandHelp(label=" + this.getLabel() + ", arguments=" + this.getArguments() + ", spec=" + this.getSpec() + ", language=" + this.getLanguage() + ")";
    }

    @Generated
    public CommandHelp withLabel(String label) {
        return this.label == label ? this : new CommandHelp(label, this.arguments, this.spec, this.language);
    }

    @Generated
    public CommandHelp withArguments(List<String> arguments) {
        return this.arguments == arguments ? this : new CommandHelp(this.label, arguments, this.spec, this.language);
    }

    @Generated
    public CommandHelp withSpec(CommandSpec spec) {
        return this.spec == spec ? this : new CommandHelp(this.label, this.arguments, spec, this.language);
    }

    @Generated
    public CommandHelp withLanguage(String language) {
        return this.language == language ? this : new CommandHelp(this.label, this.arguments, this.spec, language);
    }
}

