/*
 * Decompiled with CFR 0.152.
 */
package io.typst.command;

import io.typst.command.Argument;
import io.typst.command.CommandFailure;
import io.typst.command.CommandSuccess;
import io.typst.command.CommandTabResult;
import io.typst.command.algebra.Either;
import io.typst.command.algebra.Functor;
import io.typst.command.algebra.Option;
import io.typst.command.algebra.Tuple2;
import io.typst.command.function.Function3;
import io.typst.command.function.Function4;
import io.typst.command.function.Function5;
import io.typst.command.function.Function6;
import io.typst.command.function.Function7;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public interface Command<A> {
    public <B> Command<B> map(Function<? super A, ? extends B> var1);

    @SafeVarargs
    public static <A> Mapping<A> mapping(Tuple2<String, Command<? extends A>> ... entries) {
        LinkedHashMap<String, Command<? extends A>> map = new LinkedHashMap<String, Command<? extends A>>();
        for (Tuple2<String, Command<A>> tuple2 : entries) {
            map.put(tuple2.getA(), tuple2.getB());
        }
        return new Mapping(map, null);
    }

    public static <A> Parser<A> present(A value) {
        return Command.argument(() -> value);
    }

    public static <T> Parser<T> argument(Supplier<T> f) {
        return new Parser(args -> new Tuple2(new Option.Some(f.get()), (List)args), Collections.emptyList(), "", "");
    }

    public static <T, A> Parser<T> argument(Function<? super A, ? extends T> f, Argument<A> argument) {
        return new Parser(args -> argument.getParser().apply((List<String>)args).map1(a -> Functor.map(Option.from(a), f)), Collections.singletonList(argument), "", "");
    }

    public static <T, A, B> Parser<T> argument(BiFunction<? super A, ? super B, ? extends T> f, Argument<A> argA, Argument<B> argB) {
        return new Parser(args -> {
            Tuple2 aPair = argA.getParser().apply((List<String>)args);
            Tuple2 bPair = argB.getParser().apply(aPair.getB());
            return new Tuple2(Option.from(aPair.getA().flatMap(a -> ((Optional)bPair.getA()).map((? super T b) -> f.apply((Object)a, (Object)b)))), bPair.getB());
        }, Arrays.asList(argA, argB), "", "");
    }

    public static <T, A, B, C> Parser<T> argument(Function3<? super A, ? super B, ? super C, ? extends T> f, Argument<A> argA, Argument<B> argB, Argument<C> argC) {
        return new Parser(args -> {
            Tuple2 aPair = argA.getParser().apply((List<String>)args);
            Tuple2 bPair = argB.getParser().apply(aPair.getB());
            Tuple2 cPair = argC.getParser().apply(bPair.getB());
            return new Tuple2(Option.from(aPair.getA().flatMap(a -> ((Optional)bPair.getA()).flatMap(b -> ((Optional)cPair.getA()).map((? super T c) -> f.apply(a, b, c))))), cPair.getB());
        }, Arrays.asList(argA, argB, argC), "", "");
    }

    public static <T, A, B, C, D> Parser<T> argument(Function4<? super A, ? super B, ? super C, ? super D, ? extends T> f, Argument<A> argA, Argument<B> argB, Argument<C> argC, Argument<D> argD) {
        return new Parser(args -> {
            Tuple2 aPair = argA.getParser().apply((List<String>)args);
            Tuple2 bPair = argB.getParser().apply(aPair.getB());
            Tuple2 cPair = argC.getParser().apply(bPair.getB());
            Tuple2 dPair = argD.getParser().apply(cPair.getB());
            return new Tuple2(Option.from(aPair.getA().flatMap(a -> ((Optional)bPair.getA()).flatMap(b -> ((Optional)cPair.getA()).flatMap(c -> ((Optional)dPair.getA()).map((? super T d) -> f.apply(a, b, c, d)))))), dPair.getB());
        }, Arrays.asList(argA, argB, argC, argD), "", "");
    }

    public static <T, A, B, C, D, E> Parser<T> argument(Function5<? super A, ? super B, ? super C, ? super D, ? super E, ? extends T> f, Argument<A> argA, Argument<B> argB, Argument<C> argC, Argument<D> argD, Argument<E> argE) {
        return new Parser(args -> {
            Tuple2 aPair = argA.getParser().apply((List<String>)args);
            Tuple2 bPair = argB.getParser().apply(aPair.getB());
            Tuple2 cPair = argC.getParser().apply(bPair.getB());
            Tuple2 dPair = argD.getParser().apply(cPair.getB());
            Tuple2 ePair = argE.getParser().apply(dPair.getB());
            return new Tuple2(Option.from(aPair.getA().flatMap(a -> ((Optional)bPair.getA()).flatMap(b -> ((Optional)cPair.getA()).flatMap(c -> ((Optional)dPair.getA()).flatMap(d -> ((Optional)ePair.getA()).map((? super T e) -> f.apply(a, b, c, d, e))))))), ePair.getB());
        }, Arrays.asList(argA, argB, argC, argD, argE), "", "");
    }

    public static <T, A, B, C, D, E, F> Parser<T> argument(Function6<? super A, ? super B, ? super C, ? super D, ? super E, ? super F, ? extends T> f, Argument<A> argA, Argument<B> argB, Argument<C> argC, Argument<D> argD, Argument<E> argE, Argument<F> argF) {
        return new Parser(args -> {
            Tuple2 aPair = argA.getParser().apply((List<String>)args);
            Tuple2 bPair = argB.getParser().apply(aPair.getB());
            Tuple2 cPair = argC.getParser().apply(bPair.getB());
            Tuple2 dPair = argD.getParser().apply(cPair.getB());
            Tuple2 ePair = argE.getParser().apply(dPair.getB());
            Tuple2 fPair = argF.getParser().apply(ePair.getB());
            return new Tuple2(Option.from(aPair.getA().flatMap(a -> ((Optional)bPair.getA()).flatMap(b -> ((Optional)cPair.getA()).flatMap(c -> ((Optional)dPair.getA()).flatMap(d -> ((Optional)ePair.getA()).flatMap(e -> ((Optional)fPair.getA()).map((? super T fv) -> f.apply(a, b, c, d, e, fv)))))))), fPair.getB());
        }, Arrays.asList(argA, argB, argC, argD, argE, argF), "", "");
    }

    public static <T, A, B, C, D, E, F, G> Parser<T> argument(Function7<? super A, ? super B, ? super C, ? super D, ? super E, ? super F, ? super G, ? extends T> f, Argument<A> argA, Argument<B> argB, Argument<C> argC, Argument<D> argD, Argument<E> argE, Argument<F> argF, Argument<G> argG) {
        return new Parser(args -> {
            Tuple2 aPair = argA.getParser().apply((List<String>)args);
            Tuple2 bPair = argB.getParser().apply(aPair.getB());
            Tuple2 cPair = argC.getParser().apply(bPair.getB());
            Tuple2 dPair = argD.getParser().apply(cPair.getB());
            Tuple2 ePair = argE.getParser().apply(dPair.getB());
            Tuple2 fPair = argF.getParser().apply(ePair.getB());
            Tuple2 gPair = argG.getParser().apply(fPair.getB());
            return new Tuple2(Option.from(aPair.getA().flatMap(a -> ((Optional)bPair.getA()).flatMap(b -> ((Optional)cPair.getA()).flatMap(c -> ((Optional)dPair.getA()).flatMap(d -> ((Optional)ePair.getA()).flatMap(e -> ((Optional)fPair.getA()).flatMap(fv -> ((Optional)gPair.getA()).map((? super T g) -> f.apply(a, b, c, d, e, fv, g))))))))), gPair.getB());
        }, Arrays.asList(argA, argB, argC, argD, argE, argF, argG), "", "");
    }

    public static <K, V> Tuple2<K, V> pair(K key, V value) {
        return new Tuple2<K, V>(key, value);
    }

    public static <A> Either<CommandFailure<A>, CommandSuccess<A>> parse(String[] args, Command<A> command) {
        return Command.parseWithIndex(0, args, command);
    }

    public static <A> Optional<A> parseO(String[] args, Command<A> command) {
        return Command.parse(args, command).toJavaOptional().map(CommandSuccess::getCommand);
    }

    public static <A> Either<CommandFailure<A>, CommandSuccess<A>> parseWithIndex(int index, String[] args, Command<A> command) {
        String argument;
        String string = argument = args.length > index ? args[index] : null;
        if (command instanceof Mapping) {
            Mapping mapCommand = (Mapping)command;
            if (argument == null) {
                Command fallback = mapCommand.getFallback().orElse(null);
                return fallback != null ? Command.parseWithIndex(index + 1, args, fallback) : new Either.Left(new CommandFailure.FewArguments(args, index, mapCommand));
            }
            Command subCommand = mapCommand.getCommandMap().get(argument);
            return subCommand != null ? Command.parseWithIndex(index + 1, args, subCommand) : new Either.Left(new CommandFailure.UnknownSubCommand(args, index, mapCommand));
        }
        if (command instanceof Parser) {
            Parser parser = (Parser)command;
            ArrayList<String> list = index <= args.length ? new ArrayList<String>(Arrays.asList(Arrays.copyOfRange(args, index, args.length))) : Collections.emptyList();
            Tuple2 result = parser.getParser().apply((List<String>)list);
            Option aO = result.getA();
            List<String> remainList = result.getB();
            Object a = aO.getOrNull();
            int currentIndex = index + list.size() - remainList.size();
            return aO.isDefined() ? new Either.Right(new CommandSuccess(args, currentIndex, a, parser)) : new Either.Left(new CommandFailure.ParsingFailure(args, index, parser, parser.getArguments()));
        }
        throw new UnsupportedOperationException();
    }

    public static <A> CommandTabResult<A> tabComplete(String[] args, Command<A> command) {
        return Command.tabCompleteWithIndex(0, args, command);
    }

    public static <A> CommandTabResult<A> tabCompleteWithIndex(int index, String[] args, Command<A> command) {
        String arg = args.length > index ? args[index] : "";
        String arglc = arg.toLowerCase();
        if (command instanceof Mapping) {
            Mapping mapCommand = (Mapping)command;
            if (index >= args.length - 1) {
                return new CommandTabResult.Suggestions(mapCommand.getCommandMap().entrySet().stream().filter(pair -> ((String)pair.getKey()).toLowerCase().startsWith(arglc)).map((? super T pair) -> new Tuple2(pair.getKey(), Optional.of(pair.getValue()))).collect(Collectors.toList()));
            }
            Command subCommand = mapCommand.getCommandMap().get(arg);
            return subCommand != null ? Command.tabCompleteWithIndex(index + 1, args, subCommand) : new CommandTabResult.Suggestions(Collections.emptyList());
        }
        if (command instanceof Parser) {
            Parser parser = (Parser)command;
            String lastArgument = args.length >= 1 ? args[args.length - 1] : "";
            int pos = args.length - index - 1;
            List<Argument<?>> arguments = parser.getArguments();
            Supplier<List<String>> tabCompleter = arguments.size() > pos && pos >= 0 ? arguments.get(pos).getTabCompletes() : null;
            String lowerArgument = lastArgument.toLowerCase();
            List tabCompletes = tabCompleter != null ? tabCompleter.get().stream().filter(s -> s.toLowerCase().startsWith(lowerArgument)).map((? super T s) -> new Tuple2<String, Optional<Command>>((String)s, Optional.of(command))).collect(Collectors.toList()) : Collections.emptyList();
            return new CommandTabResult.Suggestions(tabCompletes);
        }
        return new CommandTabResult.Suggestions(Collections.emptyList());
    }

    public static <A> List<Map.Entry<List<String>, Command<A>>> getEntries(Command<A> cmd) {
        if (cmd instanceof Mapping) {
            Mapping mapping = (Mapping)cmd;
            return mapping.getCommandMap().entrySet().stream().flatMap(pair -> {
                String key = (String)pair.getKey();
                Command subCmd = (Command)pair.getValue();
                List subEntries = Command.getEntries(subCmd);
                return subEntries.size() >= 1 ? subEntries.stream().map((? super T subPair) -> {
                    ArrayList<String> keys = new ArrayList<String>();
                    keys.add(key);
                    keys.addAll((Collection)subPair.getKey());
                    return new AbstractMap.SimpleEntry(Stream.concat(Stream.of(key), ((List)subPair.getKey()).stream()).collect(Collectors.toList()), subPair.getValue());
                }) : Stream.of(new AbstractMap.SimpleEntry<List<String>, Command>(Collections.singletonList(key), subCmd));
            }).collect(Collectors.toList());
        }
        if (cmd instanceof Parser) {
            Parser parser = (Parser)cmd;
            return Collections.singletonList(new AbstractMap.SimpleEntry(Collections.emptyList(), cmd));
        }
        return Collections.emptyList();
    }

    public static class Parser<A>
    implements Command<A> {
        private final Function<List<String>, Tuple2<Option<A>, List<String>>> parser;
        private final List<Argument<?>> arguments;
        private final String description;
        private final String permission;

        public Parser(Function<List<String>, Tuple2<Option<A>, List<String>>> parser, List<Argument<?>> arguments, String description, String permission) {
            this.parser = parser;
            this.arguments = arguments;
            this.description = description;
            this.permission = permission;
        }

        @Override
        public <B> Parser<B> map(Function<? super A, ? extends B> f) {
            return new Parser<A>(args -> this.parser.apply((List<String>)args).map1(aO -> Functor.map(aO, f)), this.arguments, this.getDescription(), this.getPermission());
        }

        @Generated
        public Function<List<String>, Tuple2<Option<A>, List<String>>> getParser() {
            return this.parser;
        }

        @Generated
        public List<Argument<?>> getArguments() {
            return this.arguments;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getPermission() {
            return this.permission;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parser)) {
                return false;
            }
            Parser other = (Parser)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Function<List<String>, Tuple2<Option<A>, List<String>>> this$parser = this.getParser();
            Function<List<String>, Tuple2<Option<A>, List<String>>> other$parser = other.getParser();
            if (this$parser == null ? other$parser != null : !this$parser.equals(other$parser)) {
                return false;
            }
            List<Argument<?>> this$arguments = this.getArguments();
            List<Argument<?>> other$arguments = other.getArguments();
            if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$permission = this.getPermission();
            String other$permission = other.getPermission();
            return !(this$permission == null ? other$permission != null : !this$permission.equals(other$permission));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Parser;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Function<List<String>, Tuple2<Option<A>, List<String>>> $parser = this.getParser();
            result = result * 59 + ($parser == null ? 43 : $parser.hashCode());
            List<Argument<?>> $arguments = this.getArguments();
            result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $permission = this.getPermission();
            result = result * 59 + ($permission == null ? 43 : $permission.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Command.Parser(parser=" + this.getParser() + ", arguments=" + this.getArguments() + ", description=" + this.getDescription() + ", permission=" + this.getPermission() + ")";
        }

        @Generated
        public Parser<A> withParser(Function<List<String>, Tuple2<Option<A>, List<String>>> parser) {
            return this.parser == parser ? this : new Parser<A>(parser, this.arguments, this.description, this.permission);
        }

        @Generated
        public Parser<A> withArguments(List<Argument<?>> arguments) {
            return this.arguments == arguments ? this : new Parser<A>(this.parser, arguments, this.description, this.permission);
        }

        @Generated
        public Parser<A> withDescription(String description) {
            return this.description == description ? this : new Parser<A>(this.parser, this.arguments, description, this.permission);
        }

        @Generated
        public Parser<A> withPermission(String permission) {
            return this.permission == permission ? this : new Parser<A>(this.parser, this.arguments, this.description, permission);
        }
    }

    public static class Mapping<A>
    implements Command<A> {
        private final Map<String, Command<A>> commandMap;
        private final Command<A> fallback;

        private Mapping(Map<String, Command<A>> commandMap, @Nullable Command<A> fallback) {
            this.commandMap = commandMap;
            this.fallback = fallback;
        }

        @Override
        public <B> Mapping<B> map(Function<? super A, ? extends B> f) {
            HashMap<String, Command<A>> newMap = new HashMap<String, Command<A>>(this.commandMap.size());
            for (Map.Entry<String, Command<A>> pair : this.commandMap.entrySet()) {
                newMap.put(pair.getKey(), pair.getValue().map(f));
            }
            Command fallback = this.getFallback().orElse(null);
            return new Mapping<A>(newMap, fallback != null ? fallback.map(f) : null);
        }

        public Optional<Command<A>> getFallback() {
            return Optional.ofNullable(this.fallback);
        }

        @Generated
        public Map<String, Command<A>> getCommandMap() {
            return this.commandMap;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mapping)) {
                return false;
            }
            Mapping other = (Mapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Command<A>> this$commandMap = this.getCommandMap();
            Map<String, Command<A>> other$commandMap = other.getCommandMap();
            if (this$commandMap == null ? other$commandMap != null : !((Object)this$commandMap).equals(other$commandMap)) {
                return false;
            }
            Optional<Command<A>> this$fallback = this.getFallback();
            Optional<Command<A>> other$fallback = other.getFallback();
            return !(this$fallback == null ? other$fallback != null : !((Object)this$fallback).equals(other$fallback));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Mapping;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Command<A>> $commandMap = this.getCommandMap();
            result = result * 59 + ($commandMap == null ? 43 : ((Object)$commandMap).hashCode());
            Optional<Command<A>> $fallback = this.getFallback();
            result = result * 59 + ($fallback == null ? 43 : ((Object)$fallback).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Command.Mapping(commandMap=" + this.getCommandMap() + ", fallback=" + this.getFallback() + ")";
        }

        @Generated
        public Mapping<A> withCommandMap(Map<String, Command<A>> commandMap) {
            return this.commandMap == commandMap ? this : new Mapping<A>(commandMap, this.fallback);
        }

        @Generated
        public Mapping<A> withFallback(Command<A> fallback) {
            return this.fallback == fallback ? this : new Mapping<A>(this.commandMap, fallback);
        }
    }
}

