/*
 * Decompiled with CFR 0.152.
 */
package io.typst.command;

import io.typst.command.algebra.Tuple2;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;

public final class Argument<A> {
    private final String name;
    private final Class<?> classType;
    private final Function<List<String>, Tuple2<Optional<A>, List<String>>> parser;
    private final Supplier<List<String>> tabCompletes;

    public static <A> Argument<A> ofUnary(String name, Class<?> classType, Function<String, Optional<A>> parser, Supplier<List<String>> tabCompleter) {
        return Argument.of(name, classType, args -> {
            ArrayList newArgs = new ArrayList(args);
            String arg = newArgs.size() >= 1 ? (String)newArgs.remove(0) : "";
            return new Tuple2(arg.length() >= 1 ? (Optional)parser.apply(arg) : Optional.empty(), newArgs);
        }, tabCompleter);
    }

    public Argument<Optional<A>> asOptional() {
        return new Argument<Optional<A>>(this.name, this.classType, args -> this.getParser().apply((List<String>)args).map1(Optional::of), this.getTabCompletes());
    }

    public <B> Argument<B> map(Function<A, B> f) {
        return new Argument<A>(this.name, this.classType, args -> {
            Tuple2<Optional<Optional>, List<String>> pair = this.getParser().apply((List<String>)args);
            return pair.map1(a -> a.map(f));
        }, this.getTabCompletes());
    }

    @Generated
    private Argument(String name, Class<?> classType, Function<List<String>, Tuple2<Optional<A>, List<String>>> parser, Supplier<List<String>> tabCompletes) {
        this.name = name;
        this.classType = classType;
        this.parser = parser;
        this.tabCompletes = tabCompletes;
    }

    @Generated
    public static <A> Argument<A> of(String name, Class<?> classType, Function<List<String>, Tuple2<Optional<A>, List<String>>> parser, Supplier<List<String>> tabCompletes) {
        return new Argument<A>(name, classType, parser, tabCompletes);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Class<?> getClassType() {
        return this.classType;
    }

    @Generated
    public Function<List<String>, Tuple2<Optional<A>, List<String>>> getParser() {
        return this.parser;
    }

    @Generated
    public Supplier<List<String>> getTabCompletes() {
        return this.tabCompletes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Argument)) {
            return false;
        }
        Argument other = (Argument)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Class<?> this$classType = this.getClassType();
        Class<?> other$classType = other.getClassType();
        if (this$classType == null ? other$classType != null : !this$classType.equals(other$classType)) {
            return false;
        }
        Function<List<String>, Tuple2<Optional<A>, List<String>>> this$parser = this.getParser();
        Function<List<String>, Tuple2<Optional<A>, List<String>>> other$parser = other.getParser();
        if (this$parser == null ? other$parser != null : !this$parser.equals(other$parser)) {
            return false;
        }
        Supplier<List<String>> this$tabCompletes = this.getTabCompletes();
        Supplier<List<String>> other$tabCompletes = other.getTabCompletes();
        return !(this$tabCompletes == null ? other$tabCompletes != null : !this$tabCompletes.equals(other$tabCompletes));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Class<?> $classType = this.getClassType();
        result = result * 59 + ($classType == null ? 43 : $classType.hashCode());
        Function<List<String>, Tuple2<Optional<A>, List<String>>> $parser = this.getParser();
        result = result * 59 + ($parser == null ? 43 : $parser.hashCode());
        Supplier<List<String>> $tabCompletes = this.getTabCompletes();
        result = result * 59 + ($tabCompletes == null ? 43 : $tabCompletes.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Argument(name=" + this.getName() + ", classType=" + this.getClassType() + ", parser=" + this.getParser() + ", tabCompletes=" + this.getTabCompletes() + ")";
    }

    @Generated
    public Argument<A> withName(String name) {
        return this.name == name ? this : new Argument<A>(name, this.classType, this.parser, this.tabCompletes);
    }

    @Generated
    public Argument<A> withClassType(Class<?> classType) {
        return this.classType == classType ? this : new Argument<A>(this.name, classType, this.parser, this.tabCompletes);
    }

    @Generated
    public Argument<A> withParser(Function<List<String>, Tuple2<Optional<A>, List<String>>> parser) {
        return this.parser == parser ? this : new Argument<A>(this.name, this.classType, parser, this.tabCompletes);
    }

    @Generated
    public Argument<A> withTabCompletes(Supplier<List<String>> tabCompletes) {
        return this.tabCompletes == tabCompletes ? this : new Argument<A>(this.name, this.classType, this.parser, tabCompletes);
    }
}

